/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.controller.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.BaseManageController;
import kd.tmc.fpm.business.mvc.controller.IExecBiasAnalysManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AbstractFpmFormOperate;
import kd.tmc.fpm.business.mvc.controller.impl.ReportManageController;
import kd.tmc.fpm.business.mvc.service.IExecBiasAnalysisManageService;
import kd.tmc.fpm.business.mvc.service.IReportManageService;
import kd.tmc.fpm.business.mvc.service.ISumPlanManageService;
import kd.tmc.fpm.business.mvc.service.impl.ExecBiasAnalysisManageServiceImpl;
import kd.tmc.fpm.business.mvc.service.impl.ReportManageService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanManageServiceImpl;
import kd.tmc.fpm.business.mvc.view.IExecBiasAnalysManageView;
import kd.tmc.fpm.business.mvc.view.IFpmFormView;
import kd.tmc.fpm.business.spread.datamanager.CellDataUpdateInfo;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManager;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManager;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.report.IReportSpreadDataGenerator;
import kd.tmc.fpm.common.helper.LoggerPrintHelper;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;

public class ExecBiasAnalysManageController
extends BaseManageController
implements IExecBiasAnalysManageController {
    private static final Log logger = LogFactory.getLog(ExecBiasAnalysManageController.class);
    private IExecBiasAnalysManageView view;
    private IExecBiasAnalysisManageService service;
    private IReportManageService reportManageService;
    private ISumPlanManageService sumPlanManageService;

    public ExecBiasAnalysManageController(IExecBiasAnalysManageView view) {
        this.view = view;
        this.service = new ExecBiasAnalysisManageServiceImpl();
        this.reportManageService = new ReportManageService();
        this.sumPlanManageService = new SumPlanManageServiceImpl();
    }

    @Override
    public void loadReport(final long reportId, final Long systemId) {
        final String option = ResManager.loadKDString((String)"\u52a0\u8f7d\u6267\u884c\u504f\u5dee\u5206\u6790", (String)"ExecBiasAnalysManageController_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option, Boolean.FALSE){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                logger.info(String.format("\u5f00\u59cb\u52a0\u8f7d\u62a5\u8868: reportId => %s", reportId));
                return ExecBiasAnalysManageController.this.service.loadReport((Long)reportId, systemId, ExecBiasAnalysManageController.this.getCacheService(ExecBiasAnalysManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
                try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(ReportManageController.class.getSimpleName());){
                    IReportDataManagerV2 managerImpl = result.getData();
                    ReportTemplate reportTemplate = managerImpl.getReportTemplate();
                    ReportCalcModel currCalcModel = managerImpl.getCurrCalcModel();
                    span.addTag("Create spreadDataGenerator");
                    IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                    Book book = spreadDataGenerator.generate(currCalcModel);
                    span.addTag("cache Cell");
                    ExecBiasAnalysManageController.this.cacheBookCell(book, currCalcModel, reportTemplate.getTemplateType());
                    span.addTag("Refresh Page Dimension");
                    ExecBiasAnalysManageController.this.view.refreshPageDim(currCalcModel.getPageDimValList(), false, reportTemplate);
                    span.addTag("Refresh page Book");
                    ExecBiasAnalysManageController.this.view.refreshBook(book);
                    ExecBiasAnalysManageController.this.view.refreshMetric(reportTemplate);
                    span.addTag("Set cache");
                    ExecBiasAnalysManageController.this.setCache(managerImpl, option);
                }
            }
        });
    }

    @Override
    public void loadReport(long reportId, final List<Long> pageDimS, String pageId) {
        final IReportDataManagerV2 manager = this.getManagerByCache();
        final String option = ResManager.loadKDString((String)"\u5237\u65b0\u62a5\u8868", (String)"ExecBiasAnalysManageController_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<ReportCalcModel>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<ReportCalcModel> doOperate() {
                FpmOperateResult<ReportCalcModel> result;
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c, \u5f53\u524d\u9875\u9762\u7ef4\u5ea6\u6210\u5458\u53c2\u6570\u4e3a => {%s}", option, LoggerPrintHelper.printCollectionLogger((Collection)pageDimS)));
                if (pageDimS != null) {
                    result = ExecBiasAnalysManageController.this.service.loadReportCalcModelByMetricHeader(manager, pageDimS, ExecBiasAnalysManageController.this.getCellDataSource(ExecBiasAnalysManageController.this.view.getPageId()), ExecBiasAnalysManageController.this.view.getMetricHeader());
                } else {
                    FpmOperateResult<IReportDataManagerV2> rs = ExecBiasAnalysManageController.this.service.loadReport(manager.getReportId(), ExecBiasAnalysManageController.this.getCacheService(ExecBiasAnalysManageController.this.view.getPageId()), ExecBiasAnalysManageController.this.view.getMetricHeader());
                    ReportDataManager reportManager = (ReportDataManager)((Object)rs.getData());
                    ReportCalcModel currCalcModel = reportManager.getCurrCalcModel();
                    result = FpmOperateResult.success(currCalcModel);
                }
                ReportCalcModel rsData = result.getData();
                if (rsData == null && !CollectionUtils.isEmpty((Collection)pageDimS)) {
                    String errMsg = ResManager.loadKDString((String)"\u5207\u6362\u5957\u8868\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u6709\u6548\u6570\u636e\u3002", (String)"ExecBiasAnalysManageController_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    result = FpmOperateResult.error(errMsg);
                    logger.error(String.format("%s\uff0c\u53c2\u6570\u4fe1\u606f\uff1a{resultdate => %s, pageDimValList => %s}", errMsg, rsData == null ? null : FpmSerializeUtil.serialize((Object)rsData), LoggerPrintHelper.printCollectionLogger((Collection)pageDimS)));
                }
                return result;
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportCalcModel> result) {
                IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                Book book = spreadDataGenerator.generate(result.getData());
                ExecBiasAnalysManageController.this.cacheBookCell(book, result.getData(), manager.getReportTemplate().getTemplateType());
                ExecBiasAnalysManageController.this.view.refreshPageDim(result.getData().getPageDimValList(), false, manager.getReportTemplate());
                ExecBiasAnalysManageController.this.view.refreshBook(book);
                ExecBiasAnalysManageController.this.setCache(manager, option);
            }
        });
    }

    @Override
    public void loadSumReport(final long reportId, final Long systemId) {
        final String option = ResManager.loadKDString((String)"\u52a0\u8f7d\u6267\u884c\u504f\u5dee\u5206\u6790", (String)"ExecBiasAnalysManageController_3", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                return ExecBiasAnalysManageController.this.service.loadSumReport(reportId, systemId, ExecBiasAnalysManageController.this.view.getReferIndex(false), ExecBiasAnalysManageController.this.getCacheService(ExecBiasAnalysManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                IReportDataManagerV2 manager = result.getData();
                ReportDataManagerV2 managerImpl = (ReportDataManagerV2)manager;
                ReportCalcModel currCalcModel = managerImpl.getCurrCalcModel();
                ReportTemplate reportTemplate = managerImpl.getReportTemplate();
                ExecBiasAnalysManageController.this.view.refreshPageDim(currCalcModel.getPageDimValList(), true, reportTemplate);
                IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                Book book = spreadDataGenerator.generate(currCalcModel);
                ExecBiasAnalysManageController.this.cacheBookCell(book, currCalcModel, reportTemplate.getTemplateType());
                ExecBiasAnalysManageController.this.view.refreshBook(book);
                ExecBiasAnalysManageController.this.setCache(manager, option);
            }
        });
    }

    @Override
    public void loadSumReport(final long reportId, final Long systemId, final List<Long> pageDimS, final String pageId) {
        final String option = ResManager.loadKDString((String)"\u5237\u65b0\u62a5\u8868", (String)"ExecBiasAnalysManageController_4", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManager>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<IReportDataManager> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c, \u5f53\u524d\u9875\u9762\u7ef4\u5ea6\u6210\u5458\u53c2\u6570\u4e3a => {%s}", option, LoggerPrintHelper.printCollectionLogger((Collection)pageDimS)));
                return ExecBiasAnalysManageController.this.sumPlanManageService.load(reportId, systemId, pageDimS, pageId, ExecBiasAnalysManageController.this.view.getReferIndex(false));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManager> result) {
                super.onOperateSuccess(result);
                IReportDataManager manager = result.getData();
                ReportDataManager managerImpl = (ReportDataManager)manager;
                ReportCalcModel currCalcModel = managerImpl.getCurrCalcModel();
                ReportTemplate reportTemplate = managerImpl.getReportTemplate();
                ExecBiasAnalysManageController.this.view.refreshPageDim(currCalcModel.getPageDimValList(), true, reportTemplate);
                IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                Book book = spreadDataGenerator.generate(currCalcModel);
                ExecBiasAnalysManageController.this.view.refreshBook(book);
            }
        });
    }

    @Override
    public void save(final Long id) {
        final String option = ResManager.loadKDString((String)"\u4fdd\u5b58\u62a5\u8868", (String)"ExecBiasAnalysManageController_5", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c", option));
                IReportDataManagerV2 managerByCache = ExecBiasAnalysManageController.this.getManagerByCache();
                managerByCache.setCacheService(ExecBiasAnalysManageController.this.getCacheService(ExecBiasAnalysManageController.this.view.getPageId()));
                return ExecBiasAnalysManageController.this.service.save(managerByCache, ExecBiasAnalysManageController.this.getCellDataSource(ExecBiasAnalysManageController.this.view.getPageId()), id);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
            }
        });
    }

    @Override
    public void submit(final Long id) {
        final String option = ResManager.loadKDString((String)"\u63d0\u4ea4\u62a5\u8868", (String)"ExecBiasAnalysManageController_6", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c", option));
                IReportDataManagerV2 managerByCache = ExecBiasAnalysManageController.this.getManagerByCache();
                managerByCache.setCacheService(ExecBiasAnalysManageController.this.getCacheService(ExecBiasAnalysManageController.this.view.getPageId()));
                return ExecBiasAnalysManageController.this.service.submit(managerByCache, ExecBiasAnalysManageController.this.getCellDataSource(ExecBiasAnalysManageController.this.view.getPageId()), id);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
            }
        });
    }

    @Override
    public void delete(final Long id) {
        final String option = ResManager.loadKDString((String)"\u5220\u9664\u62a5\u8868", (String)"ExecBiasAnalysManageController_7", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c", option));
                IReportDataManagerV2 managerByCache = ExecBiasAnalysManageController.this.getManagerByCache();
                managerByCache.setCacheService(ExecBiasAnalysManageController.this.getCacheService(ExecBiasAnalysManageController.this.view.getPageId()));
                return ExecBiasAnalysManageController.this.service.delete(managerByCache, ExecBiasAnalysManageController.this.getCellDataSource(ExecBiasAnalysManageController.this.view.getPageId()), id);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
            }
        });
    }

    @Override
    public void updateReportData(final List<Cell> cells) {
        final IReportDataManagerV2 manager = this.getManagerByCache();
        final ArrayList reportCalcVals = new ArrayList(1);
        final String option = ResManager.loadKDString((String)"\u66f4\u65b0\u5355\u5143\u683c", (String)"ExecBiasAnalysManageController_8", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<Void>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c, \u5f53\u524d\u5f85\u66f4\u65b0\u7684\u5355\u5143\u683c\u4fe1\u606f\u4e3a => {%s}", option, LoggerPrintHelper.printCollectionLogger((Collection)cells)));
                manager.setCacheService(ExecBiasAnalysManageController.this.getCacheService(ExecBiasAnalysManageController.this.view.getPageId()));
                List<CellDataUpdateInfo> cellDataUpdateInfos = cells.stream().filter(Objects::nonNull).map(o -> {
                    CellDataUpdateInfo cellDataUpdateInfo = new CellDataUpdateInfo();
                    cellDataUpdateInfo.setRow(o.getRow());
                    cellDataUpdateInfo.setCol(o.getCol());
                    cellDataUpdateInfo.setVal(o.getNewValue());
                    return cellDataUpdateInfo;
                }).collect(Collectors.toList());
                FpmOperateResult<List<Cell>> result = ExecBiasAnalysManageController.this.service.updateReportData(manager, ExecBiasAnalysManageController.this.getCellDataSource(ExecBiasAnalysManageController.this.view.getPageId()), cellDataUpdateInfos);
                reportCalcVals.addAll((Collection)result.getData());
                return result;
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<Void> result) {
                super.onOperateSuccess(result);
                ExecBiasAnalysManageController.this.getCellDataSource(ExecBiasAnalysManageController.this.view.getPageId()).updateCell(reportCalcVals.stream().map(o -> (CacheCell)((Object)o)).collect(Collectors.toList()));
                ExecBiasAnalysManageController.this.setCache(manager, option);
            }

            @Override
            public void afterDoThings(FpmOperateResult<Void> result) {
                super.afterDoThings(result);
                if (null != cells && cells.size() > 0) {
                    ExecBiasAnalysManageController.this.view.updateCell(reportCalcVals);
                }
            }
        });
    }

    @Override
    public void release() {
        this.doFormOperate(new AbstractFpmFormOperate<Void>((IFpmFormView)this.view){

            @Override
            public FpmOperateResult<Void> doOperate() {
                return ExecBiasAnalysManageController.this.service.closeExecBiasAnalysReport(ExecBiasAnalysManageController.this.getManagerByCache());
            }
        });
    }

    private IReportDataManagerV2 getManagerByCache() {
        String managerJson = this.view.getCache().get("execbiasanalys_reportdata_manager_cache");
        return (IReportDataManagerV2)FpmSerializeUtil.deserialize((String)managerJson, ReportDataManagerV2.class);
    }

    private void setCache(IReportDataManagerV2 manager, String option) {
        String managerJson = FpmSerializeUtil.serialize((Object)manager);
        this.view.getCache().put("execbiasanalys_reportdata_manager_cache", managerJson);
        logger.info(String.format("\u3010%s\u3011\u4e1a\u52a1\u64cd\u4f5c\u7ed3\u675f: manager => {%s}", option, managerJson));
    }

    private void cacheBookCell(Book book, ReportCalcModel calcModel, TemplateType templateType) {
        List<Cell> needCacheCellList = book.getSheet().getCellList().stream().filter(item -> item.getCol() >= calcModel.getColOffset() && item.getRow() >= calcModel.getRowOffset()).collect(Collectors.toList());
        CellDataSource ds = this.getCellDataSource(this.view.getPageId());
        if (templateType == TemplateType.DETAIL) {
            ds.saveAll(needCacheCellList, CacheCell.getDetailReportCachePropList(), calcModel);
        } else {
            ds.saveAll(needCacheCellList, CacheCell.getFixReportCachePropList(), calcModel);
        }
    }
}

