/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.controller.impl;

import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fpm.business.domain.model.inspection.header.InspectHeader;
import kd.tmc.fpm.business.domain.model.inspection.header.RepairHeader;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.BaseManageController;
import kd.tmc.fpm.business.mvc.controller.IInspectionController;
import kd.tmc.fpm.business.mvc.controller.impl.AbstractFpmFormOperate;
import kd.tmc.fpm.business.mvc.service.inspection.IInspectionExecuteBizService;
import kd.tmc.fpm.business.mvc.service.inspection.context.RepairContext;
import kd.tmc.fpm.business.mvc.service.inspection.factory.DataRepairServiceFactory;
import kd.tmc.fpm.business.mvc.service.inspection.factory.InspectContextFactory;
import kd.tmc.fpm.business.mvc.service.inspection.repair.IInspectDataRepair;
import kd.tmc.fpm.business.mvc.view.IFpmFormView;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class InspectionController
extends BaseManageController
implements IInspectionController {
    private final IInspectionExecuteBizService inspectionExecuteBizService = FpmServiceFactory.getBizService(IInspectionExecuteBizService.class);
    private IFpmFormView formView;

    public InspectionController(IFpmFormView formView) {
        this.formView = formView;
    }

    @Override
    public void execute(final InspectHeader header) {
        String option = ResManager.loadKDString((String)"\u6267\u884c\u5de1\u68c0", (String)"InspectionController_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<Void>(this.formView, option){

            @Override
            public FpmOperateResult<Void> doOperate() {
                return InspectionController.this.inspectionExecuteBizService.execute(header);
            }

            @Override
            public void onOperateError(FpmOperateResult<Void> result) {
                InspectionController.this.formView.showErrMessage(result.getMessageList());
            }
        });
    }

    @Override
    public void repair(final RepairHeader header) {
        String option = ResManager.loadKDString((String)"\u6267\u884c\u4fee\u590d", (String)"InspectionController_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<Object>(this.formView, option, Boolean.FALSE){

            @Override
            public FpmOperateResult<Object> doOperate() {
                RepairContext repairContext = InspectContextFactory.getRepairContext(header);
                IInspectDataRepair inspectDataRepairService = DataRepairServiceFactory.getInspectDataRepairService(repairContext);
                return inspectDataRepairService.inspectDataRepair(repairContext);
            }

            @Override
            public void onOperateError(FpmOperateResult<Object> result) {
                InspectionController.this.formView.showErrMessage(result.getMessageList());
            }
        });
    }
}

