/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.controller.impl;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.PlanChangeRecord;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.BaseManageController;
import kd.tmc.fpm.business.mvc.controller.IPlanChangeManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AbstractFpmFormOperate;
import kd.tmc.fpm.business.mvc.controller.impl.ReportManageController;
import kd.tmc.fpm.business.mvc.enums.PlanChangeReferIndex;
import kd.tmc.fpm.business.mvc.service.IPlanChangeManageService;
import kd.tmc.fpm.business.mvc.service.impl.PlanChangeManageServiceImpl;
import kd.tmc.fpm.business.mvc.view.IFpmFormView;
import kd.tmc.fpm.business.mvc.view.IPlanChangeManageView;
import kd.tmc.fpm.business.spread.datamanager.CellDataUpdateInfo;
import kd.tmc.fpm.business.spread.datamanager.CopyDataInfo;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleConvert;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleInfo;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.report.IReportSpreadDataGenerator;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.command.event.AskExecuteEvent;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;

public class PlanChangeManageController
extends BaseManageController
implements IPlanChangeManageController {
    private IPlanChangeManageView view;
    private IPlanChangeManageService service;
    private static final Log logger = LogFactory.getLog(ReportManageController.class);

    public PlanChangeManageController(IPlanChangeManageView view) {
        this.view = view;
        this.service = new PlanChangeManageServiceImpl();
    }

    @Override
    public void load(final Long id, final Long reportId, final String pageId) {
        String option = ResManager.loadKDString((String)"\u52a0\u8f7d\u8c03\u6574\u5355", (String)"PlanChangeManageController_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option, Boolean.FALSE){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                return PlanChangeManageController.this.service.load(id, reportId, pageId, PlanChangeManageController.this.view.getReferIndex(), PlanChangeManageController.this.getCacheService(PlanChangeManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
                IReportDataManagerV2 manager = result.getData();
                ReportCalcModel currCalcModel = manager.getCurrCalcModel();
                ReportTemplate reportTemplate = manager.getReportTemplate();
                PlanChangeManageController.this.view.refreshPageDim(currCalcModel.getPageDimValList(), true, reportTemplate);
                IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                Book book = spreadDataGenerator.generate(currCalcModel);
                PlanChangeManageController.this.cacheBookCell(book, currCalcModel, reportTemplate.getTemplateType(), PlanChangeManageController.this.view.getPageId());
                PlanChangeManageController.this.renderCellStyle(PlanChangeManageController.this.getCellDataSource(PlanChangeManageController.this.view.getPageId()), manager.getSystem(), book.getSheet().getCellList());
                PlanChangeManageController.this.view.refreshBook(book);
                PlanChangeManageController.this.clearManagerCache();
                PlanChangeManageController.this.setManagerCache(manager);
            }
        });
    }

    @Override
    public void load(final Long id, final Long reportId, final List<Long> pageDimS, final String pageId) {
        String option = ResManager.loadKDString((String)"\u52a0\u8f7d\u8c03\u6574\u5355", (String)"PlanChangeManageController_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option, Boolean.FALSE){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                return PlanChangeManageController.this.service.load(id, reportId, pageDimS, pageId, PlanChangeManageController.this.view.getReferIndex(), PlanChangeManageController.this.getCacheService(PlanChangeManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
                IReportDataManagerV2 manager = result.getData();
                ReportCalcModel currCalcModel = manager.getCurrCalcModel();
                ReportTemplate reportTemplate = manager.getReportTemplate();
                PlanChangeManageController.this.view.refreshPageDim(currCalcModel.getPageDimValList(), true, reportTemplate);
                IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                Book book = spreadDataGenerator.generate(currCalcModel);
                PlanChangeManageController.this.cacheBookCell(book, currCalcModel, reportTemplate.getTemplateType(), PlanChangeManageController.this.view.getPageId());
                PlanChangeManageController.this.renderCellStyle(PlanChangeManageController.this.getCellDataSource(PlanChangeManageController.this.view.getPageId()), manager.getSystem(), book.getSheet().getCellList());
                PlanChangeManageController.this.view.refreshBook(book);
                PlanChangeManageController.this.clearManagerCache();
                PlanChangeManageController.this.setManagerCache(manager);
            }
        });
    }

    @Override
    public void save(final PlanChangeRecord planChangeRecord) {
        final String option = ResManager.loadKDString((String)"\u4fdd\u5b58\u62a5\u8868", (String)"PlanChangeManageController_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c", option));
                IReportDataManagerV2 manager = PlanChangeManageController.this.getManagerFromCache();
                return PlanChangeManageController.this.service.save(manager, planChangeRecord, PlanChangeManageController.this.getCellDataSource(PlanChangeManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
            }
        });
    }

    @Override
    public void update(final List<Cell> cells) {
        String option = ResManager.loadKDString((String)"\u66f4\u65b0\u5355\u5143\u683c", (String)"PlanChangeManageController_3", (String)"tmc-fpm-business", (Object[])new Object[0]);
        final IReportDataManagerV2 manager = this.getManagerFromCache();
        this.doFormOperate(new AbstractFpmFormOperate<List<Cell>>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<List<Cell>> doOperate() {
                manager.setCacheService(PlanChangeManageController.this.getCacheService(PlanChangeManageController.this.view.getPageId()));
                List<CellDataUpdateInfo> updateCells = cells.stream().filter(Objects::nonNull).map(cell -> new CellDataUpdateInfo(cell.getRow(), cell.getCol(), cell.getNewValue())).collect(Collectors.toList());
                return PlanChangeManageController.this.service.update(manager, updateCells, PlanChangeManageController.this.getCellDataSource(PlanChangeManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<List<Cell>> result) {
                super.onOperateSuccess(result);
                List<Cell> cells2 = result.getData();
                CellDataSource cellDataSource = PlanChangeManageController.this.getCellDataSource(PlanChangeManageController.this.view.getPageId());
                cellDataSource.updateCell(cells2.stream().map(o -> (CacheCell)((Object)o)).collect(Collectors.toList()));
                PlanChangeManageController.this.setManagerCache(manager);
                if (EmptyUtil.isNoEmpty(cells2)) {
                    cells2.forEach(cell -> {
                        String cellStyleMark = cell.getCellStyleMark();
                        AuxiliaryCellStyleInfo auxiliaryCellStyleInfo = new AuxiliaryCellStyleConvert().toAuxiliaryCellStyle(cellStyleMark);
                        CellStyleInfo cellStyleInfo = auxiliaryCellStyleInfo.generateStyle();
                        cell.setStyleInfo(cellStyleInfo);
                        cell.setColSpan(1);
                        cell.setRowSpan(1);
                    });
                    PlanChangeManageController.this.renderCellStyle(cellDataSource, manager.getSystem(), cells2);
                    PlanChangeManageController.this.view.updateCell(cells2);
                }
            }
        });
    }

    @Override
    public void release() {
        this.clearManagerCache();
        this.release(this.view.getPageId());
    }

    @Override
    public void copy(final List<Cell> cells) {
        final IReportDataManagerV2 manager = this.getManagerFromCache();
        String option = ResManager.loadKDString((String)"\u5355\u5143\u683c\u590d\u5236", (String)"PlanChangeManageController_4", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<List<Cell>>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<List<Cell>> doOperate() {
                manager.setCacheService(PlanChangeManageController.this.getCacheService(PlanChangeManageController.this.view.getPageId()));
                List<CopyDataInfo> copyDatas = cells.stream().filter(Objects::nonNull).map(cell -> new CopyDataInfo(cell.getRow(), cell.getCol(), cell.getDisplayValue())).collect(Collectors.toList());
                FpmOperateResult<List<Cell>> copyResult = PlanChangeManageController.this.service.copy(manager, copyDatas, PlanChangeManageController.this.getCellDataSource(PlanChangeManageController.this.view.getPageId()));
                return copyResult;
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<List<Cell>> result) {
                PlanChangeManageController.this.clearManagerCache();
                PlanChangeManageController.this.setManagerCache(manager);
                List<Cell> upCells = result.getData();
                if (EmptyUtil.isNoEmpty(upCells)) {
                    PlanChangeManageController.this.getCellDataSource(PlanChangeManageController.this.view.getPageId()).updateCell(upCells.stream().map(o -> (CacheCell)((Object)o)).collect(Collectors.toList()));
                    PlanChangeManageController.this.view.updateCell(upCells);
                }
            }
        });
    }

    @Override
    public void deleteRows(final AskExecuteEvent event) {
        String option = ResManager.loadKDString((String)"\u5220\u9664\u884c", (String)"PlanChangeManageController_5", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<List<Cell>>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<List<Cell>> doOperate() {
                IReportDataManagerV2 manager = PlanChangeManageController.this.getManagerFromCache();
                FpmOperateResult<List<Cell>> delRowResult = PlanChangeManageController.this.service.deleteRows(manager, PlanChangeManageController.this.getCellDataSource(PlanChangeManageController.this.view.getPageId()), event);
                if (delRowResult.isSuccess() || delRowResult.isWarning()) {
                    PlanChangeManageController.this.clearManagerCache();
                    PlanChangeManageController.this.setManagerCache(manager);
                }
                return delRowResult;
            }

            @Override
            public void afterDoThings(FpmOperateResult<List<Cell>> result) {
                super.afterDoThings(result);
                List<Cell> cells = result.getData();
                if (EmptyUtil.isNoEmpty(cells)) {
                    PlanChangeManageController.this.getCellDataSource(PlanChangeManageController.this.view.getPageId()).updateCell(cells.stream().map(o -> (CacheCell)((Object)o)).collect(Collectors.toList()));
                    PlanChangeManageController.this.view.updateCell(cells);
                }
            }
        });
    }

    public List<QFilter> getF7Filter(int row, int col, String name) {
        FpmOperateResult<List<QFilter>> qfilters = this.service.getF7Filter(this.getManagerFromCache(), col, name, this.getCellDataSource(this.view.getPageId()));
        return qfilters.getData();
    }

    private IReportDataManagerV2 getManagerFromCache() {
        String managerJson = this.view.getCache().get("adjustbill_reportdata_manager_cache");
        return (IReportDataManagerV2)FpmSerializeUtil.deserialize((String)managerJson, ReportDataManagerV2.class);
    }

    private void setManagerCache(IReportDataManagerV2 manager) {
        String managerJson = FpmSerializeUtil.serialize((Object)manager);
        this.view.getCache().put("adjustbill_reportdata_manager_cache", managerJson);
    }

    private void clearManagerCache() {
        this.view.getCache().remove("adjustbill_reportdata_manager_cache");
    }

    private void renderCellStyle(CellDataSource cellDataSource, FundPlanSystem fundPlanSystem, List<Cell> cells) {
        List<ReportCalcValTreeNode> leafColDims = cellDataSource.getMeta().getColDimTree().getLeafList();
        HashSet adjustCols = new HashSet(10);
        HashSet adjustedAvaAmtCols = new HashSet(10);
        Map<Long, String> virDimNumberMap = fundPlanSystem.getMainDimensionByDimType(DimensionType.ADJUSTDATATYPE).getMemberList().stream().filter(o -> o.getNumber().equals(PlanChangeReferIndex.ADJUSTEDAVAILABLEAMT.getValue()) || o.getNumber().equals(PlanChangeReferIndex.ADJUSTAMT.getValue())).collect(Collectors.toMap(o -> o.getId(), o -> o.getNumber()));
        leafColDims.stream().filter(o -> virDimNumberMap.containsKey(o.getCalcVal().getValue())).map(o -> o.getCalcVal()).forEach(clac -> {
            String number = (String)virDimNumberMap.get(clac.getValue());
            if (PlanChangeReferIndex.ADJUSTEDAVAILABLEAMT.getValue().equals(number)) {
                adjustedAvaAmtCols.add(clac.getCol());
            } else if (PlanChangeReferIndex.ADJUSTAMT.getValue().equals(number)) {
                adjustCols.add(clac.getCol());
            }
        });
        cells = cells.stream().filter(Objects::nonNull).filter(cell -> cell.getCellDimType() == CellDimTypeEnum.DATADIMS).collect(Collectors.toList());
        for (Cell cell2 : cells) {
            BigDecimal val;
            CellStyleInfo styleInfo = cell2.getStyleInfo();
            int col = cell2.getCol();
            if (cell2.getCellType() != CellTypeEnum.AMOUNT) continue;
            Object value = cell2.getValue();
            if (adjustCols.contains(col)) {
                if (EmptyUtil.isNoEmpty((Object)value)) {
                    styleInfo.setBkc("#DFE6FA");
                    styleInfo.setFrc("#000000");
                    continue;
                }
                styleInfo.setFrc("#999999");
                continue;
            }
            if (!adjustedAvaAmtCols.contains(col) || !EmptyUtil.isNoEmpty((Object)value) || (val = new BigDecimal(value.toString())).compareTo(BigDecimal.ZERO) >= 0) continue;
            styleInfo.setFrc("#ef4136");
        }
    }
}

