/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.controller.impl;

import java.util.List;
import kd.tmc.fpm.business.domain.model.report.LimitRecordDTO;
import kd.tmc.fpm.business.domain.model.report.LinkExecRecordParamDTO;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.helper.FormOperateHelper;
import kd.tmc.fpm.business.mvc.controller.IReportLinkExecRecordManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AbstractFpmFormOperate;
import kd.tmc.fpm.business.mvc.service.IReportLinkExecRecordBizService;
import kd.tmc.fpm.business.mvc.view.IFpmFormView;
import kd.tmc.fpm.business.mvc.view.IReportLinkExecRecordView;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class ReportLinkExecRecordManageController
implements IReportLinkExecRecordManageController {
    private final IReportLinkExecRecordView formView;
    private final IReportLinkExecRecordBizService iBizService;

    public ReportLinkExecRecordManageController(IReportLinkExecRecordView formView) {
        this.formView = formView;
        this.iBizService = FpmServiceFactory.getBizService(IReportLinkExecRecordBizService.class);
    }

    @Override
    public void loadLimitRecords(final LinkExecRecordParamDTO queryParam) {
        FormOperateHelper.doFormOperate(new AbstractFpmFormOperate<List<LimitRecordDTO>>((IFpmFormView)this.formView){

            @Override
            public FpmOperateResult<List<LimitRecordDTO>> doOperate() {
                return ReportLinkExecRecordManageController.this.iBizService.loadLimitRecords(queryParam);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<List<LimitRecordDTO>> result) {
                super.onOperateSuccess(result);
                ReportLinkExecRecordManageController.this.formView.initializeLimitEntry(result.getData(), queryParam);
            }

            @Override
            public void onOperateError(FpmOperateResult<List<LimitRecordDTO>> result) {
                super.onOperateError(result);
                ReportLinkExecRecordManageController.this.formView.showErrMessage(result.getMessageList());
            }
        });
    }
}

