/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.controller.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.domain.enums.ReportOpType;
import kd.tmc.fpm.business.domain.model.report.BizReportQueryParam;
import kd.tmc.fpm.business.domain.model.report.BizReportRefreshParam;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.BaseManageController;
import kd.tmc.fpm.business.mvc.controller.IReportManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AbstractFpmFormOperate;
import kd.tmc.fpm.business.mvc.service.IReportManageService;
import kd.tmc.fpm.business.mvc.service.impl.ReportManageService;
import kd.tmc.fpm.business.mvc.view.IFpmFormView;
import kd.tmc.fpm.business.mvc.view.IReportManageView;
import kd.tmc.fpm.business.spread.datamanager.CellDataUpdateInfo;
import kd.tmc.fpm.business.spread.datamanager.CopyDataInfo;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.ReportDataManagerFactoryV2;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleConvert;
import kd.tmc.fpm.business.spread.generator.AuxiliaryCellStyleInfo;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.report.IReportSpreadDataGenerator;
import kd.tmc.fpm.common.helper.LoggerPrintHelper;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.command.event.AskExecuteEvent;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;

public class ReportManageController
extends BaseManageController
implements IReportManageController {
    private IReportManageView view;
    private IReportManageService service;
    private static final Log logger = LogFactory.getLog(ReportManageController.class);

    public ReportManageController(IReportManageView view) {
        this.view = view;
        this.service = new ReportManageService();
    }

    @Override
    public void loadReport(final long reportId, final Long systemId, final boolean isSmartVersion) {
        final String option = ResManager.loadKDString((String)"\u52a0\u8f7d\u62a5\u8868", (String)"ReportManageController_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option, Boolean.FALSE){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                logger.info(String.format("\u5f00\u59cb\u52a0\u8f7d\u62a5\u8868: reportId => %s", reportId));
                return ReportManageController.this.service.loadReport(reportId, systemId, isSmartVersion, ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateError(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateError(result);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
                try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(ReportManageController.class.getSimpleName());){
                    IReportDataManagerV2 managerImpl = result.getData();
                    ReportTemplate reportTemplate = managerImpl.getReportTemplate();
                    ReportCalcModel currCalcModel = managerImpl.getCurrCalcModel();
                    span.addTag("Create spreadDataGenerator");
                    IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                    Book book = spreadDataGenerator.generate(currCalcModel);
                    span.addTag("cache Cell");
                    ReportManageController.this.cacheBookCell(book, currCalcModel, reportTemplate.getTemplateType(), ReportManageController.this.view.getPageId());
                    span.addTag("Refresh Page Dimension");
                    ReportManageController.this.view.refreshPageDim(currCalcModel.getPageDimValList(), false, reportTemplate);
                    span.addTag("Refresh Control");
                    ReportManageController.this.view.refreshPageControl();
                    span.addTag("Refresh page Book");
                    ReportManageController.this.renderCellStyle(book.getSheet().getCellList());
                    ReportManageController.this.view.refreshBook(book);
                    span.addTag("Set cache");
                    ReportManageController.this.setCache(managerImpl, option);
                }
            }
        });
    }

    @Override
    public void loadReportByParam(final BizReportQueryParam param) {
        final String option = ResManager.loadKDString((String)"\u52a0\u8f7d\u62a5\u8868", (String)"ReportManageController_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option, Boolean.FALSE){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                logger.info(String.format("\u5f00\u59cb\u52a0\u8f7d\u62a5\u8868: reportId => %s", param.getReportId()));
                return ReportManageController.this.service.loadReportByParam(param, ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateError(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateError(result);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
                try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(ReportManageController.class.getSimpleName());){
                    IReportDataManagerV2 managerImpl = result.getData();
                    ReportTemplate reportTemplate = managerImpl.getReportTemplate();
                    ReportCalcModel currCalcModel = managerImpl.getCurrCalcModel();
                    span.addTag("Create spreadDataGenerator");
                    IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                    Book book = spreadDataGenerator.generate(currCalcModel);
                    span.addTag("cache Cell");
                    ReportManageController.this.cacheBookCell(book, currCalcModel, reportTemplate.getTemplateType(), ReportManageController.this.view.getPageId());
                    span.addTag("Refresh Page Dimension");
                    ReportManageController.this.view.refreshPageDim(currCalcModel.getPageDimValList(), false, reportTemplate);
                    span.addTag("Refresh Control");
                    ReportManageController.this.view.refreshPageControl();
                    span.addTag("Refresh page Book");
                    ReportManageController.this.renderCellStyle(book.getSheet().getCellList());
                    ReportManageController.this.view.refreshBook(book);
                    span.addTag("Set cache");
                    ReportManageController.this.setCache(managerImpl, option);
                }
            }
        });
    }

    @Override
    public void saveReport() {
        final String option = ResManager.loadKDString((String)"\u4fdd\u5b58\u62a5\u8868", (String)"ReportManageController_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<Boolean>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<Boolean> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c", option));
                IReportDataManagerV2 manager = ReportManageController.this.getManagerByCache();
                manager.setCacheService(ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
                return ReportManageController.this.service.saveReport(manager, ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<Boolean> result) {
                super.onOperateSuccess(result);
            }
        });
    }

    @Override
    public void submitReport() {
        final String option = ResManager.loadKDString((String)"\u63d0\u4ea4\u62a5\u8868", (String)"ReportManageController_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<Boolean>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<Boolean> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c", option));
                IReportDataManagerV2 managerByCache = ReportManageController.this.getManagerByCache();
                managerByCache.setCacheService(ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
                return ReportManageController.this.service.submit(managerByCache, ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<Boolean> result) {
                super.onOperateSuccess(result);
                HashMap<String, Object> upFields = new HashMap<String, Object>();
                upFields.put("billstatus", "B");
                ReportManageController.this.view.refreshFields(upFields);
                ReportManageController.this.view.refreshPageControl();
            }
        });
    }

    @Override
    public void refreshReport(final BizReportRefreshParam param) {
        final IReportDataManagerV2 manager = this.getManagerByCache();
        final String option = ResManager.loadKDString((String)"\u5237\u65b0\u62a5\u8868", (String)"ReportManageController_3", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<ReportCalcModel>((IFpmFormView)this.view, option, Boolean.valueOf(param.showSuccessMessage())){

            @Override
            public FpmOperateResult<ReportCalcModel> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c, \u5f53\u524d\u9875\u9762\u7ef4\u5ea6\u6210\u5458\u53c2\u6570\u4e3a => {%s}", option, LoggerPrintHelper.printCollectionLogger(param.getPageDimValList())));
                manager.setCacheService(ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
                FpmOperateResult<ReportCalcModel> result = null;
                if (param.getPageDimValList() != null) {
                    result = ReportManageController.this.service.loadReportCalcModelByPageDim(manager, param.getPageDimValList(), param.isSmartVersion(), ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()));
                } else {
                    FpmOperateResult<IReportDataManagerV2> rs = ReportManageController.this.service.loadReport(manager.getReportId(), param.getSystemId(), param.isSmartVersion(), ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
                    ReportDataManagerV2 reportManager = (ReportDataManagerV2)rs.getData();
                    ReportCalcModel currCalcModel = reportManager.getCurrCalcModel();
                    result = FpmOperateResult.success(currCalcModel);
                }
                ReportCalcModel rsData = result.getData();
                if (rsData == null && !CollectionUtils.isEmpty(param.getPageDimValList())) {
                    String errMsg = ResManager.loadKDString((String)"\u5207\u6362\u5957\u8868\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230\u6709\u6548\u6570\u636e\u3002", (String)"ReportManageController_4", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    result.getMessageList().add(errMsg);
                    result = result.isSuccess() ? FpmOperateResult.error(errMsg) : result;
                    logger.error(String.format("%s\uff0c\u53c2\u6570\u4fe1\u606f\uff1a{resultdate => %s, pageDimValList => %s}", errMsg, rsData == null ? null : FpmSerializeUtil.serialize((Object)rsData), LoggerPrintHelper.printCollectionLogger(param.getPageDimValList())));
                }
                return result;
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportCalcModel> result) {
                super.onOperateSuccess(result);
                IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                Book book = spreadDataGenerator.generate(result.getData());
                ReportManageController.this.view.refreshPageDim(result.getData().getPageDimValList(), false, manager.getReportTemplate());
                ReportManageController.this.view.refreshPageControl();
                ReportManageController.this.renderCellStyle(book.getSheet().getCellList());
                ReportManageController.this.view.refreshBook(book);
                ReportManageController.this.cacheBookCell(book, result.getData(), manager.getReportTemplate().getTemplateType(), ReportManageController.this.getManagerByCache().getPageId());
                ReportManageController.this.setCache(manager, option);
            }
        });
    }

    @Override
    public void updateReportData(final List<Cell> cells) {
        final IReportDataManagerV2 manager = this.getManagerByCache();
        final ArrayList resultCells = new ArrayList(1);
        final String option = ResManager.loadKDString((String)"\u66f4\u65b0\u5355\u5143\u683c", (String)"ReportManageController_5", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<List<Cell>>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<List<Cell>> doOperate() {
                manager.setCacheService(ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
                List<CellDataUpdateInfo> cellDataUpdateInfos = cells.stream().filter(Objects::nonNull).map(o -> {
                    CellDataUpdateInfo cellDataUpdateInfo = new CellDataUpdateInfo();
                    cellDataUpdateInfo.setRow(o.getRow());
                    cellDataUpdateInfo.setCol(o.getCol());
                    cellDataUpdateInfo.setVal(o.getNewValue());
                    return cellDataUpdateInfo;
                }).collect(Collectors.toList());
                FpmOperateResult<List<Cell>> result = ReportManageController.this.service.updateReportData(manager, ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()), cellDataUpdateInfos);
                resultCells.addAll((Collection)result.getData());
                return result;
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<List<Cell>> result) {
                super.onOperateSuccess(result);
                ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()).updateCell(resultCells.stream().map(o -> (CacheCell)((Object)o)).collect(Collectors.toList()));
                ReportManageController.this.setCache(manager, option);
            }

            @Override
            public void afterDoThings(FpmOperateResult<List<Cell>> result) {
                super.afterDoThings(result);
                if (resultCells.size() > 0) {
                    resultCells.forEach(cell -> {
                        String cellStyleMark = cell.getCellStyleMark();
                        AuxiliaryCellStyleInfo auxiliaryCellStyleInfo = new AuxiliaryCellStyleConvert().toAuxiliaryCellStyle(cellStyleMark);
                        CellStyleInfo cellStyleInfo = auxiliaryCellStyleInfo.generateStyle();
                        cell.setStyleInfo(cellStyleInfo);
                        cell.setColSpan(1);
                        cell.setRowSpan(1);
                    });
                    ReportManageController.this.renderCellStyle(resultCells);
                    ReportManageController.this.view.updateCell(resultCells);
                }
            }
        });
    }

    @Override
    public void updateTotalRows(final List<Cell> cells) {
        final IReportDataManagerV2 manager = this.getManagerByCache();
        this.doFormOperate(new AbstractFpmFormOperate<List<Cell>>((IFpmFormView)this.view, "updateTotalRows"){

            @Override
            public FpmOperateResult<List<Cell>> doOperate() {
                manager.setCacheService(ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
                List<CellDataUpdateInfo> cellDataUpdateInfos = cells.stream().filter(Objects::nonNull).map(o -> {
                    CellDataUpdateInfo cellDataUpdateInfo = new CellDataUpdateInfo();
                    cellDataUpdateInfo.setRow(o.getRow());
                    cellDataUpdateInfo.setCol(o.getCol());
                    cellDataUpdateInfo.setVal(o.getValue());
                    return cellDataUpdateInfo;
                }).collect(Collectors.toList());
                this.setShowSuccessMessage(false);
                return ReportManageController.this.service.updateTotalRows(manager, ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()), cellDataUpdateInfos);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<List<Cell>> result) {
                super.onOperateSuccess(result);
                List<Cell> data = result.getData();
                if (CollectionUtils.isEmpty(data)) {
                    return;
                }
                ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()).updateCell(data.stream().map(o -> (CacheCell)((Object)o)).collect(Collectors.toList()));
                ReportManageController.this.setCache(manager, "updateTotalRows");
            }

            @Override
            public void afterDoThings(FpmOperateResult<List<Cell>> result) {
                super.afterDoThings(result);
                if (CollectionUtils.isEmpty((Collection)result.getData())) {
                    return;
                }
                ReportManageController.this.view.updateCell(result.getData());
            }
        });
    }

    @Override
    public void clearTotalRows() {
        final IReportDataManagerV2 manager = this.getManagerByCache();
        this.doFormOperate(new AbstractFpmFormOperate<List<Cell>>((IFpmFormView)this.view, "clearTotalRows"){

            @Override
            public FpmOperateResult<List<Cell>> doOperate() {
                manager.setCacheService(ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
                this.setShowSuccessMessage(false);
                return ReportManageController.this.service.clearTotalRows(manager, ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<List<Cell>> result) {
                super.onOperateSuccess(result);
                List<Cell> data = result.getData();
                if (CollectionUtils.isEmpty(data)) {
                    return;
                }
                ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()).updateCell(data.stream().map(o -> (CacheCell)((Object)o)).collect(Collectors.toList()));
                ReportManageController.this.setCache(manager, "clearTotalRows");
            }

            @Override
            public void afterDoThings(FpmOperateResult<List<Cell>> result) {
                super.afterDoThings(result);
                if (CollectionUtils.isEmpty((Collection)result.getData())) {
                    return;
                }
                ReportManageController.this.view.updateCell(result.getData());
            }
        });
    }

    @Override
    public void audit() {
        final String option = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ReportManageController_6", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c", option));
                IReportDataManagerV2 managerByCache = ReportManageController.this.getManagerByCache();
                managerByCache.setCacheService(ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ReportOpType", ReportOpType.OP.getNumber());
                TmcOperateServiceHelper.execOperate((String)"audit", (String)"fpm_report", (Object[])new Object[]{managerByCache.getReportId()}, (OperateOption)operateOption);
                return FpmOperateResult.success(managerByCache);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
                IReportDataManagerV2 manager = result.getData();
                ReportManageController.this.setCache(manager, option);
                HashMap<String, Object> upFields = new HashMap<String, Object>();
                upFields.put("billstatus", "C");
                ReportManageController.this.view.refreshFields(upFields);
                ReportManageController.this.view.refreshPageControl();
            }
        });
    }

    @Override
    public void unAudit() {
        final String option = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"ReportManageController_7", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c", option));
                IReportDataManagerV2 managerByCache = ReportManageController.this.getManagerByCache();
                managerByCache.setCacheService(ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
                return ReportManageController.this.service.unAudit(managerByCache, ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
                IReportDataManagerV2 manager = result.getData();
                ReportManageController.this.setCache(manager, option);
                HashMap<String, Object> upFields = new HashMap<String, Object>();
                upFields.put("billstatus", "A");
                ReportManageController.this.view.refreshFields(upFields);
                ReportManageController.this.view.refreshPageControl();
                ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()).batchCommit();
            }
        });
    }

    @Override
    public void unSubmit() {
        final String option = ResManager.loadKDString((String)"\u64a4\u9500", (String)"ReportManageController_8", (String)"tmc-fpm-business", (Object[])new Object[0]);
        final IFpmPageCacheService cacheService = this.getCacheService(this.view.getPageId());
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c", option));
                IReportDataManagerV2 managerByCache = ReportManageController.this.getManagerByCache();
                managerByCache.setCacheService(cacheService);
                return ReportManageController.this.service.unSubmit(managerByCache, ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
                IReportDataManagerV2 manager = result.getData();
                ReportManageController.this.setCache(manager, option);
                HashMap<String, Object> upFields = new HashMap<String, Object>();
                upFields.put("billstatus", "A");
                ReportManageController.this.view.refreshFields(upFields);
                ReportManageController.this.view.refreshPageControl();
                cacheService.batchCommit();
            }
        });
    }

    @Override
    public void copyDataHandle(final List<Cell> cellList) {
        final IReportDataManagerV2 manager = this.getManagerByCache();
        final String option = ResManager.loadKDString((String)"\u590d\u5236", (String)"ReportManageController_9", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<List<Cell>>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<List<Cell>> doOperate() {
                logger.info(String.format("%s \u64cd\u4f5c\u5f00\u59cb\u6267\u884c, \u5f53\u524d\u5f85\u590d\u5236\u7684\u5355\u5143\u683c\u4fe1\u606f\u4e3a => {%s}", option, LoggerPrintHelper.printCollectionLogger((Collection)cellList)));
                manager.setCacheService(ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
                List<CopyDataInfo> copyDataInfoLst = cellList.stream().filter(Objects::nonNull).map(o -> new CopyDataInfo(o.getRow(), o.getCol(), o.getDisplayValue())).collect(Collectors.toList());
                FpmOperateResult<List<Cell>> baseDataCopyResult = ReportManageController.this.service.copyDataHandle(manager, ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()), copyDataInfoLst);
                return baseDataCopyResult;
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<List<Cell>> result) {
                super.onOperateSuccess(result);
                ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()).updateCell(result.getData().stream().map(o -> (CacheCell)((Object)o)).collect(Collectors.toList()));
                ReportManageController.this.view.updateCell(result.getData());
                ReportManageController.this.setCache(manager, option);
            }
        });
    }

    @Override
    public void release() {
        this.release(this.view.getPageId());
    }

    @Override
    public void deleteRows(final AskExecuteEvent event) {
        this.doFormOperate(new AbstractFpmFormOperate<List<Cell>>((IFpmFormView)this.view, event.getAskExecuteCmd().getName()){

            @Override
            public FpmOperateResult<List<Cell>> doOperate() {
                return ReportManageController.this.service.deleteRows(ReportManageController.this.getManagerByCache(), ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()), event);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<List<Cell>> result) {
                super.onOperateSuccess(result);
                ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()).updateCell(result.getData().stream().map(o -> (CacheCell)((Object)o)).collect(Collectors.toList()));
            }

            @Override
            public void afterDoThings(FpmOperateResult<List<Cell>> result) {
                super.afterDoThings(result);
                List<Cell> resultCells = result.getData();
                if (null != resultCells && resultCells.size() > 0) {
                    resultCells.forEach(cell -> {
                        String cellStyleMark = cell.getCellStyleMark();
                        AuxiliaryCellStyleInfo auxiliaryCellStyleInfo = new AuxiliaryCellStyleConvert().toAuxiliaryCellStyle(cellStyleMark);
                        CellStyleInfo cellStyleInfo = auxiliaryCellStyleInfo.generateStyle();
                        cell.setStyleInfo(cellStyleInfo);
                        cell.setColSpan(1);
                        cell.setRowSpan(1);
                    });
                    ReportManageController.this.renderCellStyle(resultCells);
                    ReportManageController.this.view.cleanCell(resultCells);
                }
            }
        });
    }

    @Override
    public void smartGetVal(final boolean isSyncPlanAmt) {
        final IReportDataManagerV2 manager = this.getManagerByCache();
        final String option = ResManager.loadKDString((String)"\u667a\u80fd\u53d6\u503c", (String)"ReportManageController_10", (String)"tmc-fpm-business", (Object[])new Object[0]);
        this.doFormOperate(new AbstractFpmFormOperate<IReportDataManagerV2>((IFpmFormView)this.view, option){

            @Override
            public FpmOperateResult<IReportDataManagerV2> doOperate() {
                manager.setCacheService(ReportManageController.this.getCacheService(ReportManageController.this.view.getPageId()));
                return ReportManageController.this.service.smartGetVal(manager, ReportManageController.this.getCellDataSource(ReportManageController.this.view.getPageId()), isSyncPlanAmt);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<IReportDataManagerV2> result) {
                super.onOperateSuccess(result);
                IReportDataManagerV2 data = result.getData();
                ReportDataManagerV2 reportManager = (ReportDataManagerV2)data;
                ReportCalcModel currCalcModel = reportManager.getCurrCalcModel();
                Book book = SpreadDataGeneratorFactory.createReportDataGenerator().generate(currCalcModel);
                ReportTemplate reportTemplate = manager.getReportTemplate();
                ReportManageController.this.cacheBookCell(book, currCalcModel, reportTemplate.getTemplateType(), ReportManageController.this.view.getPageId(), Boolean.FALSE);
                ReportManageController.this.view.refreshPageDim(currCalcModel.getPageDimValList(), false, reportManager.getReportTemplate());
                ReportManageController.this.view.refreshPageControl();
                ReportManageController.this.renderCellStyle(book.getSheet().getCellList());
                ReportManageController.this.view.refreshBook(book);
                ReportManageController.this.setCache(data, option);
            }
        });
    }

    public List<QFilter> getF7Filter(int row, int col, String name) {
        FpmOperateResult<List<QFilter>> qfilters = this.service.getF7Filter(this.getManagerByCache(), this.getCellDataSource(this.view.getPageId()), row, col, name);
        return qfilters.getData();
    }

    private IReportDataManagerV2 getManagerByCache() {
        return ReportDataManagerFactoryV2.getReportDataManagerV2(this.view.getCache());
    }

    private void setCache(IReportDataManagerV2 manager, String option) {
        String managerJson = FpmSerializeUtil.serialize((Object)manager);
        this.view.getCache().put("reportdatamanager_cache", managerJson);
        logger.info(String.format("\u3010%s\u3011\u4e1a\u52a1\u64cd\u4f5c\u7ed3\u675f: manager => {%s}", option, managerJson));
    }

    public boolean hasDirty() {
        return this.getCellDataSource(this.view.getPageId()).hasDirty();
    }

    public void clearDirty() {
        this.getCellDataSource(this.view.getPageId()).clearAllDirtySet();
    }
}

