/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.controller.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.report.PlanChangeRecord;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRule;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.report.VerifyReport;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.BaseManageController;
import kd.tmc.fpm.business.mvc.controller.IReportVerifyController;
import kd.tmc.fpm.business.mvc.controller.impl.AbstractFpmFormOperate;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.service.dto.ReportRuleCheckDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportRuleCheckParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportVerifyRuleNotifyDTO;
import kd.tmc.fpm.business.mvc.service.impl.PlanChangeBizServiceImpl;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;
import kd.tmc.fpm.business.mvc.view.IFpmFormView;
import kd.tmc.fpm.business.mvc.view.IReportVerifyView;
import kd.tmc.fpm.business.service.rules.reportcheck.service.IReportRuleCheck;
import kd.tmc.fpm.business.service.rules.reportcheck.service.impl.ReportRuleCheckService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.ReportDataReceiverFactory;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;

public class ReportVerifyControllerImpl
extends BaseManageController
implements IReportVerifyController {
    private IReportVerifyView verifyView;
    private IReportRuleCheck ruleCheckSerService;
    private IDimensionRepository iDimensionRepository;
    private Long currCheckId = 0L;

    public ReportVerifyControllerImpl(IReportVerifyView verifyView) {
        this.verifyView = verifyView;
        this.ruleCheckSerService = new ReportRuleCheckService();
        this.iDimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);
    }

    public ReportVerifyControllerImpl(IReportVerifyView verifyView, Long currCheckId) {
        this.currCheckId = currCheckId;
        this.verifyView = verifyView;
        this.ruleCheckSerService = new ReportRuleCheckService();
        this.iDimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);
    }

    @Override
    public List<ReportRuleCheckDTO> loadRule(final ReportRuleCheckParamDTO checkParam) {
        FpmOperateResult<List<ReportRuleCheckDTO>> fpmOperateResult = this.doFormOperateAndReturnResult(new AbstractFpmFormOperate<List<ReportRuleCheckDTO>>((IFpmFormView)this.verifyView, ResManager.loadKDString((String)"\u7f16\u62a5\u6570\u636e\u6821\u9a8c", (String)"ReportVerifyControllerImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<List<ReportRuleCheckDTO>> doOperate() {
                FpmOperateResult<List<ReportRuleCheckDTO>> result = FpmOperateResult.success();
                List<ReportRuleCheckDTO> ruleChecks = ReportVerifyControllerImpl.this.ruleCheckSerService.initRuleCheck(checkParam);
                ArrayList<ReportRuleCheckDTO> checks = new ArrayList<ReportRuleCheckDTO>(ruleChecks.size());
                result.setData(checks);
                if (EmptyUtil.isEmpty(ruleChecks)) {
                    return ReportVerifyControllerImpl.this.getEmptyRuleResult(result, checkParam);
                }
                ReportVerifyControllerImpl.this.setFundPlanSystem(ruleChecks);
                for (ReportRuleCheckDTO checkDTO : ruleChecks) {
                    ReportVerifyControllerImpl.this.setDataSource(checkDTO);
                    List<ReportVerifyRule> verifyRuleList = ReportVerifyControllerImpl.this.ruleCheckSerService.loadRuleAndFilter(checkDTO);
                    if (CollectionUtils.isEmpty(verifyRuleList)) {
                        ReportVerifyControllerImpl.this.getFpmOperateResult(result, checkDTO);
                        continue;
                    }
                    checkDTO.setVerifyRules(verifyRuleList);
                    checks.add(checkDTO);
                }
                return result;
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<List<ReportRuleCheckDTO>> result) {
            }

            @Override
            public void onOperateError(FpmOperateResult<List<ReportRuleCheckDTO>> result) {
                if (EmptyUtil.isNoEmpty(result.getMessageList())) {
                    ReportVerifyControllerImpl.this.verifyView.showWarnMessage(String.join((CharSequence)"\n", result.getMessageList()));
                } else if (EmptyUtil.isNoEmpty((String)result.getWarnMessage())) {
                    ReportVerifyControllerImpl.this.verifyView.showWarnMessage(result.getWarnMessage());
                }
            }
        });
        return fpmOperateResult.getData();
    }

    private FpmOperateResult<List<ReportRuleCheckDTO>> getEmptyRuleResult(FpmOperateResult<List<ReportRuleCheckDTO>> result, ReportRuleCheckParamDTO checkParam) {
        boolean batchCommit;
        result.setSuccess(false);
        boolean fromCommit = !checkParam.isFromCommit();
        boolean bl = batchCommit = !checkParam.isBatchCommit();
        if (fromCommit && batchCommit) {
            result.setSuccess(false);
            Collection verifyReports = checkParam.getVerifyReports();
            verifyReports = verifyReports.stream().filter(d -> !d.getTemplate().getTemplateType().isDetail()).collect(Collectors.toList());
            if (EmptyUtil.isEmpty((Collection)verifyReports)) {
                return result;
            }
            VerifyReport report = (VerifyReport)verifyReports.iterator().next();
            OrgMember orgMember = report.getOrgMember();
            String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5f53\u524d\u65e0\u53ef\u7528\u7f16\u62a5\u6821\u9a8c\u89c4\u5219\uff0c\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"ReportVerifyControllerImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), orgMember.getName());
            result.getMessageList().add(msg);
        }
        return result;
    }

    @Override
    public Boolean loadRule(final ReportRuleCheckDTO checkDTO, BeforeDoOperationEventArgs args) {
        if (null == checkDTO) {
            return Boolean.FALSE;
        }
        FpmOperateResult<ReportRuleCheckDTO> fpmOperateResult = this.doFormOperateAndReturnResult(new AbstractFpmFormOperate<ReportRuleCheckDTO>((IFpmFormView)this.verifyView, ResManager.loadKDString((String)"\u7f16\u62a5\u6570\u636e\u6821\u9a8c", (String)"ReportVerifyControllerImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<ReportRuleCheckDTO> doOperate() {
                FpmOperateResult<ReportRuleCheckDTO> result = FpmOperateResult.success();
                String templateType = checkDTO.getTemplateType();
                Long systemId = checkDTO.getSystemId();
                if (EmptyUtil.isEmpty((String)templateType)) {
                    DynamicObject reportObj = QueryServiceHelper.queryOne((String)"fpm_report", (String)"bodysys.id,template.templatetype", (QFilter[])new QFilter("id", "=", (Object)checkDTO.getReportId()).toArray());
                    templateType = reportObj.getString("template.templatetype");
                    systemId = reportObj.getLong("bodysys.id");
                }
                if (TemplateTypeEnum.isDetail((String)templateType)) {
                    result.setSuccess(false);
                    return result;
                }
                List<ReportVerifyRule> verifyRules = ReportVerifyControllerImpl.this.ruleCheckSerService.loadRule(systemId, checkDTO.getReportTypeId());
                if (EmptyUtil.isEmpty(verifyRules)) {
                    return ReportVerifyControllerImpl.this.getVoidFpmOperateResult(result, checkDTO);
                }
                checkDTO.setVerifyRules(verifyRules);
                ReportVerifyControllerImpl.this.setFundPlanSystem(Collections.singletonList(checkDTO));
                ReportVerifyControllerImpl.this.setDataSource(checkDTO);
                List<ReportVerifyRule> verifyRuleList = ReportVerifyControllerImpl.this.ruleCheckSerService.loadRuleAndFilter(checkDTO);
                if (CollectionUtils.isEmpty(verifyRuleList)) {
                    return ReportVerifyControllerImpl.this.getVoidFpmOperateResult(result, checkDTO);
                }
                checkDTO.setVerifyRules(verifyRuleList);
                return result;
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportRuleCheckDTO> result) {
            }

            @Override
            public void onOperateError(FpmOperateResult<ReportRuleCheckDTO> result) {
                if (EmptyUtil.isNoEmpty((String)result.getWarnMessage())) {
                    ReportVerifyControllerImpl.this.verifyView.showWarnMessage(result.getWarnMessage());
                }
            }
        });
        return fpmOperateResult.isSuccess();
    }

    private FpmOperateResult<ReportRuleCheckDTO> getVoidFpmOperateResult(FpmOperateResult<ReportRuleCheckDTO> result, ReportRuleCheckDTO checkDTO) {
        boolean batchCommit;
        result.setSuccess(false);
        boolean fromCommit = Objects.isNull(checkDTO.getFromCommit()) || checkDTO.getFromCommit() == false;
        boolean bl = batchCommit = Objects.isNull(checkDTO.getBatchCommit()) || checkDTO.getBatchCommit() == false;
        if (fromCommit && batchCommit) {
            result.setSuccess(false);
            String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5f53\u524d\u65e0\u53ef\u7528\u7f16\u62a5\u6821\u9a8c\u89c4\u5219\uff0c\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"ReportVerifyControllerImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), checkDTO.getOrgName());
            result.setWarnMessage(msg);
        }
        return result;
    }

    private FpmOperateResult<List<ReportRuleCheckDTO>> getFpmOperateResult(FpmOperateResult<List<ReportRuleCheckDTO>> result, ReportRuleCheckDTO checkDTO) {
        boolean batchCommit;
        result.setSuccess(false);
        boolean fromCommit = Objects.isNull(checkDTO.getFromCommit()) || checkDTO.getFromCommit() == false;
        boolean bl = batchCommit = Objects.isNull(checkDTO.getBatchCommit()) || checkDTO.getBatchCommit() == false;
        if (fromCommit && batchCommit) {
            result.setSuccess(false);
            String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5f53\u524d\u65e0\u53ef\u7528\u7f16\u62a5\u6821\u9a8c\u89c4\u5219\uff0c\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"ReportVerifyControllerImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), checkDTO.getOrgName());
            result.setWarnMessage(msg);
        }
        return result;
    }

    @Override
    public void ruleCheck(final ReportRuleCheckDTO checkDTO, final BeforeDoOperationEventArgs args) {
        if (null == args || null == checkDTO) {
            return;
        }
        this.doFormOperate(new AbstractFpmFormOperate<List<ReportVerifyRuleNotifyDTO>>((IFpmFormView)this.verifyView, ResManager.loadKDString((String)"\u7f16\u62a5\u6570\u636e\u6821\u9a8c", (String)"ReportVerifyControllerImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<List<ReportVerifyRuleNotifyDTO>> doOperate() {
                FpmOperateResult<List<ReportVerifyRuleNotifyDTO>> result = FpmOperateResult.success();
                if (CollectionUtils.isEmpty(checkDTO.getVerifyRules())) {
                    return result;
                }
                ReportVerifyControllerImpl.this.setFundPlanSystem(Collections.singletonList(checkDTO));
                ReportVerifyControllerImpl.this.setDataSource(checkDTO);
                List<ReportVerifyRuleNotifyDTO> notifyDTOList = ReportVerifyControllerImpl.this.ruleCheckSerService.ruleCheck(checkDTO);
                result.setSuccess(CollectionUtils.isEmpty(notifyDTOList));
                result.setSuccessMessage(ResManager.loadKDString((String)"\u7f16\u62a5\u6570\u636e\u6821\u9a8c\u68c0\u67e5\u5168\u90e8\u901a\u8fc7\u3002", (String)"ReportVerifyControllerImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
                result.setData(notifyDTOList);
                return result;
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<List<ReportVerifyRuleNotifyDTO>> result) {
                if (!checkDTO.getFromCommit().booleanValue()) {
                    ReportVerifyControllerImpl.this.verifyView.showSuccessMessage(result.getSuccessMessage());
                }
            }

            @Override
            public void onOperateError(FpmOperateResult<List<ReportVerifyRuleNotifyDTO>> result) {
                List<ReportVerifyRuleNotifyDTO> data = result.getData();
                boolean commit = data.stream().anyMatch(item -> item.getFromCommit() != null ? item.getFromCommit() : false);
                boolean batchCommit = data.stream().anyMatch(item -> item.getBatchCommit() != null ? item.getBatchCommit() : false);
                HashMap<String, String> customShowParameter = new HashMap<String, String>(8);
                customShowParameter.put("fromCommit", String.valueOf(commit));
                customShowParameter.put("batchCommit", String.valueOf(batchCommit));
                customShowParameter.put("dataVerifyResult", JSON.toJSONString(data));
                ReportVerifyControllerImpl.this.verifyView.showVerifyResultDialog(customShowParameter);
                args.setCancel(Boolean.TRUE.booleanValue());
            }
        });
    }

    private IReportDataManagerV2 getManagerV2FromCache(String cache) {
        return (IReportDataManagerV2)FpmSerializeUtil.deserialize((String)cache, ReportDataManagerV2.class);
    }

    private void setDataSource(ReportRuleCheckDTO checkDTO) {
        if (Objects.nonNull(checkDTO.getDataSource())) {
            return;
        }
        switch (checkDTO.getDataSourceType()) {
            case REPORT: {
                Report report;
                IReportDataManagerV2 managerV2 = this.getManagerV2FromCache(checkDTO.getReportManagerJson());
                ReportBizService reportBizService = new ReportBizService();
                if (Objects.nonNull(managerV2)) {
                    FpmOperateResult<Report> reportFpmOperateResult = reportBizService.loadReport(checkDTO.getReportId(), checkDTO.getSystem(), false);
                    report = reportFpmOperateResult.getData();
                    report.setTemplate(managerV2.getReportTemplate());
                    report.setReportDataList(new ArrayList<ReportData>());
                    managerV2.reverseDataToReportDataReceiver(this.getCellDataSource(this.verifyView.getPageId()), ReportDataReceiverFactory.createReportDataReceiver(report));
                } else {
                    FpmOperateResult<Report> reportFpmOperateResult = reportBizService.loadReport(checkDTO.getReportId());
                    report = reportFpmOperateResult.getData();
                }
                checkDTO.setDataSource(report);
                checkDTO.setNumber(report.getNumber());
                break;
            }
            case REPORT_SUM: {
                SumPlanRecord data;
                Optional<SumPlanReport> sumPlanReport;
                SumPlanHeader sumPlanHeader = new SumPlanHeader();
                sumPlanHeader.setDataStatus(SumPlanHeader.DATA_STATUS_INNER_CANCEL_BEFORE);
                sumPlanHeader.setShowApprovedAmt(false);
                SumPlanBizServiceImpl sumBizService = new SumPlanBizServiceImpl();
                FpmOperateResult<SumPlanRecord> sumPlanRecord = sumBizService.load(checkDTO.getRecordId(), checkDTO.getSystem(), sumPlanHeader);
                if (!sumPlanRecord.isSuccess() || !(sumPlanReport = (data = sumPlanRecord.getData()).getSumPlanReportList().stream().filter(item -> Objects.equals(checkDTO.getReportId(), item.getId())).findFirst()).isPresent()) break;
                checkDTO.setDataSource(sumPlanReport.get());
                checkDTO.setNumber(data.getNumber());
                break;
            }
            case REPORT_PLAN_CHANGE: {
                IReportDataManagerV2 managerV2 = this.getManagerV2FromCache(checkDTO.getReportManagerJson());
                PlanChangeBizServiceImpl planChangeBizService = new PlanChangeBizServiceImpl();
                if (Objects.nonNull(managerV2)) {
                    PlanChangeRecord planChangeRecord = planChangeBizService.load(checkDTO.getRecordId());
                    Optional<PlanChangeReport> planChangeReport = planChangeRecord.getChangeReportList().stream().filter(item -> Objects.equals(checkDTO.getReportId(), item.getReportId())).findFirst();
                    if (!planChangeReport.isPresent()) break;
                    PlanChangeReport changeReport = planChangeReport.get();
                    changeReport.setTemplate(managerV2.getReportTemplate());
                    if (changeReport.getReportId().compareTo(this.currCheckId) == 0) {
                        managerV2.reverseDataToReportDataReceiver(this.getCellDataSource(this.verifyView.getPageId()), ReportDataReceiverFactory.createPlanChangeDataReceiver(changeReport));
                    }
                    checkDTO.setDataSource(changeReport);
                    break;
                }
                PlanChangeRecord planChangeRecord = planChangeBizService.load(checkDTO.getRecordId());
                Optional<PlanChangeReport> planChangeReport = planChangeRecord.getChangeReportList().stream().filter(item -> Objects.equals(checkDTO.getReportId(), item.getReportId())).findFirst();
                planChangeReport.ifPresent(checkDTO::setDataSource);
                break;
            }
        }
    }

    private void setFundPlanSystem(List<ReportRuleCheckDTO> ruleChecks) {
        if (EmptyUtil.isEmpty(ruleChecks)) {
            return;
        }
        Map<Long, String> systemId2ManagerJson = ruleChecks.stream().filter(dto -> EmptyUtil.isNoEmpty((String)dto.getReportManagerJson())).filter(dto -> EmptyUtil.isNoEmpty((Long)dto.getSystemId())).collect(Collectors.toMap(ReportRuleCheckDTO::getSystemId, ReportRuleCheckDTO::getReportManagerJson, (a, b) -> a));
        HashMap<Long, FundPlanSystem> systemMap = new HashMap<Long, FundPlanSystem>(4, 1.0f);
        for (ReportRuleCheckDTO checkDTO : ruleChecks) {
            FundPlanSystem fundPlanSystem;
            if (EmptyUtil.isEmpty((Long)checkDTO.getSystemId()) || EmptyUtil.isNoEmpty((Object)checkDTO.getSystem())) continue;
            if (systemMap.containsKey(checkDTO.getSystemId())) {
                checkDTO.setSystem((FundPlanSystem)systemMap.get(checkDTO.getSystemId()));
                continue;
            }
            if (systemId2ManagerJson.containsKey(checkDTO.getSystemId())) {
                IReportDataManagerV2 managerV2 = this.getManagerV2FromCache(checkDTO.getReportManagerJson());
                fundPlanSystem = managerV2.getSystem();
            } else {
                fundPlanSystem = this.iDimensionRepository.loadSystem(checkDTO.getSystemId());
            }
            checkDTO.setSystem(fundPlanSystem);
            systemMap.put(fundPlanSystem.getId(), fundPlanSystem);
        }
    }
}

