/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.SumPlanSumType;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtDetailInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountDynamic;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;

public class ApprovedAmountRecordConverter
implements IConverter<ApprovedAmountRecord, ApprovedAmountDynamic> {
    @Override
    public ApprovedAmountRecord convert(ApprovedAmountDynamic amountDynamic) {
        DynamicObject dynamicObject = amountDynamic.getApprovedAmount();
        ApprovedAmountRecord amountRecord = new ApprovedAmountRecord();
        if (null == dynamicObject) {
            return amountRecord;
        }
        amountRecord.setId(dynamicObject.getLong("id"));
        amountRecord.setSystemId((Long)dynamicObject.getDynamicObject("systemId").getPkValue());
        amountRecord.setNumber(dynamicObject.getString("number"));
        amountRecord.setSummaryt(SumPlanSumType.valueOf(dynamicObject.getString("summaryt")));
        amountRecord.setMember((Long)dynamicObject.getDynamicObject("member").getPkValue());
        amountRecord.setOrgReportType((Long)dynamicObject.getDynamicObject("orgReportType").getPkValue());
        amountRecord.setOrgReportPeriod((Long)dynamicObject.getDynamicObject("orgReportPeriod").getPkValue());
        amountRecord.setExRateTable((Long)dynamicObject.getDynamicObject("exRateTable").getPkValue());
        amountRecord.setExRateDate(dynamicObject.getDate("exRateDate"));
        amountRecord.setAmountUnit(AmountUnit.getByNumber(dynamicObject.getString("amountunit")));
        amountRecord.setSumPlanRecordId(dynamicObject.getLong("reportid"));
        DynamicObjectCollection amountDy = dynamicObject.getDynamicObjectCollection("mentryentity");
        ArrayList<ApprovedAmountAmtInfo> amountList = new ArrayList<ApprovedAmountAmtInfo>(16);
        amountDy.stream().forEach(e -> {
            ApprovedAmountAmtInfo amountAmtInfo = new ApprovedAmountAmtInfo();
            amountAmtInfo.setId(e.getLong("id"));
            amountAmtInfo.setApprovedAmt(e.getBigDecimal("monetary"));
            amountAmtInfo.setReportDataId(e.getLong("entry_reportdataid"));
            amountAmtInfo.setReportDataIdStr(e.getString("entry_sumreportdataids"));
            if (amountDynamic.getNeedSubEntry().booleanValue()) {
                ArrayList<ApprovedAmountAmtDetailInfo> amtList = new ArrayList<ApprovedAmountAmtDetailInfo>(16);
                e.getDynamicObjectCollection("dentryentity").stream().forEach(e1 -> {
                    ApprovedAmountAmtDetailInfo amtDetailInfo = new ApprovedAmountAmtDetailInfo();
                    amtDetailInfo.setId(e1.getLong("id"));
                    amtDetailInfo.setReportId(e1.getLong("eval_reportid"));
                    amtDetailInfo.setReportDataId(e1.getLong("eval_reportdataid"));
                    amtDetailInfo.setApprovedAmt(e1.getBigDecimal("dmonetary"));
                    amtDetailInfo.setOriginalApprovedAmt(e1.getBigDecimal("eval_originalapprovalamt"));
                    amtDetailInfo.setPlanReportNumber(e1.getString("eval_planreportnumber"));
                    amtDetailInfo.setEvalAdjustReason(e1.getString("eval_evaladjustreason"));
                    amtDetailInfo.setFillUser((Long)e1.getDynamicObject("eval_filluser").getPkValue());
                    amtDetailInfo.setEvalDetail(e1.getBoolean("eval_detail"));
                    amtList.add(amtDetailInfo);
                });
                amountAmtInfo.setAmtDetailInfoList(amtList);
            }
            amountList.add(amountAmtInfo);
        });
        amountRecord.setAmountAmtInfoList(amountList);
        return amountRecord;
    }
}

