/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ExecuteNumberServiceEnum;
import kd.tmc.fpm.business.domain.model.control.BizRuleBindOperation;
import kd.tmc.fpm.business.domain.model.control.ControlExecTimeRule;

public class ControlExecTimeConverter {
    public static List<ControlExecTimeRule> batchConverterControlExecTimeRule(DynamicObject ... dataEntitys) {
        if (dataEntitys == null || dataEntitys.length == 0) {
            return new ArrayList<ControlExecTimeRule>(1);
        }
        ArrayList<ControlExecTimeRule> rules = new ArrayList<ControlExecTimeRule>(dataEntitys.length);
        for (DynamicObject dataEntity : dataEntitys) {
            List<ControlExecTimeRule> controlExecTimeRule = ControlExecTimeConverter.convterToControlExecTimeRule(dataEntity);
            rules.addAll(controlExecTimeRule);
        }
        return rules;
    }

    public static List<ControlExecTimeRule> convterToControlExecTimeRule(DynamicObject dataEntity) {
        List<ControlExecTimeRule> preTimeRules;
        ArrayList<ControlExecTimeRule> rules = new ArrayList<ControlExecTimeRule>(0);
        if (dataEntity == null) {
            return rules;
        }
        List<ControlExecTimeRule> actualTimeRules = ControlExecTimeConverter.assemblyActualTimeRule(dataEntity.getDynamicObjectCollection("entryentity_actual"));
        if (actualTimeRules.size() > 0) {
            rules.addAll(actualTimeRules);
        }
        if ((preTimeRules = ControlExecTimeConverter.preActualTimeRule(dataEntity.getDynamicObjectCollection("entryentity"))).size() > 0) {
            rules.addAll(preTimeRules);
        }
        return rules;
    }

    public static List<DynamicObject> converterToDO(List<ControlExecTimeRule> controlExecTimeRuleLst) {
        if (controlExecTimeRuleLst == null || controlExecTimeRuleLst.size() == 0) {
            return null;
        }
        ArrayList<DynamicObject> opBizRulePOLst = new ArrayList<DynamicObject>(controlExecTimeRuleLst.size());
        Map<Long, List<ControlExecTimeRule>> ruleMaps = controlExecTimeRuleLst.stream().filter(Objects::nonNull).filter(o -> Objects.nonNull(o.getId())).collect(Collectors.groupingBy(o -> o.getId()));
        Set<Long> ids = ruleMaps.keySet();
        DynamicObject[] opBizRulePOArr = TmcDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_opbizruleset"));
        for (DynamicObject opBizRulePO : opBizRulePOArr) {
            Long opBizRuleId = opBizRulePO.getLong("id");
            if (!Objects.nonNull(opBizRuleId)) continue;
            ControlExecTimeRule controlExecTimeRule = ruleMaps.get(opBizRuleId).get(0);
            controlExecTimeRuleLst.remove(controlExecTimeRule);
            ControlExecTimeConverter.assemblyBizRulePOOpration(controlExecTimeRule, opBizRulePO, false);
            opBizRulePOLst.add(opBizRulePO);
        }
        for (ControlExecTimeRule controlExecTimeRule : controlExecTimeRuleLst) {
            if (controlExecTimeRule == null) continue;
            DynamicObject opBizRulePO = TmcDataServiceHelper.newDynamicObject((String)"bos_opbizruleset");
            opBizRulePO.set("opbizrule", (Object)controlExecTimeRule.getOpBizRule());
            opBizRulePO.set("objecttype", (Object)controlExecTimeRule.getBindBizBill());
            opBizRulePO.set("enabled", (Object)(controlExecTimeRule.isEnable() ? "1" : "0"));
            ControlExecTimeConverter.assemblyBizRulePOOpration(controlExecTimeRule, opBizRulePO, true);
            opBizRulePOLst.add(opBizRulePO);
        }
        return opBizRulePOLst;
    }

    private static void assemblyBizRulePOOpration(ControlExecTimeRule controlExecTimeRule, DynamicObject opBizRulePO, boolean isClearEntry) {
        DynamicObjectCollection bindOpKeyEntry = opBizRulePO.getDynamicObjectCollection("entryentity");
        if (isClearEntry) {
            bindOpKeyEntry.clear();
        }
        List<BizRuleBindOperation> bizRuleBindOperations = controlExecTimeRule.getBizRuleBindOperations();
        for (BizRuleBindOperation bizRuleBindOperation : bizRuleBindOperations) {
            DynamicObject opKeyEntry = bindOpKeyEntry.addNew();
            opKeyEntry.set("operationkey", (Object)bizRuleBindOperation.getOpKey());
            opKeyEntry.set("seq", (Object)bizRuleBindOperation.getSeq());
        }
    }

    private static List<ControlExecTimeRule> assemblyActualTimeRule(DynamicObjectCollection actualEntryCol) {
        ArrayList<ControlExecTimeRule> rules = new ArrayList<ControlExecTimeRule>(10);
        for (DynamicObject actualEntryItem : actualEntryCol) {
            DynamicObject bindBillDy = actualEntryItem.getDynamicObject("entry_aclbusinessbill");
            String billName = bindBillDy.getString("id");
            if (EmptyUtil.isEmpty((String)billName)) continue;
            ControlExecTimeConverter.fillRules(actualEntryItem, "entry_acldeductioncode", billName, ExecuteNumberServiceEnum.ACTUAL_OCCUPY, rules);
            ControlExecTimeConverter.fillRules(actualEntryItem, "entry_unacldeductioncode", billName, ExecuteNumberServiceEnum.CANCLE_ACTUAL_OCCUPY, rules);
            ControlExecTimeConverter.fillRules(actualEntryItem, "entry_releaseacltimecode", billName, ExecuteNumberServiceEnum.RELEASE_ACTUAL_OCCUPY, rules);
            ControlExecTimeConverter.fillRules(actualEntryItem, "entry_aclupdatetimecode", billName, ExecuteNumberServiceEnum.UPDATE_ACTUAL_OCCUPY, rules);
        }
        return rules;
    }

    private static List<ControlExecTimeRule> preActualTimeRule(DynamicObjectCollection preEntryCol) {
        ArrayList<ControlExecTimeRule> rules = new ArrayList<ControlExecTimeRule>(10);
        for (DynamicObject preActualEntryItem : preEntryCol) {
            DynamicObject bindBillDy = preActualEntryItem.getDynamicObject("entry_businessbill");
            String billName = bindBillDy.getString("id");
            if (EmptyUtil.isEmpty((String)billName)) continue;
            ControlExecTimeConverter.fillRules(preActualEntryItem, "entry_preemptedtimecode", billName, ExecuteNumberServiceEnum.PREEMPTED_OCCUPY, rules);
            ControlExecTimeConverter.fillRules(preActualEntryItem, "entry_unpreemptedcode", billName, ExecuteNumberServiceEnum.CANCLE_PREEMPTED_OCCUPY, rules);
            ControlExecTimeConverter.fillRules(preActualEntryItem, "entry_releasecode", billName, ExecuteNumberServiceEnum.RELEASE_PREEMPTED_OCCUPY, rules);
        }
        return rules;
    }

    private static void fillRules(DynamicObject execConfigEntry, String execCodeProp, String occupyBill, ExecuteNumberServiceEnum bindOpService, List<ControlExecTimeRule> rules) {
        String execCodeStr = execConfigEntry.getString(execCodeProp);
        if (EmptyUtil.isEmpty((String)execCodeStr)) {
            return;
        }
        String[] opKeys = execCodeStr.split(",");
        ControlExecTimeRule rule = new ControlExecTimeRule();
        rule.setOpBizRule(bindOpService.getCode());
        rule.setBindBizBill(occupyBill);
        rule.setEnable(true);
        ArrayList<BizRuleBindOperation> operations = new ArrayList<BizRuleBindOperation>(opKeys.length);
        for (String opKey : opKeys) {
            BizRuleBindOperation operation = new BizRuleBindOperation();
            operation.setOpKey(opKey);
            operations.add(operation);
        }
        rule.setBizRuleBindOperations(operations);
        rules.add(rule);
    }
}

