/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.model.control.ControlRequestUpdateInfo;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.utils.CommonUtils;

public class ControlRequestUpdateInfoDynamicConverter
implements IConverter<DynamicObject, ControlRequestUpdateInfo> {
    @Override
    public DynamicObject convert(ControlRequestUpdateInfo controlRequestUpdateInfo) {
        DynamicObject dynamicObject = this.getDynamicObject(controlRequestUpdateInfo.getId());
        dynamicObject.set("id", (Object)controlRequestUpdateInfo.getId());
        dynamicObject.set("requestid", (Object)controlRequestUpdateInfo.getRequestId());
        dynamicObject.set("controlstatus", (Object)controlRequestUpdateInfo.getControlRequestStatus().getNumber());
        dynamicObject.set("billno", (Object)controlRequestUpdateInfo.getRequestId());
        dynamicObject.set("executeop", (Object)CommonUtils.getEnumNumberOrDefault(controlRequestUpdateInfo.getPlanExecuteOpType(), ""));
        dynamicObject.set("billstatus", (Object)BillStatus.STAGE.getNumber());
        this.fillEntryIfNeed(controlRequestUpdateInfo, dynamicObject);
        return dynamicObject;
    }

    private void fillEntryIfNeed(ControlRequestUpdateInfo controlRequestUpdateInfo, DynamicObject dynamicObject) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        List<ControlRequestUpdateInfo.ControlRequestDetailUpdateInfo> controlRequestDetailUpdateInfos = controlRequestUpdateInfo.getControlRequestDetailUpdateInfos();
        if (EmptyUtil.isEmpty(controlRequestDetailUpdateInfos)) {
            dynamicObjectCollection.clear();
            return;
        }
        Map entryMap = dynamicObjectCollection.stream().collect(Collectors.toMap(dy -> dy.getLong("entry_reportdataid"), Function.identity(), (a, b) -> a));
        HashSet<Long> exists = new HashSet<Long>(16);
        for (ControlRequestUpdateInfo.ControlRequestDetailUpdateInfo detailUpdateInfo : controlRequestDetailUpdateInfos) {
            Long reportDataId = detailUpdateInfo.getReportDataId();
            DynamicObject entry = (DynamicObject)entryMap.get(reportDataId);
            if (EmptyUtil.isEmpty((DynamicObject)entry)) {
                entry = dynamicObjectCollection.addNew();
            }
            exists.add(reportDataId);
            entry.set("entry_reportdataid", (Object)reportDataId);
            entry.set("entry_reportid", (Object)detailUpdateInfo.getReportId());
            entry.set("entry_lockexecuteamt", (Object)detailUpdateInfo.getLockExecuteAmt());
            entry.set("entry_factexecuteamt", (Object)detailUpdateInfo.getFactExecuteAmt());
        }
        Set waitRemove = entryMap.keySet().stream().filter(k -> !exists.contains(k)).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(waitRemove)) {
            dynamicObjectCollection.removeIf(dy -> waitRemove.contains(dy.getLong("entry_reportdataid")));
        }
    }

    private DynamicObject getDynamicObject(Long id) {
        if (TmcDataServiceHelper.exists((Object)id, (String)"fpm_controlupdateinfo")) {
            return TmcDataServiceHelper.loadSingle((Object)id, (String)"fpm_controlupdateinfo");
        }
        return BusinessDataServiceHelper.newDynamicObject((String)"fpm_controlupdateinfo");
    }
}

