/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.dimension.DimMemberMapping;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.MappingInfo;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.mvc.converter.MemberConverterFactory;
import kd.tmc.fpm.business.mvc.converter.member.IMemberConverter;
import kd.tmc.fpm.common.enums.BizBDRangeEnum;

public class DimensionPOConverter {
    public static FundPlanSystem convertToSystem(DynamicObject system, List<Dimension> dimList) {
        FundPlanSystem systemInfo = new FundPlanSystem();
        systemInfo.setId(system.getLong("id"));
        systemInfo.setName(system.getString("name"));
        systemInfo.setNumber(system.getString("number"));
        systemInfo.setOrgId(system.getDynamicObject("org").getLong("id"));
        systemInfo.setCurrencyId(system.getDynamicObject("currency").getLong("id"));
        systemInfo.setCurrencyName(system.getDynamicObject("currency").getString("name"));
        systemInfo.setExchangeRateId(system.getDynamicObject("ratetype").getLong("id"));
        systemInfo.setEnable(system.getBoolean("enable"));
        systemInfo.setShrekKey(system.getString("shrekdatakey"));
        systemInfo.setDimList(dimList);
        DynamicObjectCollection entryEntity = system.getDynamicObjectCollection("applyrereportentry");
        ArrayList<ReportPeriodType> reportPeriodTypeList = new ArrayList<ReportPeriodType>(entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            ReportPeriodType reportPeriodType = new ReportPeriodType();
            DynamicObject reportPeriodPO = entry.getDynamicObject("rerporttype");
            reportPeriodType.setEnable("enable".equals(entry.getString("rereporttypestatus")));
            reportPeriodType.setId((Long)entry.getPkValue());
            reportPeriodType.setReportPeriodId((Long)reportPeriodPO.getPkValue());
            reportPeriodType.setName(reportPeriodPO.getString("name"));
            reportPeriodType.setNumber(reportPeriodPO.getString("number"));
            reportPeriodType.setPeriodType(PeriodType.getByNumber(reportPeriodPO.getString("orgreportcycle")));
            String detailType = reportPeriodPO.getString("orgreporttype");
            if (!EmptyUtil.isEmpty((String)detailType)) {
                reportPeriodType.setDetailPeriodType(PeriodType.getByNumber(detailType));
            } else {
                reportPeriodType.setDetailPeriodType(null);
            }
            reportPeriodType.setSum(entry.getBoolean("issumreport"));
            reportPeriodType.setSumEditable(entry.getBoolean("ismodify"));
            reportPeriodType.setRoll(entry.getBoolean("isroll"));
            reportPeriodType.setRollNum(entry.getInt("rollnumber"));
            reportPeriodType.setRollIncludeDetailPeriod(entry.getBoolean("iscontaindetail"));
            reportPeriodTypeList.add(reportPeriodType);
        }
        systemInfo.setReportTypeList(reportPeriodTypeList);
        return systemInfo;
    }

    public static Dimension convertToMainDimension(DynamicObject mainDimension, List<DynamicObject> memberList) {
        Dimension dimension = new Dimension();
        dimension.setId(mainDimension.getLong("id"));
        dimension.setName(mainDimension.getString("name"));
        dimension.setNumber(mainDimension.getString("number"));
        dimension.setDimensionRel(mainDimension.getString("dimensionrel"));
        dimension.setShrekKey(mainDimension.getString("shrekdatakey"));
        Object bodySys = mainDimension.get("bodysystem");
        long sysId = bodySys instanceof DynamicObject ? ((DynamicObject)bodySys).getLong("id") : Long.parseLong(bodySys.toString());
        dimension.setSystemId(sysId);
        dimension.setDimType(DimensionType.getDimsionByNumber(mainDimension.getString("basedata")));
        IMemberConverter memberConverter = MemberConverterFactory.createMemberConverterByDimType(dimension.getDimType());
        if (!CollectionUtils.isEmpty(memberList)) {
            List<DimMember> memberTreeList = memberConverter.convertToMemberTree(memberList);
            dimension.setMemberList(memberTreeList);
        }
        dimension.setMustInput(true);
        return dimension;
    }

    public static List<Dimension> convertToDetailDimension(DynamicObject[] detailDimensionArr) {
        ArrayList<Dimension> detailDimList = new ArrayList<Dimension>(detailDimensionArr.length);
        for (DynamicObject detailDimension : detailDimensionArr) {
            detailDimList.add(DimensionPOConverter.convertToDetailDimension(detailDimension));
        }
        return detailDimList;
    }

    public static Dimension convertToDetailDimension(DynamicObject detailDimension, Long detailDimId) {
        long sysId = detailDimension.getDynamicObject("bodysys").getLong("id");
        DynamicObjectCollection entryList = detailDimension.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryList) {
            long entryId = entry.getLong("id");
            if (!detailDimId.equals(entryId)) continue;
            return DimensionPOConverter.convertToDetailDimension(entry, sysId);
        }
        return null;
    }

    private static Dimension convertToDetailDimension(DynamicObject detailDimEntry) {
        Dimension dimension = new Dimension();
        dimension.setId(detailDimEntry.getLong("id"));
        dimension.setSystemId(detailDimEntry.getLong("bodysys.id"));
        dimension.setName(detailDimEntry.getString("name"));
        dimension.setNumber(detailDimEntry.getString("detaildimtype"));
        dimension.setDimType(DimensionType.DETAILDIM);
        dimension.setDetailDimType(DetailDimType.getDimsionByNumber(detailDimEntry.getString("detaildimtype")));
        MemberType memberType = MemberType.getDimsionByNumber(detailDimEntry.getString("datatype"));
        dimension.setMemberType(memberType);
        if (memberType == MemberType.ENUM) {
            String enumVal = detailDimEntry.getString("option");
            dimension.setMemberValList(Arrays.asList(enumVal.split(",")));
        }
        dimension.setBaseDataType(detailDimEntry.getString("basedatatype.number"));
        dimension.setMustInput(detailDimEntry.getBoolean("ismustinput"));
        dimension.setVisible(detailDimEntry.getBoolean("isshow"));
        return dimension;
    }

    public static DimMemberMapping convertToDimMemberMapping(DynamicObject dynamicObject) {
        List<Long> mainIds;
        DimMemberMapping dimMemberMapping = new DimMemberMapping();
        dimMemberMapping.setId(dynamicObject.getLong("id"));
        dimMemberMapping.setNumber(dynamicObject.getString("number"));
        dimMemberMapping.setName(dynamicObject.getString("name"));
        dimMemberMapping.setMainEntityType(dynamicObject.getDynamicObject("bizbasedata").getString("number"));
        dimMemberMapping.setDimId(dynamicObject.getLong(String.join((CharSequence)".", "dimension", "id")));
        dimMemberMapping.setAssistEntity(dynamicObject.getBoolean("useassistbasedata"));
        if (dynamicObject.getBoolean("useassistbasedata")) {
            dimMemberMapping.setAssistEntityType(dynamicObject.getDynamicObject("assistbizbasedata").getString("number"));
        }
        DynamicObjectCollection entryInfoColl = dynamicObject.getDynamicObjectCollection("entryentity");
        ArrayList<MappingInfo> mappingInfos = new ArrayList<MappingInfo>(entryInfoColl.size());
        boolean needSubLevel = entryInfoColl.stream().anyMatch(item -> BizBDRangeEnum.SUBLEVEL.getValue().equals(item.getString("bizbdrange")));
        ArrayList<DimTreeNode> allSubDimList = new ArrayList<DimTreeNode>(16);
        if (needSubLevel && !(mainIds = entryInfoColl.stream().filter(e -> BizBDRangeEnum.SUBLEVEL.getValue().equals(e.getString("bizbdrange"))).map(e -> e.getLong("bizbasedatadetailid")).collect(Collectors.toList())).isEmpty()) {
            DynamicObject mainObj = BusinessDataServiceHelper.newDynamicObject((String)dimMemberMapping.getMainEntityType());
            DynamicObjectType objectType = mainObj.getDynamicObjectType();
            IDataEntityProperty parent = (IDataEntityProperty)objectType.getProperties().get((Object)"parent");
            IDataEntityProperty parentId = (IDataEntityProperty)objectType.getProperties().get((Object)"parentid");
            if (parent != null) {
                DimensionPOConverter.getAllSubData(dimMemberMapping.getMainEntityType(), mainIds, allSubDimList, "parent");
            } else if (parentId != null) {
                DimensionPOConverter.getAllSubData(dimMemberMapping.getMainEntityType(), mainIds, allSubDimList, "parentid");
            }
        }
        for (DynamicObject entryInfo : entryInfoColl) {
            String bizRange = entryInfo.getString("bizbdrange");
            long mainId = entryInfo.getLong("bizbasedatadetailid");
            HashSet<Long> mainIdList = new HashSet<Long>(16);
            mainIdList.add(mainId);
            if (BizBDRangeEnum.SUBLEVEL.getValue().equals(bizRange)) {
                ArrayList<Long> subIdList = new ArrayList<Long>(10);
                DimensionPOConverter.getAllSubId(allSubDimList, mainId, subIdList);
                mainIdList.addAll(subIdList);
            }
            for (Long currMainId : mainIdList) {
                MappingInfo mappingInfo = new MappingInfo();
                mappingInfo.setMainId(currMainId);
                mappingInfo.setAssistId(entryInfo.getLong("assistbasedatadetailid"));
                mappingInfo.setMemberId(entryInfo.getLong(String.join((CharSequence)".", "dimmember", "id")));
                mappingInfos.add(mappingInfo);
            }
        }
        dimMemberMapping.setMappings(mappingInfos);
        return dimMemberMapping;
    }

    private static void getAllSubId(List<DimTreeNode> allSubDimList, Long parentId, List<Long> subIdList) {
        Set treeNodes = allSubDimList.stream().filter(n -> n.getParentId().equals(parentId)).map(DimTreeNode::getId).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(treeNodes)) {
            return;
        }
        subIdList.addAll(treeNodes);
        for (Long nodeId : treeNodes) {
            DimensionPOConverter.getAllSubId(allSubDimList, nodeId, subIdList);
        }
    }

    private static void getAllSubData(String entityNumber, List<Long> parentIds, List<DimTreeNode> resultList, String parentIdProp) {
        DynamicObjectCollection subObjList = QueryServiceHelper.query((String)entityNumber, (String)("id," + parentIdProp), (QFilter[])new QFilter(parentIdProp, "in", parentIds).toArray());
        if (!subObjList.isEmpty()) {
            ArrayList<Long> subIdList = new ArrayList<Long>(subObjList.size());
            for (DynamicObject subObj : subObjList) {
                long id = subObj.getLong("id");
                resultList.add(new DimTreeNode(id, subObj.getLong(parentIdProp)));
                subIdList.add(id);
            }
            DimensionPOConverter.getAllSubData(entityNumber, subIdList, resultList, parentIdProp);
        }
    }

    private static class DimTreeNode {
        private Long id;
        private Long parentId;

        public DimTreeNode(Long id, Long parentId) {
            this.id = id;
            this.parentId = parentId;
        }

        public Long getId() {
            return this.id;
        }

        public Long getParentId() {
            return this.parentId;
        }
    }
}

