/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.SumPlanSumType;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelDetail;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRecord;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;

public class InnerCancelRecordDynamicConverter {
    public static void convert(InnerCancelRecord innerCancelRecord, DynamicObject dynamicObject) {
        dynamicObject.set("cancelruleentryid", (Object)innerCancelRecord.getCancelRuleEntryId());
        dynamicObject.set("sumplanrecordid", (Object)innerCancelRecord.getSumPlanRecordId());
        dynamicObject.set("cancelruleid", (Object)innerCancelRecord.getCancelRuleId());
        dynamicObject.set("systemid", (Object)innerCancelRecord.getSystemId());
        dynamicObject.set("summarytype", (Object)SumPlanSumType.REPORTPLAN.getNumber());
        dynamicObject.set("orgreporttype", (Object)innerCancelRecord.getOrgReportTypeId());
        dynamicObject.set("orgid", (Object)innerCancelRecord.getOrgId());
        dynamicObject.set("orgreportperiod", (Object)innerCancelRecord.getOrgReportPeriod());
        dynamicObject.set("cancelperiod", (Object)innerCancelRecord.getCancelPeriod());
        dynamicObject.set("currencymap", (Object)innerCancelRecord.getCurrencyMap());
        dynamicObject.set("exratetable", (Object)innerCancelRecord.getExchangeRateTableId());
        dynamicObject.set("exratedate", (Object)innerCancelRecord.getRateDate());
        dynamicObject.set("amountunit", (Object)innerCancelRecord.getAmountUnit().getNumber());
        dynamicObject.set("remark", (Object)innerCancelRecord.getRemark());
        dynamicObject.set("creator", (Object)innerCancelRecord.getCreator());
        dynamicObject.set("modifytime", (Object)innerCancelRecord.getModifyTime());
        dynamicObject.set("modifier", (Object)innerCancelRecord.getModifier());
        dynamicObject.set("createtime", (Object)innerCancelRecord.getCreateTime());
        dynamicObject.set("cancelrulename", (Object)innerCancelRecord.getCancelRuleName());
        dynamicObject.set("cancelruleentryname", (Object)innerCancelRecord.getCancelRuleEntryName());
        HashMap<String, Set> prop2MemberIdMap = new HashMap<String, Set>(8);
        prop2MemberIdMap.put("applyoptionaldim", new HashSet<Long>(innerCancelRecord.getOtherOptionalDimList()));
        prop2MemberIdMap.put("applyoptionaldim1", new HashSet<Long>(innerCancelRecord.getOtherOptionalDim1List()));
        prop2MemberIdMap.put("applyoptionaldim2", new HashSet<Long>(innerCancelRecord.getOtherOptionalDim2List()));
        prop2MemberIdMap.put("inflowsubject", new HashSet<Long>(innerCancelRecord.getInflowSubject()));
        prop2MemberIdMap.put("outflowsubject", new HashSet<Long>(innerCancelRecord.getOutflowSubject()));
        Object[] needQueryDimMemberIdArr = (Long[])prop2MemberIdMap.values().stream().flatMap(Collection::stream).toArray(Long[]::new);
        DynamicObject[] queryMemberDyArr = TmcDataServiceHelper.load((Object[])needQueryDimMemberIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_member"));
        prop2MemberIdMap.forEach((prop, memberIdSet) -> {
            DynamicObject[] dimMemberDyArr = (DynamicObject[])Arrays.stream(queryMemberDyArr).filter(member -> memberIdSet.contains(member.getPkValue())).toArray(DynamicObject[]::new);
            DynamicObjectCollection multiPropValColl = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)dynamicObject, (DynamicObjectType)dynamicObject.getDynamicObjectType(), (String)prop, (DynamicObject[])dimMemberDyArr);
            dynamicObject.set(prop, (Object)multiPropValColl);
        });
        dynamicObject.set("currencyid", (Object)innerCancelRecord.getCurrencyId());
        dynamicObject.set("currency", (Object)innerCancelRecord.getCurrency());
        dynamicObject.set("diffprocessmodetype", (Object)Optional.ofNullable(innerCancelRecord.getDiffProcessModeType()).map(o -> o.getNumber()).orElseGet(() -> null));
        dynamicObject.set("billno", (Object)innerCancelRecord.getBillNo());
        dynamicObject.set("billstatus", (Object)innerCancelRecord.getBillStatus());
        DynamicObjectCollection details = dynamicObject.getDynamicObjectCollection("entryentity");
        Set<Long> reportIds = innerCancelRecord.getCancelDetailList().stream().map(InnerCancelDetail::getReportId).collect(Collectors.toSet());
        ReportRepository reportRepository = new ReportRepository();
        Map<Long, String> reportMap = reportRepository.loadReportNumber(reportIds);
        innerCancelRecord.getCancelDetailList().forEach(r -> {
            DynamicObject dO = new DynamicObject(details.getDynamicObjectType());
            dO.set("cancelorgid", (Object)r.getOrgId());
            dO.set("subjectid", (Object)r.getSubjectId());
            dO.set("entrycompanyid", (Object)r.getCompanyId());
            dO.set("entrysettletypeid", (Object)r.getSettleTypeId());
            dO.set("entryotherdimid", (Object)r.getOtherDimId());
            dO.set("entryotherdimid1", (Object)r.getOtherDimId1());
            dO.set("entryotherdimid2", (Object)r.getOtherDimId2());
            dO.set("reportid", (Object)r.getReportId());
            dO.set("reportdataid", (Object)r.getReportDataId());
            if (reportMap.containsKey(r.getReportId())) {
                dO.set("reportnumber", reportMap.get(r.getReportId()));
            }
            dO.set("cancelamt", (Object)r.getCancelAmt());
            dO.set("balanceamt", (Object)r.getBalanceAmt());
            dO.set("avcancelamt", (Object)r.getAvCancelAmt());
            dO.set("offsetbatchnumber", (Object)r.getOffsetBatchNumber());
            dO.set("oursideorg", (Object)r.getOurSideOrg());
            dO.set("correspondenceorgname", (Object)r.getCorrespondenceOrgName());
            details.add((Object)dO);
        });
        DynamicObjectCollection totalEntryCol = dynamicObject.getDynamicObjectCollection("totalentry");
        innerCancelRecord.getInnerCancleTotals().forEach(entry -> {
            DynamicObject dy = new DynamicObject(totalEntryCol.getDynamicObjectType());
            dy.set("entry_offset_batch_number", (Object)entry.getOffsetBatchNumber());
            dy.set("entry_offset_detail_num", (Object)entry.getOffsetNumber());
            String direction = Optional.ofNullable(entry.getDiffDirection()).map(o -> o.getDirection()).orElseGet(() -> null);
            dy.set("entry_diff_direction", (Object)direction);
            dy.set("entry_offset_amt_sum", (Object)entry.getSumCancelAmount());
            dy.set("entry_diff_amt_sum", (Object)entry.getSumDiffAmount());
            totalEntryCol.add((Object)dy);
        });
    }
}

