/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.tmc.fpm.business.domain.enums.DiffProcessModeType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.model.sumplan.AccurateMatchScheme;
import kd.tmc.fpm.business.domain.model.sumplan.InnerRuleSubjectConfig;
import kd.tmc.fpm.business.mvc.converter.control.Converter;
import kd.tmc.fpm.common.bean.SubjectCancelConfig;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import org.apache.commons.lang3.StringUtils;

public class InnerRuleSubjectConfigConverter
implements Converter<InnerRuleSubjectConfig> {
    @Override
    public InnerRuleSubjectConfig convert(DynamicObject dynamicObject) {
        InnerRuleSubjectConfig innerRuleSubjectConfig = new InnerRuleSubjectConfig();
        innerRuleSubjectConfig.setId((Long)dynamicObject.getPkValue());
        innerRuleSubjectConfig.setSeq(dynamicObject.getInt("seq"));
        innerRuleSubjectConfig.setName(dynamicObject.getString("entry_rulename"));
        String inConfigJson = dynamicObject.getString("entry_inconfigreal_tag");
        String outConfigJson = dynamicObject.getString("entry_outconfigreal_tag");
        innerRuleSubjectConfig.setInSubjectOrderList(this.getSubjectOrderFromJson(inConfigJson));
        innerRuleSubjectConfig.setOutSubjectOrderList(this.getSubjectOrderFromJson(outConfigJson));
        innerRuleSubjectConfig.setAccurateMatchMode(dynamicObject.getBoolean("entry_accurate_match_mode"));
        String mode = dynamicObject.getString("entry_diff_process_mode");
        innerRuleSubjectConfig.setDiffProcessMode(ITypeEnum.getByNumber(mode, DiffProcessModeType.class));
        String schemeJson = dynamicObject.getString("entry_offset_scheme_save_tag");
        innerRuleSubjectConfig.setScheme(this.getMatchSchemeFormJson(schemeJson));
        String schemeName = dynamicObject.getString("entry_offset_scheme");
        innerRuleSubjectConfig.setSchemeName(schemeName);
        return innerRuleSubjectConfig;
    }

    private AccurateMatchScheme getMatchSchemeFormJson(String schemeJson) {
        if (StringUtils.isEmpty((CharSequence)schemeJson)) {
            return null;
        }
        AccurateMatchScheme scheme = (AccurateMatchScheme)FpmSerializeUtil.deserialize((String)schemeJson, AccurateMatchScheme.class);
        return scheme;
    }

    private List<InnerRuleSubjectConfig.SubjectOrder> getSubjectOrderFromJson(String configJson) {
        if (StringUtils.isEmpty((CharSequence)configJson)) {
            return Collections.emptyList();
        }
        SubjectCancelConfig subjectCancelConfig = (SubjectCancelConfig)SerializationUtils.fromJsonString((String)configJson, SubjectCancelConfig.class);
        List subjectList = subjectCancelConfig.getSubjectList();
        ArrayList<InnerRuleSubjectConfig.SubjectOrder> subjectOrderList = new ArrayList<InnerRuleSubjectConfig.SubjectOrder>(subjectList.size());
        for (SubjectCancelConfig.Subject subject : subjectList) {
            InnerRuleSubjectConfig.SubjectOrder subjectOrder = new InnerRuleSubjectConfig.SubjectOrder();
            subjectOrder.setSubjectId(subject.getId());
            subjectOrder.setSeq(subject.getSeq());
            subjectOrderList.add(subjectOrder);
            subjectOrder.setParentId(subject.getParentId());
        }
        return subjectOrderList;
    }
}

