/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fpm.business.domain.enums.ApplyStatus;
import kd.tmc.fpm.business.domain.enums.ApprovalStatus;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.BusinessType;
import kd.tmc.fpm.business.domain.enums.DataSourceType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InoutDirectionType;
import kd.tmc.fpm.business.domain.enums.OpUserType;
import kd.tmc.fpm.business.domain.model.inoutpool.InoutCollect;
import kd.tmc.fpm.business.mvc.converter.control.Converter;

public class InoutCollectConverter
implements Converter<InoutCollect> {
    @Override
    public InoutCollect convert(DynamicObject dynamicObject) {
        InoutCollect inoutCollect = new InoutCollect();
        this.populateHead(dynamicObject, inoutCollect);
        this.populateEntry(inoutCollect, dynamicObject);
        return inoutCollect;
    }

    private void populateEntry(InoutCollect inoutCollect, DynamicObject dynamicObject) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
        ArrayList<InoutCollect.InoutReportRelation> relationList = new ArrayList<InoutCollect.InoutReportRelation>(dynamicObjectCollection.size());
        for (DynamicObject entry : dynamicObjectCollection) {
            InoutCollect.InoutReportRelation inoutReportRelation = new InoutCollect.InoutReportRelation();
            inoutReportRelation.setBatchNo(entry.getString("entry_batchno"));
            inoutReportRelation.setPlanReport(entry.getString("entry_relateplanreport"));
            inoutReportRelation.setPlanReportId(entry.getLong("entry_relateplanreportid"));
            inoutReportRelation.setBodySysId(entry.getLong(String.join((CharSequence)".", "entry_bodysys", "id")));
            inoutReportRelation.setReportTypeId(entry.getLong(String.join((CharSequence)".", "entry_reporttype", "id")));
            inoutReportRelation.setReportOrgId(entry.getLong(String.join((CharSequence)".", "entry_reportorg", "id")));
            inoutReportRelation.setReportPeriodId(entry.getLong(String.join((CharSequence)".", "entry_reportperiod", "id")));
            inoutReportRelation.setReferPlanDate(entry.getDate("entry_referplandate"));
            inoutReportRelation.setReferPlanAmount(entry.getBigDecimal("entry_referplanamount"));
            relationList.add(inoutReportRelation);
        }
        inoutCollect.setInoutReportRelationList(relationList);
    }

    private void populateHead(DynamicObject dynamicObject, InoutCollect inoutCollect) {
        inoutCollect.setId((Long)dynamicObject.getPkValue());
        inoutCollect.setNumber(dynamicObject.getString("billno"));
        inoutCollect.setBusinessType(ITypeEnum.getByNumber(dynamicObject.getString("businesstype"), BusinessType.class));
        inoutCollect.setApplyOrgId(dynamicObject.getLong(String.join((CharSequence)".", "applyorg", "id")));
        inoutCollect.setApplyUserId(dynamicObject.getLong(String.join((CharSequence)".", "applyuser", "id")));
        inoutCollect.setCreateDate(dynamicObject.getDate("createdate"));
        inoutCollect.setBillStatus(ITypeEnum.getByNumber(dynamicObject.getString("billstatus"), BillStatus.class));
        inoutCollect.setApprovalStatus(ITypeEnum.getByNumber(dynamicObject.getString("approvalstatus"), ApprovalStatus.class));
        inoutCollect.setApplyStatus(ITypeEnum.getByNumber(dynamicObject.getString("applystatus"), ApplyStatus.class));
        inoutCollect.setRemark(dynamicObject.getString("remark"));
        inoutCollect.setDataSourceType(ITypeEnum.getByNumber(dynamicObject.getString("datasource"), DataSourceType.class));
        inoutCollect.setSourceBill(dynamicObject.getString(String.join((CharSequence)".", "sourcebill", "id")));
        inoutCollect.setSourceBillNumber(dynamicObject.getString("sourcebillnumber"));
        inoutCollect.setSourceBillId(dynamicObject.getLong("sourcebillid"));
        inoutCollect.setSourceBillEntryId(dynamicObject.getLong("sourcebillentryid"));
        inoutCollect.setAbandonStatus(dynamicObject.getBoolean("abandonstatus"));
        inoutCollect.setAbandonReason(dynamicObject.getString("abandonreason"));
        inoutCollect.setBatchNo(dynamicObject.getString("batchno"));
        inoutCollect.setFundOrgId(dynamicObject.getLong(String.join((CharSequence)".", "fundorg", "id")));
        inoutCollect.setInoutDirectionType(ITypeEnum.getByNumber(dynamicObject.getString("inoutdirection"), InoutDirectionType.class));
        inoutCollect.setFundPurposeId(dynamicObject.getLong(String.join((CharSequence)".", "fundpurpose", "id")));
        inoutCollect.setFeeProjectId(dynamicObject.getLong(String.join((CharSequence)".", "feeproject", "id")));
        inoutCollect.setSettleTypeId(dynamicObject.getLong(String.join((CharSequence)".", "settletype", "id")));
        inoutCollect.setOpUserType(ITypeEnum.getByNumber(dynamicObject.getString("opusertype"), OpUserType.class));
        inoutCollect.setOpUserName(dynamicObject.getLong(String.join((CharSequence)".", "opusername", "id")));
        inoutCollect.setCurrencyId(dynamicObject.getLong(String.join((CharSequence)".", "currency", "id")));
        inoutCollect.setExpectDate(dynamicObject.getDate("expectdate"));
        inoutCollect.setCurrentPlanDate(dynamicObject.getDate("currentplandate"));
        inoutCollect.setExpectCashAmount(dynamicObject.getBigDecimal("expectcashamount"));
        inoutCollect.setCurrentPlanAmount(dynamicObject.getBigDecimal("currentplanamount"));
        inoutCollect.setCoreBillSumAmount(dynamicObject.getBigDecimal("corebillsumamount"));
        inoutCollect.setCoreBillRemainCashAmt(dynamicObject.getBigDecimal("corebillremaincashamt"));
        inoutCollect.setContractNo(dynamicObject.getString("contractno"));
        inoutCollect.setContractName(dynamicObject.getString("contractname"));
        inoutCollect.setProjectId(dynamicObject.getLong(String.join((CharSequence)".", "project", "id")));
    }
}

