/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.model.inoutpool.InoutCollect;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;

public class InoutCollectDynamicConverter
implements IConverter<DynamicObject, InoutCollect> {
    @Override
    public DynamicObject convert(InoutCollect inoutCollect) {
        DynamicObject inoutCollectDynamicObject = this.getInoutCollectDynamicObject(inoutCollect.getId());
        this.populateHead(inoutCollectDynamicObject, inoutCollect);
        this.populateEntry(inoutCollectDynamicObject, inoutCollect);
        return inoutCollectDynamicObject;
    }

    private void populateEntry(DynamicObject inoutCollectDynamicObject, InoutCollect inoutCollect) {
        List<InoutCollect.InoutReportRelation> inoutReportRelationList = inoutCollect.getInoutReportRelationList();
        DynamicObjectCollection dynamicObjectCollection = inoutCollectDynamicObject.getDynamicObjectCollection("entryentity");
        dynamicObjectCollection.clear();
        if (CollectionUtils.isEmpty(inoutReportRelationList)) {
            return;
        }
        for (InoutCollect.InoutReportRelation reportRelation : inoutReportRelationList) {
            DynamicObject dynamicObject = dynamicObjectCollection.addNew();
            dynamicObject.set("entry_batchno", (Object)reportRelation.getBatchNo());
            dynamicObject.set("entry_relateplanreport", (Object)reportRelation.getPlanReport());
            dynamicObject.set("entry_relateplanreportid", (Object)reportRelation.getPlanReportId());
            dynamicObject.set("entry_bodysys", (Object)reportRelation.getBodySysId());
            dynamicObject.set("entry_reporttype", (Object)reportRelation.getReportTypeId());
            dynamicObject.set("entry_reportorg", (Object)reportRelation.getReportOrgId());
            dynamicObject.set("entry_reportperiod", (Object)reportRelation.getReportPeriodId());
            dynamicObject.set("entry_referplandate", (Object)reportRelation.getReferPlanDate());
            dynamicObject.set("entry_referplanamount", (Object)reportRelation.getReferPlanAmount());
        }
    }

    private void populateHead(DynamicObject inoutCollectDynamicObject, InoutCollect inoutCollect) {
        inoutCollectDynamicObject.set("id", (Object)inoutCollect.getId());
        inoutCollectDynamicObject.set("billno", (Object)inoutCollect.getNumber());
        inoutCollectDynamicObject.set("businesstype", (Object)this.filterNull(inoutCollect.getBusinessType()));
        inoutCollectDynamicObject.set("applyorg", (Object)inoutCollect.getApplyOrgId());
        inoutCollectDynamicObject.set("applyuser", (Object)inoutCollect.getApplyUserId());
        inoutCollectDynamicObject.set("createdate", (Object)inoutCollect.getCreateDate());
        inoutCollectDynamicObject.set("billstatus", (Object)this.filterNull(inoutCollect.getBillStatus()));
        inoutCollectDynamicObject.set("approvalstatus", (Object)this.filterNull(inoutCollect.getApprovalStatus()));
        inoutCollectDynamicObject.set("applystatus", (Object)this.filterNull(inoutCollect.getApplyStatus()));
        inoutCollectDynamicObject.set("remark", (Object)inoutCollect.getRemark());
        inoutCollectDynamicObject.set("creator", (Object)inoutCollect.getCreateId());
        inoutCollectDynamicObject.set("createtime", (Object)inoutCollect.getCreateTime());
        inoutCollectDynamicObject.set("datasource", (Object)this.filterNull(inoutCollect.getDataSourceType()));
        inoutCollectDynamicObject.set("sourcebill", (Object)inoutCollect.getSourceBill());
        inoutCollectDynamicObject.set("sourcebillnumber", (Object)inoutCollect.getSourceBillNumber());
        inoutCollectDynamicObject.set("sourcebillid", (Object)inoutCollect.getSourceBillId());
        inoutCollectDynamicObject.set("sourcebillentryid", (Object)inoutCollect.getSourceBillEntryId());
        inoutCollectDynamicObject.set("abandonstatus", (Object)inoutCollect.getApplyStatus());
        inoutCollectDynamicObject.set("abandonreason", (Object)inoutCollect.getAbandonReason());
        inoutCollectDynamicObject.set("batchno", (Object)inoutCollect.getBatchNo());
        inoutCollectDynamicObject.set("fundorg", (Object)inoutCollect.getFundOrgId());
        inoutCollectDynamicObject.set("inoutdirection", (Object)this.filterNull(inoutCollect.getInoutDirectionType()));
        inoutCollectDynamicObject.set("fundpurpose", (Object)inoutCollect.getFundPurposeId());
        inoutCollectDynamicObject.set("feeproject", (Object)inoutCollect.getFeeProjectId());
        inoutCollectDynamicObject.set("settletype", (Object)inoutCollect.getSettleTypeId());
        inoutCollectDynamicObject.set("opusertype", (Object)this.filterNull(inoutCollect.getOpUserType()));
        inoutCollectDynamicObject.set("opusername", (Object)inoutCollect.getOpUserName());
        inoutCollectDynamicObject.set("currency", (Object)inoutCollect.getCurrencyId());
        inoutCollectDynamicObject.set("expectdate", (Object)inoutCollect.getExpectDate());
        inoutCollectDynamicObject.set("currentplandate", (Object)inoutCollect.getCurrentPlanDate());
        inoutCollectDynamicObject.set("expectcashamount", (Object)inoutCollect.getExpectCashAmount());
        inoutCollectDynamicObject.set("currentplanamount", (Object)inoutCollect.getCurrentPlanAmount());
        inoutCollectDynamicObject.set("corebillsumamount", (Object)inoutCollect.getCoreBillSumAmount());
        inoutCollectDynamicObject.set("corebillremaincashamt", (Object)inoutCollect.getCoreBillRemainCashAmt());
        inoutCollectDynamicObject.set("contractno", (Object)inoutCollect.getContractNo());
        inoutCollectDynamicObject.set("contractname", (Object)inoutCollect.getContractName());
        inoutCollectDynamicObject.set("project", (Object)inoutCollect.getProjectId());
    }

    private String filterNull(ITypeEnum iTypeEnum) {
        return iTypeEnum == null ? "" : iTypeEnum.getNumber();
    }

    private DynamicObject getInoutCollectDynamicObject(Long id) {
        boolean exists = TmcDataServiceHelper.exists((Object)id, (String)"fpm_inoutcollect");
        DynamicObject inoutCollectDynamicObject = exists ? TmcDataServiceHelper.loadSingle((Object)id, (String)"fpm_inoutcollect") : TmcDataServiceHelper.newDynamicObject((String)"fpm_inoutcollect");
        return inoutCollectDynamicObject;
    }
}

