/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.sumplan.MainEntryReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.converter.ReportPoConverter;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.service.dimension.impl.CustomDimSeqServiceImpl;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.helper.StringHelper;

public class MainEntryReportDataDynamicConverter
implements IConverter<DynamicObject, MainEntryReportData> {
    @Override
    public DynamicObject convert(MainEntryReportData reportData) {
        if (Objects.isNull(reportData)) {
            return null;
        }
        DynamicObject mainDimEntry = this.getDynamicObject();
        this.fillEntry(mainDimEntry, reportData);
        return mainDimEntry;
    }

    private void fillEntry(DynamicObject mainEntry, MainEntryReportData reportData) {
        this.fillMainEntry(mainEntry, reportData);
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim = dimList.get(i);
            Object value = dimValList.get(i);
            DimensionType dimType = templateDim.getDimType();
            if (DimensionType.METRIC.getNumber().equals(dimType.getNumber()) || Objects.equals(DimensionType.DETAILDIM.getNumber(), dimType.getNumber())) continue;
            if (DimensionType.CUSTOM.getNumber().equals(dimType.getNumber())) {
                this.fillCustomDimVal(mainEntry, value, templateDim, reportData.getSystemId());
                continue;
            }
            String entrySignByDimType = MainEntryReportDataDynamicConverter.getEntrySignByDimType(dimType.getNumber());
            if (StringUtils.isEmpty((Object)entrySignByDimType)) continue;
            mainEntry.set(String.join((CharSequence)"_", entrySignByDimType, "id"), value);
        }
    }

    private void fillCustomDimVal(DynamicObject entryDy, Object value, TemplateDim templateDim, Long systemId) {
        if (EmptyUtil.isEmpty((Long)systemId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u586b\u5145\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u65f6\u7f3a\u5c11\u4f53\u7cfbID", (String)"ReportDataDynamicEntryConverter_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        ICustomDimSeqService iCustomDimSeqService = FpmServiceFactory.getBizService(ICustomDimSeqService.class);
        Map<Long, Integer> customDimSeqMap = iCustomDimSeqService.loadCustomDimSeqMap(systemId);
        Integer storeSeq = customDimSeqMap.get(templateDim.getDimensionId());
        String storeProperty = CustomDimSeqServiceImpl.seq2ReportCustomPropertyMap.get(storeSeq);
        DynamicObject dynamicObject = TmcDataServiceHelper.newDynamicObject((String)"fpm_member");
        dynamicObject.set("id", value);
        entryDy.set(storeProperty, (Object)dynamicObject);
    }

    private static String getEntrySignByDimType(String number) {
        return ReportPoConverter.TYPE_MAPPING_MAP.get(number);
    }

    private void fillMainEntry(DynamicObject mainEntry, MainEntryReportData reportData) {
        mainEntry.set("id", (Object)reportData.getId());
        mainEntry.set(String.join((CharSequence)"_", "system", "id"), (Object)reportData.getSystemId());
        mainEntry.set("orgplanamt", (Object)reportData.getOriginalPlanAmt());
        mainEntry.set("reportplanamt", (Object)reportData.getReportPlanAmt());
        mainEntry.set("planreferenceamt", (Object)reportData.getPlanReferenceAmt());
        mainEntry.set("planamt", (Object)reportData.getPlanAmt());
        mainEntry.set("realamt", (Object)reportData.getActAmt());
        mainEntry.set("lockamt", (Object)reportData.getLockAmt());
        mainEntry.set("version", (Object)reportData.getVersion());
        mainEntry.set("origindatarow", (Object)reportData.getRow());
        mainEntry.set("origindatacol", (Object)reportData.getCol());
        mainEntry.set("effectflag", (Object)reportData.isEffectFlag());
        mainEntry.set("offsetamt", (Object)reportData.getOffsetAmt());
        mainEntry.set(String.join((CharSequence)"_", "entryreportperiod", "id"), (Object)reportData.getReportPeriodId());
        mainEntry.set("maintable", (Object)(reportData.isMainTable() ? "1" : "0"));
        mainEntry.set("amountunit", (Object)(reportData.getAmountUnit() == null ? "" : reportData.getAmountUnit().getNumber()));
        if (reportData.getSourceIdList() != null) {
            String sourceIdStr = String.join((CharSequence)",", reportData.getSourceIdList().stream().map(item -> item.toString()).collect(Collectors.toList()));
            mainEntry.set("sourceid_tag", (Object)sourceIdStr);
            mainEntry.set("sourceid", (Object)StringHelper.subString((String)sourceIdStr, (int)50, (String[])new String[]{","}));
        } else {
            mainEntry.set("sourceid", (Object)" ");
            mainEntry.set("sourceid_tag", (Object)" ");
        }
    }

    private DynamicObject getDynamicObject() {
        DynamicObject dynamicObject = TmcDataServiceHelper.newDynamicObject((String)"fpm_report");
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("maindimentry");
        return dynamicObjectCollection.addNew();
    }
}

