/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.Objects;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.mvc.converter.member.AccountMemberConverter;
import kd.tmc.fpm.business.mvc.converter.member.CurrencyMemberConverter;
import kd.tmc.fpm.business.mvc.converter.member.DefaultMemberConverter;
import kd.tmc.fpm.business.mvc.converter.member.IMemberConverter;
import kd.tmc.fpm.business.mvc.converter.member.MetricMemberConverter;
import kd.tmc.fpm.business.mvc.converter.member.OrgMemberConverter;
import kd.tmc.fpm.business.mvc.converter.member.PeriodMemberConverter;

public class MemberConverterFactory {
    public static IMemberConverter createMemberConverterByDimType(DimensionType dimensionType) {
        if (Objects.isNull((Object)dimensionType)) {
            return new DefaultMemberConverter();
        }
        switch (dimensionType) {
            case PERIOD: {
                return new PeriodMemberConverter();
            }
            case ORG: {
                return new OrgMemberConverter();
            }
            case SUBJECTS: {
                return new AccountMemberConverter();
            }
            case METRIC: {
                return new MetricMemberConverter();
            }
            case CURRENCY: {
                return new CurrencyMemberConverter();
            }
        }
        return new DefaultMemberConverter();
    }
}

