/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AdjustType;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.AdjustAmtInfo;
import kd.tmc.fpm.business.domain.model.report.DynamicObjectData;
import kd.tmc.fpm.business.domain.model.report.PlanChangeRecord;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReportAuxEntry;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportChangeConvertParam;
import kd.tmc.fpm.business.domain.model.report.ReportChangeData;
import kd.tmc.fpm.business.domain.model.report.ReportRowData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.mvc.converter.control.factory.ConverterFactory;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.DataSetUtil;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;

public class PlanChangeRecordConverter
implements IConverter<PlanChangeRecord, DynamicObjectData> {
    private boolean needDimIfValueIsNotEmpty = false;

    public PlanChangeRecordConverter() {
    }

    public PlanChangeRecordConverter(Boolean needDimIfValueIsNotEmpty) {
        this.needDimIfValueIsNotEmpty = needDimIfValueIsNotEmpty != null && needDimIfValueIsNotEmpty != false;
    }

    @Override
    public PlanChangeRecord convert(DynamicObjectData dynamicObjectData) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("PlanChangeRecordConverter");){
            span.addTag("base information tag.");
            PlanChangeRecord planChangeRecord = new PlanChangeRecord();
            DynamicObject dynamicObject = dynamicObjectData.getDynamicObject();
            planChangeRecord.setId(dynamicObject.getLong("id"));
            planChangeRecord.setNumber(dynamicObject.getString("billno"));
            planChangeRecord.setCreatorId(dynamicObject.getString("creator"));
            planChangeRecord.setStatus(ITypeEnum.getByNumber(dynamicObject.getString("billstatus"), BillStatus.class));
            Object bodySysObj = dynamicObject.get("bodysys");
            if (bodySysObj instanceof DynamicObject) {
                planChangeRecord.setSystemId((Long)dynamicObject.getDynamicObject("bodysys").getPkValue());
            } else {
                planChangeRecord.setSystemId((Long)bodySysObj);
            }
            Object orgObj = dynamicObject.get("reportorg");
            if (orgObj instanceof DynamicObject) {
                planChangeRecord.setReportOrg((Long)dynamicObject.getDynamicObject("reportorg").getPkValue());
            } else {
                planChangeRecord.setReportOrg((Long)orgObj);
            }
            Object reportTypeObj = dynamicObject.get("reporttype");
            if (reportTypeObj instanceof DynamicObject) {
                planChangeRecord.setReportType((Long)dynamicObject.getDynamicObject("reporttype").getPkValue());
            } else {
                planChangeRecord.setReportType((Long)reportTypeObj);
            }
            Object periodObj = dynamicObject.get("reportperiod");
            if (periodObj instanceof DynamicObject) {
                planChangeRecord.setReportPeriod((Long)dynamicObject.getDynamicObject("reportperiod").getPkValue());
            } else {
                planChangeRecord.setReportPeriod((Long)periodObj);
            }
            String reportIds = dynamicObject.getString("originalreportids");
            List<Long> originalReportIdList = StringUtils.isEmpty((CharSequence)reportIds) ? Collections.emptyList() : Arrays.stream(reportIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
            planChangeRecord.setOriginalReportIdList(originalReportIdList);
            planChangeRecord.setAdjustType(ITypeEnum.getByNumber(dynamicObject.getString("adjusttype"), AdjustType.class));
            planChangeRecord.setApplyDate(dynamicObject.getDate("applydate"));
            planChangeRecord.setMainReportId(dynamicObject.getLong("mainreportid"));
            planChangeRecord.setPageDimensionType1(dynamicObject.getString("pagedimensiontype1"));
            planChangeRecord.setPageDimensionType2(dynamicObject.getString("pagedimensiontype2"));
            planChangeRecord.setAdjustRollPeriod(dynamicObject.getBoolean("adjustrollperiod"));
            if (dynamicObjectData.isNeedConvertEntry()) {
                span.addTag("populateReportChangeData");
                this.populateReportChangeData(planChangeRecord, dynamicObjectData);
                span.addTag("populateReportAdjustAmtInfo");
                this.populateReportAdjustAmtInfo(planChangeRecord, dynamicObjectData);
            }
            PlanChangeRecord planChangeRecord2 = planChangeRecord;
            return planChangeRecord2;
        }
    }

    private void populateReportAdjustAmtInfo(PlanChangeRecord planChangeRecord, DynamicObjectData dynamicObjectData) {
        planChangeRecord.setAdjustAmtInfoList(new ArrayList<AdjustAmtInfo>(128));
        DataSet adjustAmtInfoDataSet = dynamicObjectData.getReportChangeConvertParam().getAdjustAmtInfoDataSet();
        if (Objects.isNull(adjustAmtInfoDataSet)) {
            return;
        }
        while (adjustAmtInfoDataSet.hasNext()) {
            Row row = adjustAmtInfoDataSet.next();
            AdjustAmtInfo adjustAmtInfo = ConverterUtils.convert(AdjustAmtInfo.class, row);
            if (Objects.isNull(adjustAmtInfo)) continue;
            planChangeRecord.getAdjustAmtInfoList().add(adjustAmtInfo);
        }
        DataSetUtil.closeDataSet(adjustAmtInfoDataSet);
    }

    private void populateReportChangeData(PlanChangeRecord planChangeRecord, DynamicObjectData dynamicObjectData) {
        List<PlanChangeReportAuxEntry> reportAuxEntry;
        HashMap<Long, String> auxValMap;
        ReportChangeConvertParam reportChangeConvertParam = dynamicObjectData.getReportChangeConvertParam();
        DataSet mainJsonDetailDataSet = reportChangeConvertParam.getMainJsonDetailDataSet();
        if (Objects.isNull(mainJsonDetailDataSet)) {
            return;
        }
        List<Report> reports = reportChangeConvertParam.getReports();
        this.initChangeReportForRecord(planChangeRecord, reports);
        Map<Long, List<Dimension>> detailDimensionMap = reportChangeConvertParam.getDetailDimensionMap();
        Map<Long, ReportTemplate> reportTemplateMap = reports.stream().collect(Collectors.toMap(report -> report.getId(), report -> report.getTemplate(), (a, b) -> a));
        Map planChangeReportMap = planChangeRecord.getChangeReportList().stream().collect(Collectors.toMap(PlanChangeReport::getReportId, Function.identity(), (a, b) -> a));
        DynamicObjectCollection auxCollection = dynamicObjectData.getAuxEntry();
        HashMap reportDataAuxMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)auxCollection)) {
            for (Object auxDO : auxCollection) {
                long reportDataId = auxDO.getLong("aux_reportdataid");
                if (reportDataAuxMap.containsKey(reportDataId)) {
                    ((Map)reportDataAuxMap.get(reportDataId)).put(auxDO.getLong("aux_bdtype.id"), auxDO.getString("aux_content"));
                    continue;
                }
                auxValMap = new HashMap<Long, String>();
                auxValMap.put(auxDO.getLong("aux_bdtype.id"), auxDO.getString("aux_content"));
                reportDataAuxMap.put(reportDataId, auxValMap);
            }
        }
        if (reportDataAuxMap.isEmpty() && org.apache.commons.collections.CollectionUtils.isNotEmpty(reportAuxEntry = dynamicObjectData.getReportAuxEntry())) {
            for (PlanChangeReportAuxEntry auxDO : reportAuxEntry) {
                Map auxMap = (Map)reportDataAuxMap.get(auxDO.getReportDataId());
                if (!EmptyUtil.isEmpty((Object)auxMap)) {
                    auxMap.put(auxDO.getAuxiliaryField().getId(), auxDO.getContent());
                    continue;
                }
                auxValMap = new HashMap();
                auxValMap.put(auxDO.getAuxiliaryField().getId(), auxDO.getContent());
                reportDataAuxMap.put(auxDO.getReportDataId(), auxValMap);
            }
        }
        IConverter<ReportChangeData, ReportRowData> converter = ConverterFactory.getIConverter(ReportChangeData.class, ReportRowData.class);
        Map<Integer, Long> seqCustomDimMap = this.loadSeqCustomDimMap(planChangeRecord.getSystemId());
        Map<Object, Object> dimType2DimIdMap = Maps.newHashMapWithExpectedSize((int)0);
        if (this.needDimIfValueIsNotEmpty) {
            dimType2DimIdMap = this.loadDimType2DimIdMap(planChangeRecord.getSystemId());
            this.setMainReportTemplateFullDim(planChangeRecord);
        }
        while (mainJsonDetailDataSet.hasNext()) {
            Long originalReportId;
            PlanChangeReport changeReport;
            Row row = mainJsonDetailDataSet.next();
            ReportRowData rowData = new ReportRowData(row, reportTemplateMap, detailDimensionMap, seqCustomDimMap, dimType2DimIdMap);
            ReportChangeData changeData = converter.convert(rowData);
            if (reportDataAuxMap.containsKey(changeData.getId())) {
                changeData.setAuxiliaryValMap((Map)reportDataAuxMap.get(changeData.getId()));
            }
            if (Objects.isNull(changeReport = (PlanChangeReport)planChangeReportMap.get(originalReportId = changeData.getOriginalReportId()))) continue;
            changeReport.getReportDataList().add(changeData);
        }
        if (this.needDimIfValueIsNotEmpty) {
            this.setMainReportTemplateNonFullDim(planChangeRecord);
        }
        DataSetUtil.closeDataSet(mainJsonDetailDataSet);
    }

    private void initChangeReportForRecord(PlanChangeRecord planChangeRecord, List<Report> reports) {
        reports.stream().forEach(report -> planChangeRecord.getChangeReportList().add(this.getNewPlanChangeReport((Report)report, planChangeRecord)));
    }

    private PlanChangeReport getNewPlanChangeReport(Report report, PlanChangeRecord planChangeRecord) {
        PlanChangeReport planChangeReport = new PlanChangeReport();
        planChangeReport.setTemplate(report.getTemplate());
        planChangeReport.setRecordBillStatus(planChangeRecord.getStatus());
        planChangeReport.setReportId(report.getId());
        planChangeReport.setReportPeriodType(report.getReportPeriodType());
        planChangeReport.setReportPeriodId(planChangeRecord.getReportPeriod());
        planChangeReport.setPeriodMemberList((List<PeriodMember>)(Objects.isNull(report.getPeriodMemberList()) ? new ArrayList(0) : report.getPeriodMemberList()));
        return planChangeReport;
    }

    private Map<String, List<Long>> loadDimType2DimIdMap(Long systemId) {
        DynamicObjectCollection dimColl = QueryServiceHelper.query((String)"fpm_dimension", (String)String.join((CharSequence)",", "id", "basedata", "number"), (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)systemId)});
        HashMap dimMap = Maps.newHashMapWithExpectedSize((int)8);
        for (DynamicObject dimDy : dimColl) {
            String dimType = dimDy.getString("basedata");
            List dimIds = dimMap.computeIfAbsent(dimType, val -> new ArrayList(1));
            dimIds.add(dimDy.getLong("id"));
        }
        DynamicObjectCollection detailPlanColl = QueryServiceHelper.query((String)"fpm_detailplanfields", (String)String.join((CharSequence)",", "id", "detaildimtype"), (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)systemId)});
        for (DynamicObject detailPlanDy : detailPlanColl) {
            String detailDimType = detailPlanDy.getString("detaildimtype");
            List dimIds = dimMap.computeIfAbsent(detailDimType, val -> new ArrayList(1));
            dimIds.add(detailPlanDy.getLong("id"));
        }
        return dimMap;
    }

    private Map<Integer, Long> loadSeqCustomDimMap(Long systemId) {
        ICustomDimSeqService iCustomDimSeqService = FpmServiceFactory.getBizService(ICustomDimSeqService.class);
        return iCustomDimSeqService.loadSeqCustomDimMap(systemId);
    }

    private void setMainReportTemplateFullDim(PlanChangeRecord planChangeRecord) {
        Optional<PlanChangeReport> planChangeMainReportOpt = planChangeRecord.getChangeReportList().stream().filter(report -> report.getTemplate().isMainTable()).findAny();
        planChangeMainReportOpt.ifPresent(planChangeReport -> planChangeReport.getTemplate().setTemplateUse(TemplateUseType.SUMMARY));
    }

    private void setMainReportTemplateNonFullDim(PlanChangeRecord planChangeRecord) {
        Optional<PlanChangeReport> planChangeMainReportOpt = planChangeRecord.getChangeReportList().stream().filter(report -> report.getTemplate().isMainTable()).findAny();
        planChangeMainReportOpt.ifPresent(planChangeReport -> planChangeReport.getTemplate().setTemplateUse(TemplateUseType.PLANING));
    }
}

