/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.report.AdjustAmtInfo;
import kd.tmc.fpm.business.domain.model.report.ListPlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.ReportChangeData;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.service.dimension.impl.CustomDimSeqServiceImpl;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class PlanChangeReportDynamicCollectionConverter
implements IConverter<DynamicObject, ListPlanChangeReport> {
    @Override
    public DynamicObject convert(ListPlanChangeReport listPlanChangeReport) {
        DynamicObject dynamicObject = this.getChangeRecord(listPlanChangeReport.getRecordId());
        List<PlanChangeReport> reportList = listPlanChangeReport.getReportList();
        this.fillMainAndDetailEntryData(dynamicObject, reportList);
        this.fillAdjustAmountInfoEntryData(dynamicObject, listPlanChangeReport.getAdjustAmtInfoList());
        return dynamicObject;
    }

    private void fillAdjustAmountInfoEntryData(DynamicObject dynamicObject, List<AdjustAmtInfo> adjustAmtInfoList) {
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("adjust_entryentity");
        this.clearEntry(dynamicObjectCollection);
        if (CollectionUtils.isEmpty(adjustAmtInfoList)) {
            return;
        }
        for (AdjustAmtInfo adjustAmtInfo : adjustAmtInfoList) {
            DynamicObject amtAdjustInfoEntry = dynamicObjectCollection.addNew();
            amtAdjustInfoEntry.set("adjust_currency", (Object)adjustAmtInfo.getCombinationKey().getCurrencyId());
            amtAdjustInfoEntry.set("adjust_custompage1", (Object)adjustAmtInfo.getCombinationKey().getCustomPageDimensionMember1());
            amtAdjustInfoEntry.set("adjust_custompage2", (Object)adjustAmtInfo.getCombinationKey().getCustomPageDimensionMember2());
            amtAdjustInfoEntry.set("adjust_amtunit", (Object)adjustAmtInfo.getAmountUnit().getNumber());
            amtAdjustInfoEntry.set("adjust_adjustsumamtin", (Object)adjustAmtInfo.getAdjustSumAmtIn());
            amtAdjustInfoEntry.set("adjust_adjustsumamtout", (Object)adjustAmtInfo.getAdjustSumAmtOut());
            amtAdjustInfoEntry.set("adjust_adjustsumamtbal", (Object)adjustAmtInfo.getAdjustSumAmtBal());
        }
    }

    private void clearEntry(DynamicObjectCollection ... dynamicObjectCollections) {
        if (Objects.isNull(dynamicObjectCollections)) {
            return;
        }
        for (DynamicObjectCollection dynamicObjectCollection : dynamicObjectCollections) {
            dynamicObjectCollection.clear();
        }
    }

    private void fillMainAndDetailEntryData(DynamicObject dynamicObject, List<PlanChangeReport> reportList) {
        DynamicObjectCollection mainDynamicObjectCollection = dynamicObject.getDynamicObjectCollection("main_entryentity");
        DynamicObjectCollection detailDynamicObjectCollection = dynamicObject.getDynamicObjectCollection("detail_entryentity");
        DynamicObjectCollection auxDynamicObjectCollection = dynamicObject.getDynamicObjectCollection("auxentry");
        Map mainEntryDataMappingMap = mainDynamicObjectCollection.stream().collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        Map detailEntryDataMappingMap = detailDynamicObjectCollection.stream().collect(Collectors.toMap(o -> o.getLong("detail_maindimdataid"), Function.identity()));
        if (CollectionUtils.isEmpty(reportList)) {
            return;
        }
        List reportChangeDataList = reportList.stream().flatMap(report -> report.getReportDataList().stream()).filter(ReportChangeData.class::isInstance).map(reportData -> (ReportChangeData)reportData).collect(Collectors.toList());
        Set<Long> reportDataIdSet = reportChangeDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
        this.removeEntryDataIfNotInReportDataList(mainDynamicObjectCollection, "id", reportDataIdSet);
        this.removeEntryDataIfNotInReportDataList(detailDynamicObjectCollection, "detail_maindimdataid", reportDataIdSet);
        this.removeEntryDataIfNotInReportDataList(auxDynamicObjectCollection, "aux_reportdataid", reportDataIdSet);
        long systemId = dynamicObject.getLong("bodysys.id");
        Map<String, String> dimensionMappingMap = DimensionMappingHelper.getAdjustAllDimMappingWithoutEntry(systemId);
        for (ReportChangeData reportChangeData : reportChangeDataList) {
            DynamicObject detailEntry;
            DynamicObject mainEntry;
            if (reportChangeData.isDirty() == null || !reportChangeData.isDirty().booleanValue()) continue;
            if (!mainEntryDataMappingMap.containsKey(reportChangeData.getId())) {
                mainEntry = mainDynamicObjectCollection.addNew();
                detailEntry = detailDynamicObjectCollection.addNew();
            } else {
                mainEntry = (DynamicObject)mainEntryDataMappingMap.get(reportChangeData.getId());
                detailEntry = (DynamicObject)detailEntryDataMappingMap.get(reportChangeData.getId());
            }
            if (reportChangeData.isDelete()) {
                mainDynamicObjectCollection.remove((Object)mainEntry);
                detailDynamicObjectCollection.remove((Object)detailEntry);
                continue;
            }
            this.fillMainEntryField(dynamicObject, reportChangeData, mainEntry);
            this.fillDetailEntryField(dynamicObject, reportChangeData, detailEntry);
            List<TemplateDim> dimList = reportChangeData.getDimList();
            List<Object> dimValList = reportChangeData.getDimValList();
            Object value = null;
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                value = dimValList.get(i);
                DimensionType dimType = templateDim.getDimType();
                if (DimensionType.DETAILDIM.getNumber().equals(dimType.getNumber())) {
                    DetailDimType detailDimType = templateDim.getDetailDimType();
                    if (!dimensionMappingMap.containsKey(detailDimType.getNumber())) continue;
                    if (DetailDimType.isExtraField(detailDimType) && value instanceof Date) {
                        value = ((Date)value).getTime();
                    }
                    detailEntry.set(dimensionMappingMap.get(detailDimType.getNumber()), value);
                    continue;
                }
                if (DimensionType.CUSTOM.getNumber().equals(dimType.getNumber())) {
                    this.fillCustomDimVal(mainEntry, value, templateDim, dynamicObject.getDynamicObject("bodysys").getLong("id"));
                    continue;
                }
                mainEntry.set(dimensionMappingMap.get(dimType.getNumber()), value);
            }
            this.fillAuxEntry(reportChangeData, auxDynamicObjectCollection);
        }
    }

    private void fillAuxEntry(ReportChangeData reportChangeData, DynamicObjectCollection auxDynamicObjectCollection) {
        Map<Long, String> auxiliaryValMap = reportChangeData.getAuxiliaryValMap();
        if (MapUtils.isNotEmpty(auxiliaryValMap)) {
            auxiliaryValMap.forEach((k, v) -> {
                Optional<DynamicObject> dynamicObjectOpt = auxDynamicObjectCollection.stream().filter(dy -> reportChangeData.getId().compareTo(dy.getLong("aux_reportdataid")) == 0).filter(dy -> k.compareTo(dy.getDynamicObject("aux_bdtype").getLong("id")) == 0).findAny();
                if (dynamicObjectOpt.isPresent()) {
                    DynamicObject dynamicObject = dynamicObjectOpt.get();
                    dynamicObject.set("aux_reportdataid", (Object)reportChangeData.getId());
                    dynamicObject.set("aux_bdtype", k);
                    dynamicObject.set("aux_content", v);
                    return;
                }
                if (EmptyUtil.isNotEmpty((CharSequence)v)) {
                    DynamicObject dynamicObject = auxDynamicObjectCollection.addNew();
                    dynamicObject.set("aux_reportdataid", (Object)reportChangeData.getId());
                    dynamicObject.set("aux_bdtype", k);
                    dynamicObject.set("aux_content", v);
                }
            });
        }
    }

    private void fillDetailEntryField(DynamicObject dynamicObject, ReportChangeData reportChangeData, DynamicObject detailEntry) {
        detailEntry.set("detail_maindimdataid", (Object)reportChangeData.getId());
        detailEntry.set("detail_remark", (Object)reportChangeData.getRemark());
    }

    private void fillMainEntryField(DynamicObject dynamicObject, ReportChangeData reportChangeData, DynamicObject mainEntry) {
        if (EmptyUtil.isEmpty((Long)reportChangeData.getId())) {
            reportChangeData.setId(DB.genGlobalLongId());
        }
        mainEntry.set("id", (Object)reportChangeData.getId());
        mainEntry.set("main_originalreportid", (Object)reportChangeData.getOriginalReportId());
        mainEntry.set("main_originalreportdataid", (Object)reportChangeData.getOriginalReportDataId());
        mainEntry.set("main_bodysys", (Object)dynamicObject.getDynamicObject("bodysys"));
        mainEntry.set("main_planamt", (Object)reportChangeData.getPlanAmt());
        mainEntry.set("main_originalplanamt", (Object)reportChangeData.getOriginalPlanAmt());
        mainEntry.set("main_lockamt", (Object)reportChangeData.getLockAmt());
        mainEntry.set("main_realamt", (Object)reportChangeData.getActAmt());
        mainEntry.set("main_currentadjustamt", (Object)reportChangeData.getCurrentAdjustAmt());
        mainEntry.set("main_adjustedplanamt", (Object)reportChangeData.getAdjustedPlanAmt());
        mainEntry.set("main_origindatarow", (Object)reportChangeData.getRow());
        mainEntry.set("main_origindatacol", (Object)reportChangeData.getCol());
        mainEntry.set("main_effectflag", (Object)reportChangeData.isEffectFlag());
        mainEntry.set("main_maintable", (Object)(reportChangeData.isMainTable() ? "1" : "0"));
        mainEntry.set("main_amountunit", (Object)(Objects.isNull((Object)reportChangeData.getAmountUnit()) ? "" : reportChangeData.getAmountUnit().getNumber()));
        mainEntry.set("main_reportperiod", (Object)reportChangeData.getReportPeriodId());
    }

    private DynamicObject getChangeRecord(Long id) {
        boolean exists = TmcDataServiceHelper.exists((Object)id, (String)"fpm_reportplan_adjust");
        DynamicObject changeReportDynamicObject = exists ? TmcDataServiceHelper.loadSingle((Object)id, (String)"fpm_reportplan_adjust") : TmcDataServiceHelper.newDynamicObject((String)"fpm_reportplan_adjust");
        return changeReportDynamicObject;
    }

    private void removeEntryDataIfNotInReportDataList(DynamicObjectCollection entry, String reportDataIdProp, Set<Long> reportDataIdSet) {
        entry.removeIf(dy -> {
            Long reportDataId = dy.getLong(reportDataIdProp);
            return !reportDataIdSet.contains(reportDataId);
        });
    }

    private void fillCustomDimVal(DynamicObject mainEntry, Object value, TemplateDim templateDim, Long systemId) {
        if (EmptyUtil.isEmpty((Long)systemId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u586b\u5145\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u65f6\u7f3a\u5c11\u4f53\u7cfbID", (String)"PlanChangeReportDynamicCollectionConverter_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        ICustomDimSeqService iCustomDimSeqService = FpmServiceFactory.getBizService(ICustomDimSeqService.class);
        Map<Long, Integer> customDimSeqMap = iCustomDimSeqService.loadCustomDimSeqMap(systemId);
        Integer storeSeq = customDimSeqMap.get(templateDim.getDimensionId());
        String storeProperty = CustomDimSeqServiceImpl.seq2AdjustReportCustomPropertyMap.get(storeSeq);
        mainEntry.set(storeProperty, value);
    }
}

