/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.report.EntryReportData;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.converter.ReportPoConverter;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.service.dimension.impl.CustomDimSeqServiceImpl;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ReportDataDynamicEntryConverter
implements IConverter<DynamicObject, EntryReportData> {
    private DynamicObject entryDy;
    private boolean mainEntry;

    public ReportDataDynamicEntryConverter() {
    }

    public ReportDataDynamicEntryConverter(DynamicObject entryDy) {
        this.entryDy = entryDy;
        this.mainEntry = Objects.equals(this.entryDy.getDataEntityType().getName(), "maindimentry");
    }

    @Override
    public DynamicObject convert(EntryReportData entryReportData) {
        ReportData reportData = entryReportData.getReportData();
        if (this.mainEntry) {
            this.entryDy.set("system", (Object)entryReportData.getSystemId());
            reportData.setSystemId(entryReportData.getSystemId());
            this.convertMainEntry(reportData);
            return this.entryDy;
        }
        this.convertDetailEntry(reportData);
        return this.entryDy;
    }

    private void convertMainEntry(ReportData reportData) {
        this.entryDy.set("id", (Object)reportData.getId());
        this.entryDy.set("orgplanamt", (Object)reportData.getOriginalPlanAmt());
        this.entryDy.set("reportplanamt", (Object)reportData.getReportPlanAmt());
        this.entryDy.set("planreferenceamt", (Object)reportData.getPlanReferenceAmt());
        this.entryDy.set("planamt", (Object)reportData.getPlanAmt());
        this.entryDy.set("realamt", (Object)reportData.getActAmt());
        this.entryDy.set("lockamt", (Object)reportData.getLockAmt());
        this.entryDy.set("version", (Object)reportData.getVersion());
        this.entryDy.set("origindatarow", (Object)reportData.getRow());
        this.entryDy.set("origindatacol", (Object)reportData.getCol());
        this.entryDy.set("effectflag", (Object)reportData.isEffectFlag());
        this.entryDy.set("offsetamt", (Object)reportData.getOffsetAmt());
        this.entryDy.set("entryreportperiod", (Object)reportData.getReportPeriodId());
        this.entryDy.set("maintable", (Object)(reportData.isMainTable() ? "1" : "0"));
        this.entryDy.set("amountunit", (Object)(reportData.getAmountUnit() == null ? "" : reportData.getAmountUnit().getNumber()));
        if (CollectionUtils.isNotEmpty(reportData.getSourceIdList())) {
            this.entryDy.set("smartgelflag", (Object)Boolean.TRUE);
        }
        this.processMainDim(reportData);
    }

    private void processMainDim(ReportData reportData) {
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim = dimList.get(i);
            DimensionType dimType = templateDim.getDimType();
            if (dimType.isMetric() || dimType.isDetailDim()) continue;
            Object value = dimValList.get(i);
            if (dimType.isCustomDim()) {
                this.fillCustomDimVal(value, templateDim, reportData.getSystemId());
                continue;
            }
            String entrySignByDimType = ReportDataDynamicEntryConverter.getEntrySignByDimType(dimType.getNumber());
            if (StringUtils.isEmpty((Object)entrySignByDimType)) continue;
            this.entryDy.set(entrySignByDimType, value);
        }
    }

    private static String getEntrySignByDimType(String number) {
        return ReportPoConverter.TYPE_MAPPING_MAP.get(number);
    }

    private void fillCustomDimVal(Object value, TemplateDim templateDim, Long systemId) {
        if (EmptyUtil.isEmpty((Long)systemId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u586b\u5145\u81ea\u5b9a\u4e49\u7ef4\u5ea6\u65f6\u7f3a\u5c11\u4f53\u7cfbID", (String)"ReportDataDynamicEntryConverter_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        ICustomDimSeqService iCustomDimSeqService = FpmServiceFactory.getBizService(ICustomDimSeqService.class);
        Map<Long, Integer> customDimSeqMap = iCustomDimSeqService.loadCustomDimSeqMap(systemId);
        Integer storeSeq = customDimSeqMap.get(templateDim.getDimensionId());
        String storeProperty = CustomDimSeqServiceImpl.seq2ReportCustomPropertyMap.get(storeSeq);
        DynamicObject dynamicObject = TmcDataServiceHelper.newDynamicObject((String)"fpm_member");
        dynamicObject.set("id", value);
        this.entryDy.set(storeProperty, (Object)dynamicObject);
    }

    private void convertDetailEntry(ReportData reportData) {
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        this.entryDy.set("maindimdataid", (Object)reportData.getId());
        this.entryDy.set("remark", (Object)reportData.getRemark());
        Map<String, String> detailExtraFieldsMapping = DimensionMappingHelper.getDetailExtraFieldsMapping(reportData.getSystemId(), "fpm_report");
        for (int i = 0; i < dimList.size(); ++i) {
            String entrySignByDimType;
            TemplateDim templateDim = dimList.get(i);
            DimensionType dimType = templateDim.getDimType();
            if (!dimType.isDetailDim()) continue;
            DetailDimType detailDimType = templateDim.getDetailDimType();
            Object value = dimValList.get(i);
            if (DetailDimType.isExtraField(detailDimType)) {
                entrySignByDimType = detailExtraFieldsMapping.get(detailDimType.getNumber());
                if (value instanceof Date) {
                    value = ((Date)value).getTime();
                }
            } else {
                entrySignByDimType = ReportDataDynamicEntryConverter.getEntrySignByDimType(detailDimType.getNumber());
            }
            if (EmptyUtil.isEmpty((String)entrySignByDimType)) continue;
            this.entryDy.set(entrySignByDimType, value);
        }
    }

    private void fillExtraField(Object value, String entrySignByDimType) {
        if (value instanceof Date) {
            value = ((Date)value).getTime();
        }
        this.entryDy.set(entrySignByDimType, value);
    }
}

