/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportVerifyCheckEffectEnum;
import kd.tmc.fpm.business.domain.enums.ReportVerifyCheckTypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportVerifyDataRelTypeEnum;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRule;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRuleDimension;
import kd.tmc.fpm.business.domain.model.report.ReportVerifyRuleDimensionMember;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.converter.control.Converter;

public class ReportVerifyRuleConverter
implements Converter<ReportVerifyRule> {
    @Override
    public ReportVerifyRule convert(DynamicObject dynamicObject) {
        DynamicObjectCollection template;
        ReportVerifyRule reportVerifyRule = new ReportVerifyRule();
        reportVerifyRule.setId((Long)dynamicObject.getPkValue());
        reportVerifyRule.setSystemId((Long)dynamicObject.getDynamicObject("bodysysmanage").getPkValue());
        reportVerifyRule.setNumber(String.valueOf(dynamicObject.get("number")));
        reportVerifyRule.setName(dynamicObject.getString("name"));
        reportVerifyRule.setCheckType(ReportVerifyCheckTypeEnum.getByCode(dynamicObject.getString("checktype")));
        reportVerifyRule.setTolerance(dynamicObject.getBigDecimal("tolerance"));
        reportVerifyRule.setTemplateCheck(dynamicObject.getBoolean("templatecheck"));
        reportVerifyRule.setCheckEffect(ReportVerifyCheckEffectEnum.getByCode(dynamicObject.getString("checkeffect")));
        DynamicObjectCollection reportType = dynamicObject.getDynamicObjectCollection("reporttype");
        if (!CollectionUtils.isEmpty((Collection)reportType)) {
            ArrayList<ReportPeriodType> reportPeriodTypeList = new ArrayList<ReportPeriodType>(reportType.size());
            for (Iterator entry2 : reportType) {
                DynamicObject reportTypeObj = entry2.getDynamicObject("fbasedataid");
                ReportPeriodType reportPeriodType = this.getReportPeriodType(reportTypeObj);
                if (!Objects.nonNull(reportPeriodType)) continue;
                reportPeriodTypeList.add(reportPeriodType);
            }
            reportVerifyRule.setPeriodTypeList(reportPeriodTypeList);
        }
        if (!CollectionUtils.isEmpty((Collection)(template = dynamicObject.getDynamicObjectCollection("templaterange")))) {
            ArrayList<ReportTemplate> reportTemplateList = new ArrayList<ReportTemplate>();
            for (DynamicObject tem : template) {
                DynamicObject temObj = tem.getDynamicObject("fbasedataid");
                ReportTemplate reportTemplate = new ReportTemplate();
                reportTemplate.setNumber(temObj.getString("number"));
                reportTemplate.setName(temObj.getString("name"));
                reportTemplateList.add(reportTemplate);
            }
            reportVerifyRule.setReportTemplateList(reportTemplateList);
        }
        ReportPeriodType reportPeriodType = this.getReportPeriodType(dynamicObject.getDynamicObject("checkreporttype"));
        reportVerifyRule.setCheckReportPeriodType(reportPeriodType);
        List checkDimList = Optional.ofNullable(JSON.parseArray((String)dynamicObject.getString("checkdimensionvalue_tag"), ReportVerifyRuleDimension.class)).orElseGet(ArrayList::new);
        reportVerifyRule.setCheckDimensionValue(checkDimList);
        reportVerifyRule.setValueFormulaValue(dynamicObject.getString("valueformulavalue_tag"));
        ReportPeriodType checkedReportType = this.getReportPeriodType(dynamicObject.getDynamicObject("checkedreporttype"));
        reportVerifyRule.setCheckReportPeriodType(reportPeriodType);
        reportVerifyRule.setCheckedReportPeriodType(checkedReportType);
        List checkedDimList = Optional.ofNullable(JSON.parseArray((String)dynamicObject.getString("checkeddimensionvalue_tag"), ReportVerifyRuleDimension.class)).orElseGet(ArrayList::new);
        reportVerifyRule.setCheckedDimensionValue(checkedDimList);
        reportVerifyRule.setValuedFormulaValue(dynamicObject.getString("valuedformulavalue_tag"));
        reportVerifyRule.setFormulaType(ReportVerifyDataRelTypeEnum.getByCode(dynamicObject.getString("dataverifyrel")));
        reportVerifyRule.setExpression(dynamicObject.getString("expression"));
        ArrayList<ReportVerifyRuleDimension> dimensionList = new ArrayList<ReportVerifyRuleDimension>();
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            entryEntity.forEach(entry -> {
                DynamicObject dimensionObj = entry.getDynamicObject("dimension");
                ReportVerifyRuleDimension dimension = new ReportVerifyRuleDimension();
                dimension.setDimensionId((Long)dimensionObj.getPkValue());
                dimension.setDimensionName(dimensionObj.getString("name"));
                dimension.setDimsionEnums(DimensionType.getDimsionByNumber(dimensionObj.getString("basedata")));
                ArrayList<ReportVerifyRuleDimensionMember> memberList = new ArrayList<ReportVerifyRuleDimensionMember>();
                DynamicObjectCollection members = entry.getDynamicObjectCollection("mulmembers");
                if (!CollectionUtils.isEmpty((Collection)members)) {
                    members.forEach(member -> {
                        DynamicObject memberObj = member.getDynamicObject("fbasedataid");
                        ReportVerifyRuleDimensionMember dimensionMember = new ReportVerifyRuleDimensionMember();
                        dimensionMember.setDimensionMemberId((Long)memberObj.getPkValue());
                        dimensionMember.setDimensionMemberName(memberObj.getString("name"));
                        dimensionMember.setDimensionId((Long)dimensionObj.getPkValue());
                        memberList.add(dimensionMember);
                    });
                }
                dimension.setMemberParams(memberList);
                dimensionList.add(dimension);
            });
        }
        reportVerifyRule.setDimensionList(dimensionList);
        reportVerifyRule.setDuringDeviation(dynamicObject.getInt("duringdeviation"));
        return reportVerifyRule;
    }

    private ReportPeriodType getReportPeriodType(DynamicObject entry) {
        if (Objects.isNull(entry)) {
            return null;
        }
        ReportPeriodType reportPeriodType = new ReportPeriodType();
        reportPeriodType.setEnable("enable".equals(entry.getString("enable")));
        reportPeriodType.setId((Long)entry.getPkValue());
        reportPeriodType.setReportPeriodId((Long)entry.getPkValue());
        reportPeriodType.setName(entry.getString("name"));
        reportPeriodType.setNumber(entry.getString("number"));
        reportPeriodType.setPeriodType(PeriodType.getByNumber(entry.getString("orgreportcycle")));
        reportPeriodType.setDetailPeriodType(PeriodType.getByNumber(entry.getString("orgreporttype")));
        return reportPeriodType;
    }
}

