/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.helper.FormulaHelper;
import kd.tmc.fpm.business.spread.formula.enums.FormulaSymbolEnum;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MemberSumEnum;
import kd.tmc.fpm.olap.model.ShrekDimension;
import kd.tmc.fpm.olap.model.ShrekMember;
import kd.tmc.fpm.olap.utils.ShrekIdUtil;
import org.apache.commons.collections.MapUtils;

public class ShrekModelConverter {
    public static List<ShrekDimension> convert(String cubeNumber, List<Dimension> dimension) {
        return dimension.stream().map(item -> ShrekModelConverter.convert(cubeNumber, item)).collect(Collectors.toList());
    }

    public static List<ShrekDimension> convertAndFillRoot(String cubeNumber, List<Dimension> dimensionList) {
        List<ShrekDimension> shrekDimensions = ShrekModelConverter.convert(cubeNumber, dimensionList);
        Map<String, Map<String, String>> formulaMap = ShrekModelConverter.getFormulaMap(dimensionList);
        for (ShrekDimension shrekDimension : shrekDimensions) {
            List dimMembers = shrekDimension.getDimMembers();
            ShrekMember root = new ShrekMember();
            root.setNumber(ShrekIdUtil.getRootNumber((String)shrekDimension.getNumber()));
            root.setDimNumber(shrekDimension.getNumber());
            root.setNeedLeafCalc(Boolean.valueOf(true));
            ShrekMember defaultMember = new ShrekMember();
            defaultMember.setNumber(ShrekIdUtil.getNoneNumber((String)shrekDimension.getNumber()));
            defaultMember.setDimNumber(shrekDimension.getNumber());
            defaultMember.setNeedLeafCalc(Boolean.valueOf(false));
            defaultMember.setAggType(MemberSumEnum.PLUS.getCode());
            root.setChildren((List)Lists.newArrayList((Object[])new ShrekMember[]{defaultMember}));
            if (!CollectionUtils.isEmpty((Collection)dimMembers)) {
                root.getChildren().addAll(dimMembers);
            }
            shrekDimension.setDimMembers((List)Lists.newArrayList((Object[])new ShrekMember[]{root}));
        }
        List subjectShrekDim = shrekDimensions.stream().filter(item -> item.getNumber().contains(DimsionEnums.SUBJECT.getNumber())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(subjectShrekDim)) {
            ShrekDimension shrekDimension;
            shrekDimension = (ShrekDimension)subjectShrekDim.get(0);
            List allDimMemberList = shrekDimension.getAllDimMemberList();
            allDimMemberList.forEach(item -> {
                Map formulaSymbolMap = (Map)formulaMap.get(item.getNumber());
                if (MapUtils.isEmpty((Map)formulaSymbolMap)) {
                    return;
                }
                item.setFormulaMap(formulaSymbolMap);
                item.setNeedLeafCalc(Boolean.valueOf(false));
            });
        }
        return shrekDimensions;
    }

    private static Map<String, Map<String, String>> getFormulaMap(List<Dimension> dimensionList) {
        HashMap<String, Map<String, String>> formulaMap = new HashMap<String, Map<String, String>>(8);
        List subjectDim = dimensionList.stream().filter(item -> DimensionType.SUBJECTS == item.getDimType()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(subjectDim)) {
            return formulaMap;
        }
        Dimension dimension = (Dimension)subjectDim.get(0);
        Map subjectMemberMap = dimension.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity()));
        List formulaSubjects = dimension.getAllDimMemberList().stream().filter(item -> ReportInputType.FORMULA == ((AccountMember)item).getInputType()).map(item -> (AccountMember)item).filter(item -> !StringUtils.isEmpty((Object)item.getFormula())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(formulaSubjects)) {
            return formulaMap;
        }
        for (AccountMember formulaSubject : formulaSubjects) {
            String formula = formulaSubject.getFormula();
            Map<String, FormulaSymbolEnum> mapByFormula = FormulaHelper.getMapByFormula(formula);
            HashMap map = new HashMap(mapByFormula.size());
            mapByFormula.forEach((id, symbol) -> {
                DimMember dimMember = (DimMember)subjectMemberMap.get(Long.valueOf(id));
                if (Objects.isNull(dimMember)) {
                    return;
                }
                String aggType = "";
                switch (symbol) {
                    case PLUS: {
                        aggType = "PLUS";
                        break;
                    }
                    case MINUS: {
                        aggType = "SUBTRACT";
                        break;
                    }
                }
                map.put(dimMember.getShrekKey(), aggType);
            });
            formulaMap.put(formulaSubject.getShrekKey(), map);
        }
        return formulaMap;
    }

    public static ShrekDimension convert(String cubeNumber, Dimension dimension) {
        String dimNumber = ShrekIdUtil.getDimNumber((String)dimension.getNumber());
        ShrekDimension shrekDimension = new ShrekDimension();
        shrekDimension.setNumber(dimNumber);
        shrekDimension.setCubeNumber(cubeNumber);
        List<ShrekMember> shrekMembers = ShrekModelConverter.setChild(cubeNumber, dimNumber, dimension.getMemberList());
        shrekDimension.setDimMembers(shrekMembers);
        return shrekDimension;
    }

    public static ShrekMember convert(DimMember member) {
        ShrekMember shrekMember = new ShrekMember();
        shrekMember.setNumber(CommonUtils.getSyncShrekKey(member));
        shrekMember.setNeedLeafCalc(Boolean.valueOf(false));
        shrekMember.setAggType(MemberSumEnum.convertAggType((String)member.getSumType()));
        if (member instanceof OrgMember || member instanceof AccountMember) {
            shrekMember.setNeedLeafCalc(Boolean.valueOf(true));
        }
        if (MemberSumEnum.IGNORE == MemberSumEnum.valueOf((String)member.getSumType())) {
            shrekMember.setNeedLeafCalc(Boolean.valueOf(false));
        }
        return shrekMember;
    }

    private static List<ShrekMember> setChild(String cubeNumber, String dimNumber, List<DimMember> dimMembers) {
        if (CollectionUtils.isEmpty(dimMembers)) {
            return null;
        }
        ArrayList<ShrekMember> result = new ArrayList<ShrekMember>(dimMembers.size());
        for (DimMember dimMember : dimMembers) {
            ShrekMember shrekMember = ShrekModelConverter.convert(dimMember);
            shrekMember.setCubeNumber(cubeNumber);
            shrekMember.setDimNumber(dimNumber);
            shrekMember.setChildren(ShrekModelConverter.setChild(cubeNumber, dimNumber, dimMember.getChildren()));
            result.add(shrekMember);
        }
        return result;
    }
}

