/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.SumRepulseStatusType;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigSnapshot;
import kd.tmc.fpm.business.mvc.converter.control.Converter;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;

public class SumPlanParamConfigConverter
implements Converter<SumPlanParamConfig> {
    @Override
    public SumPlanParamConfig convert(DynamicObject dynamicObject) {
        boolean isSnapshot = Objects.equals("fpm_summaryconfig_snp", dynamicObject.getDataEntityType().getName());
        SumPlanParamConfig sumPlanParamConfig = isSnapshot ? new SumPlanParamConfigSnapshot() : new SumPlanParamConfig();
        sumPlanParamConfig.setId((Long)dynamicObject.getPkValue());
        sumPlanParamConfig.setName(dynamicObject.getString("name"));
        sumPlanParamConfig.setNumber(dynamicObject.getString("number"));
        sumPlanParamConfig.setSumRepulseStatusType(ITypeEnum.getByNumber(dynamicObject.getString("sumrepulsestatus"), SumRepulseStatusType.class));
        sumPlanParamConfig.setSystemId((Long)dynamicObject.getDynamicObject("bodysys").getPkValue());
        sumPlanParamConfig.setEnable(dynamicObject.getBoolean("enable"));
        sumPlanParamConfig.setAllowSubmit(dynamicObject.getBoolean("allowsubmit"));
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("sumreporttype");
        sumPlanParamConfig.setReportPeriodTypeIdS(dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(id -> (Long)id).collect(Collectors.toList()));
        DynamicObjectCollection objectCollection = dynamicObject.getDynamicObjectCollection("treeentryentity");
        SumPlanParamConfigInfo configInfos = ConverterUtils.convert(SumPlanParamConfigInfo.class, objectCollection);
        this.fillChildren((List<SumPlanParamConfigInfo>)((Object)configInfos));
        sumPlanParamConfig.setConfigInfoList((List<SumPlanParamConfigInfo>)((Object)configInfos));
        if (isSnapshot) {
            SumPlanParamConfigSnapshot sumPlanParamConfigSnapshot = (SumPlanParamConfigSnapshot)sumPlanParamConfig;
            sumPlanParamConfigSnapshot.setSummaryConfigId(dynamicObject.getLong("summaryconfig"));
            sumPlanParamConfigSnapshot.setConfigInfoListMD5(dynamicObject.getString("treeentryentitymd5"));
        }
        return sumPlanParamConfig;
    }

    private void fillChildren(List<SumPlanParamConfigInfo> configInfos) {
        Map<Long, List<SumPlanParamConfigInfo>> listMap = configInfos.stream().collect(Collectors.groupingBy(SumPlanParamConfigInfo::getParentId));
        for (SumPlanParamConfigInfo configInfo : configInfos) {
            Long orgMemberId = configInfo.getOrgMemberId();
            List<SumPlanParamConfigInfo> children = listMap.get(orgMemberId);
            if (EmptyUtil.isEmpty(children)) continue;
            configInfo.setChildren(children);
        }
    }
}

