/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.CheckSubLimitType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.mvc.converter.control.Converter;
import kd.tmc.fpm.common.bean.CurrencyMapConfig;
import org.apache.commons.lang3.StringUtils;

public class SumPlanParamConfigInfoConverter
implements Converter<SumPlanParamConfigInfo> {
    @Override
    public SumPlanParamConfigInfo convert(DynamicObject dynamicObject) {
        SumPlanParamConfigInfo configInfo = new SumPlanParamConfigInfo();
        configInfo.setId((Long)dynamicObject.getPkValue());
        DynamicObject orgMemberDy = dynamicObject.getDynamicObject("sum_reportorg");
        configInfo.setOrgMemberId((Long)orgMemberDy.getPkValue());
        boolean isSnapshot = Objects.equals(((DynamicObject)dynamicObject.getParent()).getDataEntityType().getName(), "fpm_summaryconfig_snp");
        DynamicObject parent = isSnapshot ? dynamicObject.getDynamicObject("sum_parentorg") : orgMemberDy.getDynamicObject("parent");
        configInfo.setParentId(EmptyUtil.isNoEmpty((DynamicObject)parent) ? (Long)parent.getPkValue() : 0L);
        int level = isSnapshot ? dynamicObject.getInt("sum_reportorglevel") : orgMemberDy.getInt("level");
        configInfo.setLevel(level);
        configInfo.setSumAuditNode(dynamicObject.getBoolean("sum_issumaudit"));
        configInfo.setCheckSubLimitType(ITypeEnum.getByNumber(dynamicObject.getString("sum_ischecksublimit"), CheckSubLimitType.class));
        configInfo.setSeq(dynamicObject.getInt("seq"));
        String currencyMapCaseJson = dynamicObject.getString("sum_currencymapcasereal_tag");
        SumPlanParamConfigInfo.CurrencyMapCase currencyMapCase = this.getCurrencyMapCaseFromJson(currencyMapCaseJson);
        configInfo.setCurrencyMapCase(currencyMapCase);
        return configInfo;
    }

    private SumPlanParamConfigInfo.CurrencyMapCase getCurrencyMapCaseFromJson(String currencyMapCaseJson) {
        if (StringUtils.isEmpty((CharSequence)currencyMapCaseJson)) {
            return null;
        }
        CurrencyMapConfig currencyMapConfig = (CurrencyMapConfig)SerializationUtils.fromJsonString((String)currencyMapCaseJson, CurrencyMapConfig.class);
        SumPlanParamConfigInfo.CurrencyMapCase currencyMapCase = new SumPlanParamConfigInfo.CurrencyMapCase();
        currencyMapCase.setName(currencyMapConfig.getName());
        currencyMapCase.setNumber(currencyMapConfig.getNumber());
        List mapConfigList = currencyMapConfig.getMapConfigList();
        if (CollectionUtils.isEmpty((Collection)mapConfigList)) {
            return currencyMapCase;
        }
        ArrayList<SumPlanParamConfigInfo.CurrencyMapCaseInfo> caseInfoList = new ArrayList<SumPlanParamConfigInfo.CurrencyMapCaseInfo>(mapConfigList.size());
        for (CurrencyMapConfig.MapConfig mapConfig : mapConfigList) {
            SumPlanParamConfigInfo.CurrencyMapCaseInfo mapCaseInfo = new SumPlanParamConfigInfo.CurrencyMapCaseInfo();
            mapCaseInfo.setSumCurrencyId(mapConfig.getSumCurrencyMemberId());
            mapCaseInfo.setSubOrgReportCurrencyId(mapConfig.getSubMainReportCurrencyId());
            caseInfoList.add(mapCaseInfo);
        }
        currencyMapCase.setCurrencyMapCaseInfoList(caseInfoList);
        return currencyMapCase;
    }
}

