/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.common.bean.CurrencyMapConfig;
import kd.tmc.fpm.common.utils.GlobalIdUtil;

public class SumPlanParamConfigInfoDynamicConverter
implements IConverter<DynamicObject, SumPlanParamConfigInfo> {
    private DynamicObject summaryMainParamDy;
    private boolean isInsert;

    public SumPlanParamConfigInfoDynamicConverter() {
    }

    public SumPlanParamConfigInfoDynamicConverter(DynamicObject summaryMainParamDy, Boolean isInsert) {
        this.summaryMainParamDy = summaryMainParamDy;
        this.isInsert = isInsert;
    }

    @Override
    public DynamicObject convert(SumPlanParamConfigInfo sumPlanParamConfigInfo) {
        boolean isSnapshot;
        long id = this.isInsert ? GlobalIdUtil.genGlobalLongId() : sumPlanParamConfigInfo.getId();
        this.summaryMainParamDy.set("id", (Object)id);
        this.summaryMainParamDy.set("sum_reportorg", (Object)sumPlanParamConfigInfo.getOrgMemberId());
        this.summaryMainParamDy.set("sum_issumaudit", (Object)sumPlanParamConfigInfo.isSumAuditNode());
        if (sumPlanParamConfigInfo.getCheckSubLimitType() != null) {
            this.summaryMainParamDy.set("sum_ischecksublimit", (Object)sumPlanParamConfigInfo.getCheckSubLimitType().getNumber());
        }
        this.summaryMainParamDy.set("seq", (Object)sumPlanParamConfigInfo.getSeq());
        this.summaryMainParamDy.set("sum_currencymapcasereal_tag", (Object)this.serializeCurrencyMapCase(sumPlanParamConfigInfo.getCurrencyMapCase()));
        DynamicObject sumPlanParamConfigDy = (DynamicObject)this.summaryMainParamDy.getParent();
        boolean bl = isSnapshot = Objects.nonNull(sumPlanParamConfigDy) && Objects.equals(sumPlanParamConfigDy.getDataEntityType().getName(), "fpm_summaryconfig_snp");
        if (isSnapshot) {
            this.summaryMainParamDy.set("sum_parentorg", (Object)sumPlanParamConfigInfo.getParentId());
            this.summaryMainParamDy.set("sum_reportorglevel", (Object)sumPlanParamConfigInfo.getLevel());
        }
        return this.summaryMainParamDy;
    }

    private String serializeCurrencyMapCase(SumPlanParamConfigInfo.CurrencyMapCase currencyMapCase) {
        if (currencyMapCase == null) {
            return " ";
        }
        CurrencyMapConfig currencyMapConfig = new CurrencyMapConfig();
        currencyMapConfig.setName(currencyMapCase.getName());
        currencyMapConfig.setNumber(currencyMapCase.getNumber());
        if (CollectionUtils.isEmpty(currencyMapCase.getCurrencyMapCaseInfoList())) {
            return SerializationUtils.toJsonString((Object)currencyMapConfig);
        }
        List mapConfigList = currencyMapCase.getCurrencyMapCaseInfoList().stream().map(currencyMapCaseInfo -> {
            CurrencyMapConfig.MapConfig mapConfig = new CurrencyMapConfig.MapConfig();
            mapConfig.setSumCurrencyMemberId(currencyMapCaseInfo.getSumCurrencyId());
            mapConfig.setSubMainReportCurrencyId(currencyMapCaseInfo.getSubOrgReportCurrencyId());
            return mapConfig;
        }).collect(Collectors.toList());
        currencyMapConfig.setMapConfigList(mapConfigList);
        return SerializationUtils.toJsonString((Object)currencyMapConfig);
    }
}

