/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.SumPlanSumType;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.mvc.converter.control.Converter;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;

public class SumPlanRecordConverter
implements Converter<SumPlanRecord> {
    @Override
    public SumPlanRecord convert(DynamicObject dynamicObject) {
        SumPlanRecord sumPlanRecord = new SumPlanRecord();
        sumPlanRecord.setId(dynamicObject.getLong("id"));
        sumPlanRecord.setNumber(dynamicObject.getString("billno"));
        sumPlanRecord.setName(dynamicObject.getString("name"));
        DynamicObject creatorObj = dynamicObject.getDynamicObject("creator");
        if (Objects.nonNull(creatorObj)) {
            sumPlanRecord.setCreatorId(creatorObj.getPkValue().toString());
        }
        sumPlanRecord.setStatus(ITypeEnum.getByNumber(dynamicObject.getString("billstatus"), BillStatus.class));
        sumPlanRecord.setSystemId((Long)dynamicObject.getDynamicObject("bodysys").getPkValue());
        sumPlanRecord.setSumPlanSumType(ITypeEnum.getByNumber(dynamicObject.getString("summarytype"), SumPlanSumType.class));
        sumPlanRecord.setOrgId((Long)dynamicObject.getDynamicObject("reportorg").getPkValue());
        sumPlanRecord.setReportPeriodTypeId((Long)dynamicObject.getDynamicObject("reporttype").getPkValue());
        sumPlanRecord.setReportPeriodId((Long)dynamicObject.getDynamicObject("reportperiod").getPkValue());
        sumPlanRecord.setReportOrg((Long)dynamicObject.getDynamicObject("reportorg").getPkValue());
        sumPlanRecord.setReportType((Long)dynamicObject.getDynamicObject("reporttype").getPkValue());
        sumPlanRecord.setReportPeriod((Long)dynamicObject.getDynamicObject("reportperiod").getPkValue());
        sumPlanRecord.setDeclareStartDate(dynamicObject.getDate("declarestartdate"));
        sumPlanRecord.setDeclareEndDate(dynamicObject.getDate("declaredeadline"));
        DynamicObjectCollection currencyRange = dynamicObject.getDynamicObjectCollection("currencyrange");
        sumPlanRecord.setCurrencyIdList(this.getIdListFromMultiDataBaseEdit(currencyRange));
        String reportIds = dynamicObject.getString("originalreportids");
        List<Long> originalReportIdList = StringUtils.isEmpty((CharSequence)reportIds) ? Collections.emptyList() : Arrays.stream(reportIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
        sumPlanRecord.setOriginalReportIdList(originalReportIdList);
        sumPlanRecord.setMainReportId(dynamicObject.getLong("mainreportid"));
        sumPlanRecord.setReportCount(dynamicObject.getInt("reportcount"));
        sumPlanRecord.setSumUser((Long)dynamicObject.getDynamicObject("creator").getPkValue());
        sumPlanRecord.setInnerCancel(dynamicObject.getBoolean("offsetornot"));
        sumPlanRecord.setExchangeRateTableId(EmptyUtil.isEmpty((DynamicObject)dynamicObject.getDynamicObject("exratetable")) ? null : (Long)dynamicObject.getDynamicObject("exratetable").getPkValue());
        sumPlanRecord.setRateDate(dynamicObject.getDate("exchangeratedate"));
        sumPlanRecord.setAmountUnit(AmountUnit.getByNumber(dynamicObject.getString("amountunit")));
        sumPlanRecord.setRemark(dynamicObject.getString("remark"));
        DynamicObjectCollection attachTemplates = dynamicObject.getDynamicObjectCollection("attachtpl");
        sumPlanRecord.setAttachtplIdList(this.getIdListFromMultiDataBaseEdit(attachTemplates));
        ReportStatus reportStatus = this.getReportStatus(dynamicObject.getString("planstatus"));
        sumPlanRecord.setReportStatus(reportStatus);
        DynamicObjectCollection periodMemList = dynamicObject.getDynamicObjectCollection("periods");
        sumPlanRecord.setPeriodMemberIdList(this.getIdListFromMultiDataBaseEdit(periodMemList));
        Map<Long, Map<Long, BigDecimal>> rateMap = this.buildExchangeRateMap(sumPlanRecord.getExchangeRateTableId(), sumPlanRecord.getRateDate(), sumPlanRecord.getSystemId(), sumPlanRecord.getReportPeriodTypeId(), sumPlanRecord.getReportOrg());
        sumPlanRecord.setCurrencyRateMap(rateMap);
        return sumPlanRecord;
    }

    private ReportStatus getReportStatus(String planStatus) {
        return ReportStatus.getByVal(planStatus);
    }

    private List<Long> getIdListFromMultiDataBaseEdit(DynamicObjectCollection dynamicObjectCollection) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return Collections.emptyList();
        }
        return dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(id -> (Long)id).collect(Collectors.toList());
    }

    private Map<Long, Map<Long, BigDecimal>> buildExchangeRateMap(Long rateTableId, Date rateDate, Long systemId, Long reportPeriodType, Long reportOrgId) {
        SumPlanRepository sumPlanRepository = new SumPlanRepository();
        List<SumPlanParamConfig> sumPlanParamConfigList = sumPlanRepository.loadSumConfigBySystem(systemId, Collections.singleton(reportPeriodType), false);
        if (EmptyUtil.isEmpty(sumPlanParamConfigList)) {
            return Collections.emptyMap();
        }
        SumPlanParamConfig sumPlanParamConfig = sumPlanParamConfigList.get(0);
        SumPlanParamConfigInfo sumPlanParamConfigInfo = sumPlanParamConfig.getConfigInfoList().stream().filter(item -> item.getOrgMemberId().equals(reportOrgId)).findFirst().get();
        SumPlanParamConfigInfo.CurrencyMapCase currencyMapCase = sumPlanParamConfigInfo.getCurrencyMapCase();
        HashMap<Long, Map<Long, BigDecimal>> currencyRateMap = new HashMap<Long, Map<Long, BigDecimal>>();
        if (currencyMapCase != null) {
            HashSet<Long> currencyIdList = new HashSet<Long>(16);
            List<SumPlanParamConfigInfo.CurrencyMapCaseInfo> currencyMapCaseInfoList = currencyMapCase.getCurrencyMapCaseInfoList();
            for (SumPlanParamConfigInfo.CurrencyMapCaseInfo currencyMapCaseInfo : currencyMapCaseInfoList) {
                Long sumCurrencyId = currencyMapCaseInfo.getSumCurrencyId();
                List<Long> subOrgReportCurrencyId = currencyMapCaseInfo.getSubOrgReportCurrencyId();
                currencyIdList.add(sumCurrencyId);
                currencyIdList.addAll(subOrgReportCurrencyId);
            }
            DynamicObjectCollection currencyMemberColl = QueryServiceHelper.query((String)"fpm_member", (String)"id,sourceid", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIdList)});
            Map<Long, Object> idAndSourceIdMap = currencyMemberColl.stream().collect(Collectors.toMap(item -> item.getLong("id"), item -> item.get("sourceid")));
            for (SumPlanParamConfigInfo.CurrencyMapCaseInfo currencyMapCaseInfo : currencyMapCaseInfoList) {
                Long sumCurrencyId = currencyMapCaseInfo.getSumCurrencyId();
                List<Long> subOrgReportCurrencyId = currencyMapCaseInfo.getSubOrgReportCurrencyId();
                Object sourceId = idAndSourceIdMap.get(sumCurrencyId);
                HashMap<Long, BigDecimal> currRateMap = new HashMap<Long, BigDecimal>(32);
                for (Long subCurrency : subOrgReportCurrencyId) {
                    Object subSourceId = idAndSourceIdMap.get(subCurrency);
                    if (Objects.equals(subSourceId, sourceId)) continue;
                    BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)rateTableId, (Long)((Long)subSourceId), (Long)((Long)sourceId), (Date)rateDate);
                    if (exchangeRate == null) {
                        String selectFields = String.join((CharSequence)",", "id", "name");
                        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_currency", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)new Object[]{sourceId, subSourceId})});
                        Map<Long, String> currencyNameMap = dynamicObjects.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name"), (a, b) -> a));
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e01\u79cd:\u3010%1$s\u3011\u5230\u5e01\u79cd:\u3010%2$s\u3011\u4e4b\u95f4\u7f3a\u5c11\u8f6c\u6362\u6c47\u7387\uff0c\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"SumPlanRecordConverter_0", (String)"tmc-fpm-business", (Object[])new Object[0]), currencyNameMap.get(subSourceId), currencyNameMap.get(sourceId)));
                    }
                    currRateMap.put(subCurrency, exchangeRate);
                }
                currencyRateMap.put(sumCurrencyId, currRateMap);
            }
        }
        return currencyRateMap;
    }
}

