/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DetailDataType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.MetricValType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.TemplateConsultSeatType;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateReferencePosType;
import kd.tmc.fpm.business.domain.enums.TemplateSmartGetValSetType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.model.template.TemplateMetric;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.mvc.converter.MemberConverterFactory;
import kd.tmc.fpm.business.mvc.converter.member.IMemberConverter;
import kd.tmc.fpm.business.mvc.converter.utils.TypeEnumUtil;
import kd.tmc.fpm.business.mvc.repository.impl.AuxiliaryFieldsRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DetailPlanFieldsRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimMemberRepository;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.common.enums.TemplateDimBDTypeEnum;
import kd.tmc.fpm.common.property.MetricMemberProp;

public class TemplatePOConverter {
    public static void convertIntoTemplatePO(DynamicObject templatePO, ReportTemplate template) {
        DynamicObject system = FpmDataServiceHelper.getBodySystemByCache(template.getSystemId());
        if (templatePO.getDataEntityType().getName().equals("fpm_template_bak")) {
            templatePO.set("templateid", (Object)template.getCopyId());
        }
        templatePO.set("id", (Object)template.getId());
        templatePO.set("model", (Object)system);
        templatePO.set("name", template.getMultiLanguageName());
        templatePO.set("number", (Object)template.getNumber());
        templatePO.set("ismaintable", (Object)template.isMainTable());
        templatePO.set("startcell", (Object)template.getStartLocation());
        templatePO.set("maxnum", (Object)template.getMaxLineCount());
        templatePO.set("comment", (Object)template.getDescription());
        templatePO.set("enable", (Object)(template.isEnable() ? "1" : "0"));
        templatePO.set("templatetype", (Object)template.getTemplateType().getNumber());
        if (template.getAmountUnit() != null) {
            templatePO.set("amountunit", (Object)template.getAmountUnit().getNumber());
        }
        templatePO.set("isincludesum", (Object)(template.isDetailIncludeSum() ? "1" : "0"));
        templatePO.set("releasestatus", (Object)(template.isRelease() ? "1" : "0"));
        templatePO.set("status", (Object)BillStatusEnum.AUDIT.getValue());
        templatePO.set("templateuses", (Object)TypeEnumUtil.getNumberOrDefault(template.getTemplateUse()));
        List<ReportTemplate> statAnalysisTemplateList = template.getStatAnalysisTemplateList();
        DynamicObject[] statAnalysisTemp = TmcDataServiceHelper.loadFromCache((Object[])statAnalysisTemplateList.stream().map(ReportTemplate::getId).toArray(), (String)"fpm_template").values().toArray(new DynamicObject[0]);
        DynamicObjectCollection statAnalysisTempList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)templatePO, (DynamicObjectType)templatePO.getDynamicObjectType(), (String)"statanalysistemplate", (DynamicObject[])statAnalysisTemp);
        templatePO.set("statanalysistemplate", (Object)statAnalysisTempList);
        templatePO.set("effectivedate", (Object)template.getEffectiveDate());
        DynamicObjectCollection reportTypeEntry = templatePO.getDynamicObjectCollection("reporttypeentry");
        reportTypeEntry.clear();
        List<TemplateReportType> reportTypeList = template.getReportTypeList();
        Map<String, DynamicObject> metricMap = TemplatePOConverter.getMetricDyMap(template.getSystemId());
        if (!CollectionUtils.isEmpty(reportTypeList)) {
            DynamicObjectCollection reportTypeDy = system.getDynamicObjectCollection("applyrereportentry");
            Map reportTypeEntryMap = reportTypeDy.stream().collect(Collectors.toMap(dy -> dy.getDynamicObject("rerporttype").getPkValue(), Function.identity(), (a, b) -> a));
            for (TemplateReportType templateReportType : reportTypeList) {
                List<Long> auxiliaryFieldIds;
                List<Long> referencePosIds;
                DynamicObjectCollection referencePosTempList;
                DynamicObject[] referencePosDyArr;
                DynamicObject dynamicObject = reportTypeEntry.addNew();
                dynamicObject.set("e_reporttype", (Object)templateReportType.getReportTypeId());
                DynamicObject bodySysReportTypeEntry = (DynamicObject)reportTypeEntryMap.get(templateReportType.getReportTypeId());
                if (EmptyUtil.isNoEmpty((DynamicObject)bodySysReportTypeEntry)) {
                    dynamicObject.set("rollcontaindetail", (Object)bodySysReportTypeEntry.getBoolean("iscontaindetail"));
                }
                if (!CollectionUtils.isEmpty(templateReportType.getReferencePosTypeS())) {
                    dynamicObject.set("refrencepos", (Object)String.join((CharSequence)",", templateReportType.getReferencePosTypeS().stream().map(item -> item.getNumber()).collect(Collectors.toList())));
                    if (!metricMap.isEmpty() && EmptyUtil.isEmpty(templateReportType.getReferencePosIds())) {
                        Object[] objects = templateReportType.getReferencePosTypeS().stream().map(TemplateReferencePosType::getByTemplateReferencePosType).map(TemplateMetricType::getCode).map(metricMap::get).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).toArray();
                        referencePosDyArr = TmcDataServiceHelper.loadFromCache((Object[])objects, (String)"fpm_member").values().toArray(new DynamicObject[0]);
                        referencePosTempList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)dynamicObject, (DynamicObjectType)dynamicObject.getDynamicObjectType(), (String)"newreferencepos", (DynamicObject[])referencePosDyArr);
                        dynamicObject.set("newreferencepos", (Object)referencePosTempList);
                    }
                }
                if (EmptyUtil.isNoEmpty(referencePosIds = templateReportType.getReferencePosIds())) {
                    referencePosDyArr = TmcDataServiceHelper.loadFromCache((Object[])referencePosIds.toArray(), (String)"fpm_member").values().toArray(new DynamicObject[0]);
                    referencePosTempList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)dynamicObject, (DynamicObjectType)dynamicObject.getDynamicObjectType(), (String)"newreferencepos", (DynamicObject[])referencePosDyArr);
                    dynamicObject.set("newreferencepos", (Object)referencePosTempList);
                }
                if (EmptyUtil.isNoEmpty(auxiliaryFieldIds = templateReportType.getAuxiliaryFieldIds())) {
                    DynamicObject[] auxiliaryFieldDyArr = TmcDataServiceHelper.loadFromCache((Object[])auxiliaryFieldIds.toArray(), (String)"fpm_auxiliaryfields").values().toArray(new DynamicObject[0]);
                    DynamicObjectCollection auxiliaryFieldTempList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)dynamicObject, (DynamicObjectType)dynamicObject.getDynamicObjectType(), (String)"auxiliaryfield", (DynamicObject[])auxiliaryFieldDyArr);
                    dynamicObject.set("auxiliaryfield", (Object)auxiliaryFieldTempList);
                }
                dynamicObject.set("consultseat", (Object)TypeEnumUtil.getNumberOrDefault(templateReportType.getConsultSeatType()));
                dynamicObject.set("e_refrenceorg", (Object)templateReportType.getReferenceReportTypeId());
                dynamicObject.set("periodnum", (Object)templateReportType.getPeriodNum());
            }
        }
        DynamicObjectCollection metricEntry = templatePO.getDynamicObjectCollection("metricentry");
        metricEntry.clear();
        TemplateSmartGetValSetType smartGetValSetType = template.getSmartGetValSetType();
        if (smartGetValSetType != null) {
            templatePO.set("smartgetvalset", (Object)smartGetValSetType.getNumber());
            if (smartGetValSetType == TemplateSmartGetValSetType.REFERENCEVAL) {
                DynamicObject referenceMetricMember = metricMap.get(TemplateMetricType.PLANREFERENCEAMT.getCode());
                DynamicObject planReferenceAmtMetric = metricEntry.addNew();
                planReferenceAmtMetric.set("metrictype", (Object)TemplateMetricType.PLANREFERENCEAMT.getCode());
                planReferenceAmtMetric.set("newmetrictype", (Object)referenceMetricMember);
                planReferenceAmtMetric.set("returnval", (Object)"1");
                planReferenceAmtMetric.set("preset", (Object)TemplatePOConverter.getStringValueOrDefault(referenceMetricMember, "preset", dy -> false, "1"));
                planReferenceAmtMetric.set("bizfiled", (Object)TemplatePOConverter.getMetricBusinessFieldVal(referenceMetricMember, "referenceamt"));
            }
        }
        DynamicObject planAmtMetric = metricEntry.addNew();
        DynamicObject planAmtMetricMember = metricMap.get(TemplateMetricType.PLANAMT.getCode());
        planAmtMetric.set("metrictype", (Object)TemplateMetricType.PLANAMT.getCode());
        planAmtMetric.set("newmetrictype", (Object)planAmtMetricMember);
        planAmtMetric.set("returnval", (Object)"1");
        planAmtMetric.set("preset", (Object)TemplatePOConverter.getStringValueOrDefault(planAmtMetricMember, "preset", dy -> false, "1"));
        planAmtMetric.set("bizfiled", (Object)TemplatePOConverter.getMetricBusinessFieldVal(planAmtMetricMember, "planamt"));
        TemplatePOConverter.addSumPlanMetric(metricEntry, template, metricMap);
        List<Long> reportPeriods = template.getReportPeriods();
        if (!CollectionUtils.isEmpty(reportPeriods) || !CollectionUtils.isEmpty(reportTypeList)) {
            reportPeriods = CollectionUtils.isEmpty(reportPeriods) ? reportTypeList.stream().map(TemplateReportType::getReportTypeId).collect(Collectors.toList()) : reportPeriods;
            Map reportIdToReportMap = TmcDataServiceHelper.loadDataAndMapById((String)"fpm_orgreporttype", reportPeriods);
            DynamicObject[] memberArr = (DynamicObject[])reportPeriods.stream().map(reportIdToReportMap::get).toArray(DynamicObject[]::new);
            DynamicObjectCollection memberList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)templatePO, (DynamicObjectType)templatePO.getDynamicObjectType(), (String)"reporttype", (DynamicObject[])memberArr);
            templatePO.set("reporttype", (Object)memberList);
        } else {
            templatePO.set("reporttype", null);
        }
        List<TemplateLayout.LayoutInfo> layoutInfoList = template.getDimLayout().getDimLayoutInfoList();
        DynamicObjectCollection layoutEntry = templatePO.getDynamicObjectCollection("layoutentry");
        layoutEntry.clear();
        List dimIdList = layoutInfoList.stream().map(TemplateLayout.LayoutInfo::getDimensionId).collect(Collectors.toList());
        List memIdList = layoutInfoList.stream().map(TemplateLayout.LayoutInfo::getExpandMembers).flatMap(Collection::stream).collect(Collectors.toList());
        Map dimIdToDimMap = TmcDataServiceHelper.loadFromCache((Object[])dimIdList.toArray(), (String)"fpm_dimension");
        Map memIdToMemMap = TmcDataServiceHelper.loadFromCache((Object[])memIdList.toArray(), (String)"fpm_member");
        for (TemplateLayout.LayoutInfo layoutInfo : layoutInfoList) {
            DynamicObject entry = layoutEntry.addNew();
            entry.set("layoutdim", dimIdToDimMap.get(layoutInfo.getDimensionId()));
            if (layoutInfo.getDimLocation() != null) {
                entry.set("dimtype", (Object)layoutInfo.getDimLocation().getNumber());
            }
            entry.set("dimlevel", (Object)layoutInfo.getLevel());
            entry.set("dimhide", (Object)(!layoutInfo.isVisible() ? 1 : 0));
            entry.set("isexpandmem", (Object)layoutInfo.isExpand());
            entry.set("iscontaintotal", (Object)(layoutInfo.isIncludeSum() ? "1" : "0"));
            List<Long> members = layoutInfo.getExpandMembers();
            if (!CollectionUtils.isEmpty(members)) {
                DynamicObject[] memberArr = (DynamicObject[])members.stream().map(memIdToMemMap::get).toArray(DynamicObject[]::new);
                DynamicObjectCollection memberList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)entry, (DynamicObjectType)entry.getDynamicObjectType(), (String)"expandmember", (DynamicObject[])memberArr);
                entry.set("expandmember", (Object)memberList);
            } else {
                entry.set("expandmember", null);
            }
            entry.set("memberscope", (Object)TypeEnumUtil.getNumberOrDefault(layoutInfo.getScopeType()));
            entry.set("filterdim", (Object)layoutInfo.isFilterDim());
        }
        List<TemplateDim> allDimList = template.getAllTemplateDim();
        DynamicObjectCollection dimEntry = templatePO.getDynamicObjectCollection("dimsettingentry");
        dimEntry.clear();
        Set memIdSet = allDimList.stream().filter(o -> !o.isDetailDim()).map(TemplateDim::getMemberScope).filter(o -> !CollectionUtils.isEmpty((Collection)o)).flatMap(Collection::stream).collect(Collectors.toSet());
        allDimList.stream().filter(e -> null != e.getDefaultFilter()).forEach(e -> memIdSet.addAll(e.getDefaultFilter()));
        Map memScopeIdToMemMap = TmcDataServiceHelper.loadDataAndMapById((String)"fpm_member", memIdSet);
        for (TemplateDim templateDim : allDimList) {
            Optional<TemplateLayout.LayoutInfo> first;
            DynamicObject entry = dimEntry.addNew();
            entry.set("dim", (Object)templateDim.getDimensionId());
            entry.set("containsubtotal", (Object)templateDim.isIncludeSum());
            entry.set("ishide", (Object)(!templateDim.isVisible() ? 1 : 0));
            entry.set("level", (Object)templateDim.getLevel());
            entry.set("sequence", (Object)templateDim.getSequence());
            entry.set("isopen", (Object)templateDim.isExpand());
            entry.set("isdfsortitem", (Object)templateDim.isDefaultSortItem());
            entry.set("type", (Object)templateDim.getLocation().getNumber());
            entry.set("isdetaildim", (Object)templateDim.isDetailDim());
            entry.set("dimbdtype", (Object)(templateDim.isDetailDim() ? TemplateDimBDTypeEnum.DETAILPLAN.getValue() : TemplateDimBDTypeEnum.DIM.getValue()));
            entry.set("dimbd", (Object)templateDim.getDimensionId());
            entry.set("dimmemberscope", (Object)TypeEnumUtil.getNumberOrDefault(templateDim.getScopeType()));
            entry.set("dimfilterdim", (Object)templateDim.isFilterDim());
            entry.set("defaultdisplaymember", (Object)templateDim.getDefaultDisplayMember());
            entry.set("totalrow", (Object)templateDim.isTotalRow());
            entry.set("subjectflowtotal", (Object)templateDim.isSubjectFlowTotal());
            List<Long> memScope = templateDim.getMemberScope();
            if (!CollectionUtils.isEmpty(memScope)) {
                DynamicObject[] memArr = (DynamicObject[])memScope.stream().map(memScopeIdToMemMap::get).filter(Objects::nonNull).toArray(DynamicObject[]::new);
                if (memArr.length > 0) {
                    DynamicObjectCollection memList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)entry, (DynamicObjectType)entry.getDynamicObjectType(), (String)"plantemplatemember", (DynamicObject[])memArr);
                    if (templateDim.getDimType() == DimensionType.SUBJECTS) {
                        DynamicObjectCollection subjectMemberList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)templatePO, (DynamicObjectType)templatePO.getDynamicObjectType(), (String)"subjectmember", (DynamicObject[])memArr);
                        templatePO.set("subjectmember", (Object)subjectMemberList);
                    }
                    entry.set("plantemplatemember", (Object)memList);
                }
            } else {
                entry.set("plantemplatemember", null);
            }
            List<Long> defaultFilter = templateDim.getDefaultFilter();
            if (!CollectionUtils.isEmpty(defaultFilter)) {
                DynamicObject[] filterArr = (DynamicObject[])defaultFilter.stream().map(memScopeIdToMemMap::get).toArray(DynamicObject[]::new);
                DynamicObjectCollection filterList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)entry, (DynamicObjectType)entry.getDynamicObjectType(), (String)"defaultfilter", (DynamicObject[])filterArr);
                entry.set("defaultfilter", (Object)filterList);
            } else {
                entry.set("defaultfilter", null);
            }
            if (TemplateType.DETAIL != template.getTemplateType() || !(first = layoutInfoList.stream().filter(item -> item.getDimensionId().equals(templateDim.getDimensionId())).findFirst()).isPresent()) continue;
            entry.set("containsubtotal", (Object)first.get().isIncludeSum());
        }
        templatePO.set("isshowcombine", (Object)(template.isShowcombine() ? "1" : "0"));
        templatePO.set("isdistinguish", (Object)(template.isDistinguish() ? "1" : "0"));
        templatePO.set("isshownote", (Object)(template.isRemarkVisible() ? "1" : "0"));
        templatePO.set("notename", (Object)template.getRemarkName());
        List<Long> remarkFieldList = template.getRemarkFieldList();
        DynamicObject[] remarkFieldDys = TmcDataServiceHelper.load((Object[])remarkFieldList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_auxiliaryfields"));
        DynamicObjectCollection remarkFieldDc = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)templatePO, (DynamicObjectType)templatePO.getDynamicObjectType(), (String)"remarkfield", (DynamicObject[])remarkFieldDys);
        templatePO.set("remarkfield", (Object)remarkFieldDc);
        List<TemplateAccountSetting> accountSettingList = template.getAccountSettings();
        DynamicObjectCollection accountEntry = templatePO.getDynamicObjectCollection("subjecttentry");
        accountEntry.clear();
        List accountIdList = accountSettingList.stream().map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toList());
        Set templateIdList = accountSettingList.stream().filter(e -> e.getChildTemplateId() != null).map(TemplateAccountSetting::getChildTemplateId).collect(Collectors.toSet());
        Map acctIdToAcctMap = TmcDataServiceHelper.loadDataAndMapById((String)"fpm_member", accountIdList);
        Map templateIdToTemplateMap = null;
        templateIdToTemplateMap = templatePO.getDataEntityType().getName().equals("fpm_template_bak") ? TmcDataServiceHelper.loadDataAndMapById((String)"fpm_template_bak", templateIdList) : TmcDataServiceHelper.loadDataAndMapById((String)"fpm_template", templateIdList);
        templatePO.set("subtemplatecount", (Object)templateIdList.size());
        for (TemplateAccountSetting accountSetting : accountSettingList) {
            DynamicObject entry = accountEntry.addNew();
            entry.set("formula", (Object)accountSetting.getFormula());
            entry.set("reportways", (Object)accountSetting.getInputType().getNumber());
            entry.set("isleaf", (Object)accountSetting.isLeaf());
            entry.set("hideinreport", (Object)accountSetting.isHideInReport());
            Long accountMemId = accountSetting.getAccountMemId();
            entry.set("subject", acctIdToAcctMap.get(accountMemId));
            Long childTemplateId = accountSetting.getChildTemplateId();
            if (childTemplateId != null) {
                entry.set("subtemplate", templateIdToTemplateMap.get(childTemplateId));
                continue;
            }
            entry.set("subtemplate", null);
        }
        List<Long> userIdList = template.getUserIdList();
        if (!CollectionUtils.isEmpty(userIdList)) {
            DynamicObject[] orgArr = TmcDataServiceHelper.loadFromCache((Object[])userIdList.toArray(), (String)"fpm_member").values().toArray(new DynamicObject[0]);
            DynamicObjectCollection orgList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)templatePO, (String)"user", (DynamicObject[])orgArr);
            templatePO.set("user", (Object)orgList);
        } else {
            templatePO.set("user", null);
        }
        List<Long> currencyMemberIdList = template.getCurrencyMemberIdList();
        if (currencyMemberIdList != null && currencyMemberIdList.size() > 0) {
            DynamicObject[] memArr = (DynamicObject[])currencyMemberIdList.stream().map(memScopeIdToMemMap::get).toArray(DynamicObject[]::new);
            DynamicObjectCollection memList = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)templatePO, (DynamicObjectType)templatePO.getDynamicObjectType(), (String)"currencymember", (DynamicObject[])memArr);
            templatePO.set("currencymember", (Object)memList);
        } else {
            templatePO.set("currencymember", null);
        }
        if (Long.valueOf(0L).equals(templatePO.getPkValue())) {
            templatePO.set("createtime", (Object)new Date());
            templatePO.set("creator", (Object)template.getCreatorId());
        }
    }

    private static void addSumPlanMetric(DynamicObjectCollection metricEntry, ReportTemplate template, Map<String, DynamicObject> metricMap) {
        TemplateUseType templateUse = template.getTemplateUse();
        if (templateUse != TemplateUseType.SUMMARY) {
            return;
        }
        DynamicObject sumPlanMetric = metricEntry.addNew();
        DynamicObject reportPlanAmtMetricMember = metricMap.get(TemplateMetricType.REPORTPLANAMT.getCode());
        sumPlanMetric.set("metrictype", (Object)TemplateMetricType.REPORTPLANAMT.getCode());
        sumPlanMetric.set("newmetrictype", (Object)reportPlanAmtMetricMember);
        sumPlanMetric.set("returnval", (Object)"1");
        sumPlanMetric.set("preset", (Object)TemplatePOConverter.getStringValueOrDefault(reportPlanAmtMetricMember, "preset", dy -> false, "1"));
        sumPlanMetric.set("bizfiled", (Object)TemplatePOConverter.getMetricBusinessFieldVal(reportPlanAmtMetricMember, "reportplanamt"));
        DynamicObject evalMetric = metricEntry.addNew();
        DynamicObject originalAmtMetricMember = metricMap.get(TemplateMetricType.ORIGINALPLANAMT.getCode());
        evalMetric.set("metrictype", (Object)TemplateMetricType.ORIGINALPLANAMT.getCode());
        evalMetric.set("newmetrictype", (Object)originalAmtMetricMember);
        evalMetric.set("returnval", (Object)"1");
        evalMetric.set("preset", (Object)TemplatePOConverter.getStringValueOrDefault(originalAmtMetricMember, "preset", dy -> false, "1"));
        evalMetric.set("bizfiled", (Object)TemplatePOConverter.getMetricBusinessFieldVal(originalAmtMetricMember, "orginalplanamt"));
    }

    public static ReportTemplate convertToTemplate(DynamicObject template) {
        ReportTemplate reportTemplate = new ReportTemplate();
        reportTemplate.setId(template.getLong("id"));
        if (template.getDataEntityType().getName().equals("fpm_template_bak")) {
            reportTemplate.setCopyId(template.getLong("templateid"));
        }
        reportTemplate.setSystemId(template.getDynamicObject("model").getLong("id"));
        reportTemplate.setName(template.getString("name"));
        reportTemplate.setMultiLanguageName(template.get("name"));
        reportTemplate.setNumber(template.getString("number"));
        reportTemplate.setMainTable(template.getBoolean("ismaintable"));
        reportTemplate.setStartLocation(template.getString("startcell"));
        reportTemplate.setMaxLineCount(template.getInt("maxnum"));
        reportTemplate.setDescription(template.getString("comment"));
        reportTemplate.setEnable(template.getBoolean("enable"));
        reportTemplate.setDetailIncludeSum(template.getBoolean("isincludesum"));
        reportTemplate.setTotalSumVisible(template.getBoolean("isshowcombine"));
        reportTemplate.setTotalSumDictMem(template.getBoolean("isdistinguish"));
        reportTemplate.setEffectiveDate(template.getDate("effectivedate"));
        reportTemplate.setTemplateUse(ITypeEnum.getByNumber(template.getString("templateuses"), TemplateUseType.class));
        reportTemplate.setStatAnalysisTemplateList(TemplatePOConverter.getStatAnalysisTemplateList(template));
        if (template.getDynamicObject("creator") != null) {
            reportTemplate.setCreatorId(Long.parseLong(template.getDynamicObject("creator").getPkValue().toString()));
        }
        reportTemplate.setRelease(template.getBoolean("releasestatus"));
        Map<String, DynamicObject> metricDyMap = TemplatePOConverter.getMetricDyMap(reportTemplate.getSystemId());
        Map<Object, DynamicObject> customMetricDyMap = TemplatePOConverter.getCustomMetricDyMap(reportTemplate.getSystemId());
        Map<Object, DynamicObject> metricMemberDyMap = metricDyMap.values().stream().collect(Collectors.toMap(d -> d.getLong("id"), Function.identity()));
        DynamicObjectCollection reportTypeColl = template.getDynamicObjectCollection("reporttypeentry");
        ArrayList<TemplateReportType> reportTypeList = new ArrayList<TemplateReportType>(reportTypeColl.size());
        for (DynamicObject reportType : reportTypeColl) {
            reportTypeList.add(TemplatePOConverter.getTemplateReportType(metricDyMap, customMetricDyMap, metricMemberDyMap, reportType));
        }
        reportTemplate.setReportTypeList(reportTypeList);
        TemplatePOConverter.setMetricTplDim(template, reportTemplate, metricDyMap, customMetricDyMap, metricMemberDyMap);
        String smartGetSetStr = template.getString("smartgetvalset");
        if (EmptyUtil.isNotEmpty((CharSequence)smartGetSetStr)) {
            reportTemplate.setSmartGetValSetType(TemplateSmartGetValSetType.getByNumber(smartGetSetStr));
        }
        reportTemplate.setShowcombine(template.getBoolean("isshowcombine"));
        reportTemplate.setDistinguish(template.getBoolean("isdistinguish"));
        reportTemplate.setRemarkVisible(template.getBoolean("isshownote"));
        reportTemplate.setRemarkName(template.getString("notename"));
        DynamicObjectCollection remarkFieldDc = template.getDynamicObjectCollection("remarkfield");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)remarkFieldDc)) {
            reportTemplate.setRemarkFieldList(remarkFieldDc.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList()));
            reportTemplate.setRemarkEntityList(AuxiliaryFieldsRepository.getAuxiliaryField(reportTemplate.getRemarkFieldList()));
        }
        TemplateType templateType = TemplateType.getByNumber(template.getString("templatetype"));
        reportTemplate.setTemplateType(templateType);
        reportTemplate.setReportPeriods(TemplatePOConverter.getPeriodIdList(template, reportTemplate, reportTypeList));
        reportTemplate.setAmountUnit(AmountUnit.getByNumber(template.getString("amountunit")));
        reportTemplate.setDimLayout(TemplatePOConverter.getTemplateLayout(template, templateType));
        TemplatePOConverter.setTemplateDim(template, reportTemplate, templateType);
        reportTemplate.setAccountSettings(TemplatePOConverter.getTemplateAccountSettings(template));
        List<Long> userIdList = template.getDynamicObjectCollection("user").stream().map(o -> o.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList());
        reportTemplate.setUserIdList(userIdList);
        List<Long> currMemberIdList = template.getDynamicObjectCollection("currencymember").stream().map(o -> o.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList());
        reportTemplate.setCurrencyMemberIdList(currMemberIdList);
        return reportTemplate;
    }

    private static List<Long> getPeriodIdList(DynamicObject template, ReportTemplate reportTemplate, List<TemplateReportType> reportTypeList) {
        List<Long> periodIdList;
        if (CollectionUtils.isEmpty(reportTypeList)) {
            DynamicObjectCollection periodList = template.getDynamicObjectCollection("reporttype");
            periodIdList = periodList.stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            reportTemplate.setReportPeriods(periodIdList);
        } else {
            periodIdList = reportTypeList.stream().map(TemplateReportType::getReportTypeId).collect(Collectors.toList());
        }
        return periodIdList;
    }

    private static TemplateReportType getTemplateReportType(Map<String, DynamicObject> metricDyMap, Map<Object, DynamicObject> customMetricDyMap, Map<Object, DynamicObject> metricMemberDyMap, DynamicObject reportType) {
        DynamicObjectCollection auxiliaryFieldDc;
        DynamicObjectCollection referencePosDc;
        IMemberConverter metricMemberConverter = MemberConverterFactory.createMemberConverterByDimType(DimensionType.METRIC);
        TemplateReportType templateReportType = new TemplateReportType();
        templateReportType.setReportTypeId(reportType.getLong("e_reporttype.id"));
        templateReportType.setRollContainsDetail(reportType.getBoolean("rollcontaindetail"));
        templateReportType.setReferenceReportTypeId(reportType.getLong("e_refrenceorg.id"));
        if (EmptyUtil.isNotEmpty((CharSequence)reportType.getString("refrencepos"))) {
            String[] referencePosArr = reportType.getString("refrencepos").split(",");
            ArrayList<TemplateReferencePosType> referencePosTypeArr = new ArrayList<TemplateReferencePosType>(referencePosArr.length);
            for (String referencePos : referencePosArr) {
                if (!EmptyUtil.isNotEmpty((CharSequence)referencePos)) continue;
                referencePosTypeArr.add(TemplateReferencePosType.getByNumber(referencePos));
            }
            templateReportType.setReferencePosTypeS(referencePosTypeArr);
            if (!metricDyMap.isEmpty()) {
                Set numberSet = referencePosTypeArr.stream().map(TemplateReferencePosType::getNumber).collect(Collectors.toSet());
                List<MetricMember> metricMemberList = numberSet.stream().map(TemplateReferencePosType::getByNumber).map(TemplateReferencePosType::getByTemplateReferencePosType).map(TemplateMetricType::getNumber).map(metricDyMap::get).map(metricMemberConverter::convertToMember).map(member -> (MetricMember)member).collect(Collectors.toList());
                templateReportType.setReferencePosIds(metricMemberList.stream().map(DimMember::getId).collect(Collectors.toList()));
                templateReportType.setReferencePosList(metricMemberList);
            }
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(referencePosDc = reportType.getDynamicObjectCollection("newreferencepos")))) {
            List<Long> posdcList = referencePosDc.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList());
            templateReportType.setReferencePosIds(posdcList);
            ArrayList<MetricMember> posList = new ArrayList<MetricMember>();
            if (customMetricDyMap != null) {
                List customRefList = templateReportType.getReferencePosIds().stream().map(customMetricDyMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(customRefList)) {
                    List customList = customRefList.stream().map(metricMemberConverter::convertToMember).map(member -> (MetricMember)member).collect(Collectors.toList());
                    posList.addAll(customList);
                }
            }
            List refList = templateReportType.getReferencePosIds().stream().map(metricMemberDyMap::get).filter(Objects::nonNull).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(refList)) {
                List preSetList = refList.stream().map(metricMemberConverter::convertToMember).map(member -> (MetricMember)member).collect(Collectors.toList());
                posList.addAll(preSetList);
            }
            templateReportType.setReferencePosList(posList);
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(auxiliaryFieldDc = reportType.getDynamicObjectCollection("auxiliaryfield")))) {
            templateReportType.setAuxiliaryFieldIds(auxiliaryFieldDc.stream().map(dy -> dy.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(DataEntityBase::getPkValue).map(Long.class::cast).collect(Collectors.toList()));
            templateReportType.setAuxiliaryFieldList(AuxiliaryFieldsRepository.getAuxiliaryField(templateReportType.getAuxiliaryFieldIds()));
        }
        templateReportType.setConsultSeatType(ITypeEnum.getByNumber(reportType.getString("consultseat"), TemplateConsultSeatType.class));
        templateReportType.setPeriodNum(reportType.getInt("periodnum"));
        return templateReportType;
    }

    private static TemplateLayout getTemplateLayout(DynamicObject template, TemplateType templateType) {
        DynamicObjectCollection layoutEntry = template.getDynamicObjectCollection("layoutentry");
        TemplateLayout layout = new TemplateLayout(templateType, new ArrayList<TemplateLayout.LayoutInfo>());
        for (DynamicObject entry : layoutEntry) {
            TemplateLayout.LayoutInfo layoutInfo = new TemplateLayout.LayoutInfo();
            DynamicObject layoutDim = entry.getDynamicObject("layoutdim");
            if (Objects.isNull(layoutDim)) continue;
            long dimId = layoutDim.getLong("id");
            layoutInfo.setDimensionId(dimId);
            DimLocation location = DimLocation.getByNumber(entry.getString("dimtype"));
            layoutInfo.setDimLocation(location);
            layoutInfo.setLevel(entry.getInt("dimlevel"));
            layoutInfo.setVisible(!entry.getBoolean("dimhide"));
            layoutInfo.setExpand(entry.getBoolean("isexpandmem"));
            layoutInfo.setIncludeSum(entry.getBoolean("iscontaintotal"));
            DynamicObjectCollection memberList = entry.getDynamicObjectCollection("expandmember");
            List<Long> expandMemIdList = memberList.stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            layoutInfo.setExpandMembers(expandMemIdList);
            layoutInfo.setScopeType(ITypeEnum.getByNumber(entry.getString("memberscope"), TemplateDimMemScopeType.class));
            layoutInfo.setFilterDim(entry.getBoolean("filterdim"));
            layout.getDimLayoutInfoList().add(layoutInfo);
        }
        return layout;
    }

    private static void setMetricTplDim(DynamicObject template, ReportTemplate reportTemplate, Map<String, DynamicObject> metricDyMap, Map<Object, DynamicObject> customMetricDyMap, Map<Object, DynamicObject> metricMemberDyMap) {
        DynamicObjectCollection metricColl = template.getDynamicObjectCollection("metricentry");
        if (CollectionUtils.isEmpty((Collection)metricColl)) {
            return;
        }
        List sortMetricList = metricColl.stream().sorted(Comparator.comparing(o -> o.getDynamicObject("newmetrictype").getString("number"))).collect(Collectors.toList());
        IMemberConverter metricMemberConverter = MemberConverterFactory.createMemberConverterByDimType(DimensionType.METRIC);
        ArrayList<TemplateMetric> templateMetricS = new ArrayList<TemplateMetric>(metricColl.size());
        ArrayList<Long> memberScope = new ArrayList<Long>();
        for (DynamicObject metricObj : sortMetricList) {
            DynamicObject metricDy;
            Long metricId;
            TemplateMetric templateMetric = new TemplateMetric();
            templateMetric.setId(metricObj.getLong("id"));
            String metricTypeStr = metricObj.getString("metrictype");
            if (EmptyUtil.isNotEmpty((CharSequence)metricTypeStr)) {
                templateMetric.setMetricType(TemplateMetricType.valueOf(metricTypeStr));
            }
            Long l = metricId = EmptyUtil.isEmpty((DynamicObject)(metricDy = metricObj.getDynamicObject("newmetrictype"))) ? Long.valueOf(0L) : (Long)metricDy.getPkValue();
            if (EmptyUtil.isNoEmpty((DynamicObject)metricDy) && metricMemberDyMap.containsKey(metricId)) {
                templateMetric.setMetricType(ITypeEnum.getByNumber(metricDy.getString("metricpresettype"), TemplateMetricType.class));
                templateMetric.setMetricId(metricId);
                templateMetric.setMetricMember((MetricMember)metricMemberConverter.convertToMember(metricMemberDyMap.get(metricId)));
                memberScope.add(metricId);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)metricDy) && customMetricDyMap != null && customMetricDyMap.containsKey(metricId)) {
                templateMetric.setMetricType(ITypeEnum.getByNumber(metricDy.getString("metricpresettype"), TemplateMetricType.class));
                templateMetric.setMetricId(metricId);
                templateMetric.setMetricMember((MetricMember)metricMemberConverter.convertToMember(customMetricDyMap.get(metricId)));
                memberScope.add(metricId);
            }
            templateMetric.setBizFiled(metricObj.getString("bizfiled"));
            templateMetric.setPreSet(metricObj.getBoolean("preset"));
            templateMetric.setReturnVal(metricObj.getBoolean("returnval"));
            templateMetricS.add(templateMetric);
        }
        reportTemplate.setMetrics(templateMetricS);
        if (!metricDyMap.isEmpty()) {
            reportTemplate.setMetricTplDim(TemplatePOConverter.warpMetricDim(memberScope, metricDyMap.values().iterator().next()));
        }
    }

    private static List<TemplateAccountSetting> getTemplateAccountSettings(DynamicObject template) {
        ArrayList<TemplateAccountSetting> accountSettingList = new ArrayList<TemplateAccountSetting>();
        DynamicObjectCollection accountEntry = template.getDynamicObjectCollection("subjecttentry");
        HashMap parentChildNodeMappings = new HashMap(16);
        for (DynamicObject entry : accountEntry) {
            DynamicObject childTemplate;
            TemplateAccountSetting accSetting = new TemplateAccountSetting();
            accSetting.setId(entry.getLong("id"));
            Long acctId = entry.getDynamicObject("subject").getLong("id");
            accSetting.setAccountMemId(acctId);
            accSetting.setFormula(entry.getString("formula"));
            DynamicObject parentAcct = entry.getDynamicObject("subject").getDynamicObject("parent");
            if (null != parentAcct) {
                HashSet<Long> sonIds;
                Long parentAcctId = parentAcct.getLong("id");
                boolean isContain = parentChildNodeMappings.containsKey(parentAcctId);
                if (isContain) {
                    sonIds = (HashSet<Long>)parentChildNodeMappings.get(parentAcctId);
                    sonIds.add(acctId);
                } else {
                    sonIds = new HashSet<Long>(16);
                    sonIds.add(acctId);
                    parentChildNodeMappings.put(parentAcctId, sonIds);
                }
            }
            if ((childTemplate = entry.getDynamicObject("subtemplate")) != null) {
                accSetting.setChildTemplateId(childTemplate.getLong("id"));
            }
            ReportInputType inputType = ReportInputType.getByNumber(entry.getString("reportways"));
            accSetting.setInputType(inputType);
            accSetting.setLeaf(entry.getBoolean("isleaf"));
            accSetting.setHideInReport(entry.getBoolean("hideinreport"));
            accountSettingList.add(accSetting);
        }
        for (TemplateAccountSetting acctSetting : accountSettingList) {
            Long accountMemId = acctSetting.getAccountMemId();
            Set sonIds = (Set)parentChildNodeMappings.get(accountMemId);
            if (sonIds == null || sonIds.size() <= 0) continue;
            List<TemplateAccountSetting> childAcctSettings = accountSettingList.stream().filter(Objects::nonNull).filter(o -> sonIds.contains(o.getAccountMemId())).collect(Collectors.toList());
            acctSetting.setChildren(childAcctSettings);
        }
        return accountSettingList;
    }

    private static void setTemplateDim(DynamicObject template, ReportTemplate reportTemplate, TemplateType templateType) {
        DynamicObjectCollection dimEntry = template.getDynamicObjectCollection("dimsettingentry");
        List dimIdList = dimEntry.stream().filter(o -> !o.getBoolean("isdetaildim")).map(o -> o.getLong("dim")).collect(Collectors.toList());
        Map<Object, DynamicObject> dimensionMap = FpmDataServiceHelper.loadFromCache("fpm_dimension", "id,name,basedata", new QFilter("id", "in", dimIdList).toArray());
        dimIdList = dimEntry.stream().filter(o -> o.getBoolean("isdetaildim")).map(o -> o.getLong("dim")).collect(Collectors.toList());
        new DetailPlanFieldsRepository();
        Map<Object, DynamicObject> detailDimMap = DetailPlanFieldsRepository.loadFromCache("id,name,detaildimtype,datatype,basedatatype.number", new QFilter("id", "in", dimIdList).toArray());
        ArrayList<DynamicObject> dimEntryList = new ArrayList<DynamicObject>((Collection<DynamicObject>)dimEntry);
        if (templateType == TemplateType.FIXED) {
            dimEntryList.sort(Comparator.comparingInt(o -> o.getInt("level")));
        } else {
            dimEntryList.sort(Comparator.comparingInt(o -> o.getInt("sequence")));
        }
        for (DynamicObject entry : dimEntryList) {
            DimLocation dimLocation = DimLocation.getByNumber(entry.getString("type"));
            TemplateDim dim = TemplatePOConverter.getTemplateDim(reportTemplate, dimensionMap, detailDimMap, entry, dimLocation);
            reportTemplate.setTemplateDim(dim, dimLocation);
        }
    }

    private static TemplateDim getTemplateDim(ReportTemplate reportTemplate, Map<Object, DynamicObject> dimensionMap, Map<Object, DynamicObject> detailDimMap, DynamicObject entry, DimLocation dimLocation) {
        TemplateDim dim = new TemplateDim();
        dim.setId(entry.getLong("id"));
        dim.setDimensionId(entry.getLong("dim"));
        dim.setLocation(dimLocation);
        dim.setDetailDim(entry.getBoolean("isdetaildim"));
        Long dimensionId = dim.getDimensionId();
        DynamicObject dimensionObj = dimensionMap.get(dimensionId);
        DynamicObject detailDimObj = detailDimMap.get(dimensionId);
        String dimName = dim.isDetailDim() ? detailDimObj.getString("name") : dimensionObj.getString("name");
        dim.setDimensionName(dimName);
        dim.setIncludeSum(entry.getBoolean("containsubtotal"));
        dim.setVisible(!entry.getBoolean("ishide"));
        dim.setLevel(entry.getInt("level"));
        dim.setSequence(entry.getInt("sequence"));
        dim.setExpand(entry.getBoolean("isopen"));
        dim.setDefaultSortItem(entry.getBoolean("isdfsortitem"));
        if (dim.isDetailDim()) {
            dim.setDimType(DimensionType.DETAILDIM);
            dim.setDetailDimType(DetailDimType.getDimsionByNumber(detailDimObj.getString("detaildimtype")));
            dim.setDetailDataType(ITypeEnum.getByNumber(detailDimObj.getString("datatype"), DetailDataType.class));
            dim.setBaseDataType(detailDimObj.getString("basedatatype.number"));
        } else {
            dim.setDimType(DimensionType.getDimsionByNumber(dimensionObj.getString("basedata")));
        }
        DynamicObjectCollection memberList = entry.getDynamicObjectCollection("plantemplatemember");
        List<Long> memberIdList = memberList.stream().map(o -> o.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toList());
        if (reportTemplate.getTemplateUse() == TemplateUseType.ANALYSIS) {
            DynamicObjectCollection filterList = entry.getDynamicObjectCollection("defaultfilter");
            List<Long> filterIdList = filterList.stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            dim.setDefaultFilter(filterIdList);
        }
        dim.setScopeType(ITypeEnum.getByNumber(entry.getString("dimmemberscope"), TemplateDimMemScopeType.class));
        dim.setFilterDim(entry.getBoolean("dimfilterdim"));
        dim.setTotalRow(entry.getBoolean("totalrow"));
        dim.setSubjectFlowTotal(entry.getBoolean("subjectflowtotal"));
        DynamicObject defaultDisplayMemberDO = (DynamicObject)entry.get("defaultdisplaymember");
        if (defaultDisplayMemberDO != null) {
            Long firstMember = (Long)defaultDisplayMemberDO.getPkValue();
            dim.setDefaultDisplayMember(firstMember);
            int idx = memberIdList.indexOf(firstMember);
            if (idx != -1) {
                memberIdList.remove(idx);
                memberIdList.add(0, firstMember);
            }
        }
        dim.setMemberScope(memberIdList);
        return dim;
    }

    private static List<ReportTemplate> getStatAnalysisTemplateList(DynamicObject template) {
        DynamicObjectCollection dynamicObjectCollection = template.getDynamicObjectCollection("statanalysistemplate");
        List<ReportTemplate> statReportTemplateList = Collections.emptyList();
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            List statTemplateIds = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(id -> (Long)id).collect(Collectors.toList());
            Collection load = TmcDataServiceHelper.loadFromCache((Object[])statTemplateIds.toArray(), (String)"fpm_template").values();
            statReportTemplateList = load.stream().map(TemplatePOConverter::convertToTemplate).collect(Collectors.toList());
        }
        return statReportTemplateList;
    }

    private static TemplateDim warpMetricDim(List<Long> memberScope, DynamicObject metricMember) {
        TemplateDim dim = new TemplateDim();
        dim.setDimensionId(metricMember.getLong("dimension.id"));
        dim.setDimensionName(metricMember.getString("dimension.name"));
        dim.setDetailDim(false);
        dim.setIncludeSum(false);
        dim.setVisible(true);
        dim.setExpand(false);
        dim.setScopeType(TemplateDimMemScopeType.FIXED_MEMBER);
        dim.setLocation(DimLocation.COL);
        dim.setDimType(DimensionType.METRIC);
        dim.setMemberScope(memberScope);
        return dim;
    }

    private static Map<String, DynamicObject> getMetricDyMap(Long bodySysId) {
        DynamicObject[] metricMembers = new DimMemberRepository().loadMetricDimMembers(Collections.singletonList(bodySysId));
        return Arrays.stream(metricMembers).collect(Collectors.toMap(dy -> dy.getString("metricpresettype"), Function.identity()));
    }

    private static Map<Object, DynamicObject> getCustomMetricDyMap(Object bodySysId) {
        return TmcDataServiceHelper.loadFromCache((String)"fpm_member", (String)MetricMemberProp.CONVERT_FILEDS, (QFilter[])new QFilter("metricpresettype", "=", (Object)TemplateMetricType.CUSTOM.getCode()).and("bodysystem", "=", bodySysId).and("preset", "=", (Object)Boolean.FALSE).and("dimtype", "=", (Object)DimensionType.METRIC.getNumber()).toArray());
    }

    private static String getStringValueOrDefault(DynamicObject dy, String propName, Predicate<DynamicObject> predicate, String defaultValue) {
        String value = dy.getString(propName);
        return EmptyUtil.isEmpty((String)value) || predicate.test(dy) ? defaultValue : value;
    }

    private static String getMetricBusinessFieldVal(DynamicObject dynamicObject, String defaultValue) {
        return TemplatePOConverter.getStringValueOrDefault(dynamicObject, "computeformulavalue_tag", dy -> {
            String metricType = dy.getString("metrictype");
            return Objects.equals(metricType, MetricValType.FORMULA.name());
        }, defaultValue);
    }
}

