/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter;

import java.util.Arrays;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.VerifyReport;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;

public class VerifyReportConverter
implements IConverter<VerifyReport, DynamicObject> {
    @Override
    public VerifyReport convert(DynamicObject reportObj) {
        long reportOrgId = reportObj.getLong("reportorg.id");
        long periodId = reportObj.getLong("reportperiod.id");
        long templetId = reportObj.getLong("template.id");
        Map memberMap = TmcDataServiceHelper.loadFromCache((String)"fpm_member", (String)"id,name,reporttype.id", (QFilter[])new QFilter("id", "in", Arrays.asList(reportOrgId, periodId)).toArray());
        DynamicObject templateObj = TmcDataServiceHelper.loadSingleFromCache((Object)templetId, (String)"fpm_template", (String)"id,templatetype");
        VerifyReport report = new VerifyReport();
        report.setId(reportObj.getLong("id"));
        report.setNumber(reportObj.getString("billno"));
        report.setSystemId(reportObj.getLong("bodysys.id"));
        ReportTemplate template = new ReportTemplate();
        template.setId(templetId);
        template.setTemplateType(templateObj != null ? TemplateType.getByNumber(templateObj.getString("templatetype")) : null);
        report.setTemplate(template);
        OrgMember orgMember = new OrgMember();
        orgMember.setId(reportOrgId);
        DynamicObject reportOrg = (DynamicObject)memberMap.get(reportOrgId);
        orgMember.setName(reportOrg != null ? reportOrg.getString("name") : null);
        report.setOrgMember(orgMember);
        PeriodMember periodMember = new PeriodMember();
        DynamicObject period = (DynamicObject)memberMap.get(periodId);
        periodMember.setId(periodId);
        periodMember.setName(period != null ? period.getString("name") : null);
        periodMember.setPeriodTypeId(period != null ? Long.valueOf(period.getLong("reporttype.id")) : null);
        report.setPeriodMember(periodMember);
        report.setInitflag(reportObj.getBoolean("initflag"));
        return report;
    }
}

