/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.PeriodControlStrategyType;
import kd.tmc.fpm.business.domain.model.control.ApplyReportOrg;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.control.ReportType;
import kd.tmc.fpm.business.mvc.converter.control.Converter;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import org.apache.commons.collections.CollectionUtils;

public class ControlStrategyConverter
implements Converter<ControlStrategy> {
    @Override
    public ControlStrategy convert(DynamicObject dynamicObject) {
        ControlStrategy controlStrategy = new ControlStrategy();
        controlStrategy.setId((Long)dynamicObject.getPkValue());
        controlStrategy.setSystemId((Long)dynamicObject.getDynamicObject("bodysys").getPkValue());
        controlStrategy.setName(dynamicObject.getString("name"));
        controlStrategy.setNumber(dynamicObject.getString("number"));
        controlStrategy.setNeedUnAvailableWarn(dynamicObject.getBoolean("isunavailablewarn"));
        controlStrategy.setUnAvailableWarn(dynamicObject.getInt("unavailablewarn"));
        controlStrategy.setEnable(dynamicObject.getBoolean("enable"));
        this.setReportType(controlStrategy, dynamicObject.getDynamicObjectCollection("reporttype"));
        controlStrategy.setPeriodControlStrategyType(ITypeEnum.getByNumber(dynamicObject.getString("periodstrategy"), PeriodControlStrategyType.class));
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("treeentryentity");
        this.setControlStrategyDetails(controlStrategy, dynamicObjectCollection);
        controlStrategy.setApplyReportOrgs((List<ApplyReportOrg>)((Object)ConverterUtils.convert(ApplyReportOrg.class, dynamicObject.getDynamicObjectCollection("entryentity"))));
        return controlStrategy;
    }

    private void setControlStrategyDetails(ControlStrategy controlStrategy, DynamicObjectCollection dynamicObjectCollection) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        ControlStrategyDetail controlStrategyDetailList = ConverterUtils.convert(ControlStrategyDetail.class, dynamicObjectCollection);
        Map<Long, ControlStrategyDetail> strategyDetailMap = controlStrategyDetailList.stream().collect(Collectors.toMap(ControlStrategyDetail::getSubjectId, Function.identity()));
        this.setParentDetailIdS((List<ControlStrategyDetail>)((Object)controlStrategyDetailList), strategyDetailMap);
        controlStrategy.setControlStrategyDetails((List<ControlStrategyDetail>)((Object)controlStrategyDetailList));
    }

    private void setParentDetailIdS(List<ControlStrategyDetail> controlStrategyDetailList, Map<Long, ControlStrategyDetail> strategyDetailMap) {
        for (ControlStrategyDetail controlStrategyDetail : controlStrategyDetailList) {
            ArrayList<Long> parentIdS = new ArrayList<Long>(16);
            this.setParentDetailIdS(controlStrategyDetail, strategyDetailMap, parentIdS);
            controlStrategyDetail.setAllParentIdS(parentIdS);
        }
    }

    private void setParentDetailIdS(ControlStrategyDetail strategyDetail, Map<Long, ControlStrategyDetail> strategyDetailMap, List<Long> parentIdS) {
        Long parentId = strategyDetail.getParentId();
        if (parentId == null || parentId.compareTo(0L) == 0) {
            return;
        }
        parentIdS.add(parentId);
        this.setParentDetailIdS(strategyDetailMap.get(parentId), strategyDetailMap, parentIdS);
    }

    private void setReportType(ControlStrategy controlStrategy, DynamicObjectCollection dynamicObjectCollection) {
        if (Objects.isNull(dynamicObjectCollection) || dynamicObjectCollection.isEmpty()) {
            controlStrategy.setReportType(Collections.emptyList());
            return;
        }
        Object[] reportTypePks = dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).toArray();
        String selectProp = String.join((CharSequence)",", "id", "number", "name", "orgreportcycle", "orgreporttype");
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_orgreporttype", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)reportTypePks)});
        if (CollectionUtils.isEmpty((Collection)queryResult)) {
            controlStrategy.setReportType(Collections.emptyList());
            return;
        }
        controlStrategy.setReportType((List<ReportType>)((Object)ConverterUtils.convert(ReportType.class, queryResult)));
    }
}

