/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.constant.ReportConstant;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.report.ReportChangeData;
import kd.tmc.fpm.business.domain.model.report.ReportRowData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.service.dimension.impl.CustomDimSeqServiceImpl;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;
import kd.tmc.fpm.common.enums.DimsionEnums;

public class ReportChangeDataConverter
implements IConverter<ReportChangeData, ReportRowData> {
    @Override
    public ReportChangeData convert(ReportRowData rowData) {
        Row row = rowData.getRow();
        ReportChangeData reportChangeData = new ReportChangeData();
        reportChangeData.setId(row.getLong(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "id")));
        reportChangeData.setOriginalReportId(row.getLong(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_originalreportid")));
        reportChangeData.setReportId(row.getLong(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_originalreportid")));
        reportChangeData.setOriginalReportDataId(row.getLong(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_originalreportdataid")));
        this.fillMainDimensionData(reportChangeData, rowData);
        reportChangeData.setPlanAmt(row.getBigDecimal(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_planamt")));
        reportChangeData.setOriginalPlanAmt(row.getBigDecimal(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_originalplanamt")));
        reportChangeData.setLockAmt(row.getBigDecimal(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_lockamt")));
        reportChangeData.setActAmt(row.getBigDecimal(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_realamt")));
        reportChangeData.setCurrentAdjustAmt(row.getBigDecimal(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_currentadjustamt")));
        reportChangeData.setAdjustedPlanAmt(row.getBigDecimal(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_adjustedplanamt")));
        reportChangeData.setRow(row.getInteger(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_origindatarow")));
        reportChangeData.setCol(row.getInteger(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_origindatacol")));
        reportChangeData.setEffectFlag(row.getBoolean(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_effectflag")));
        reportChangeData.setReportPeriodId(row.getLong(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_reportperiod")));
        reportChangeData.setMainTable(row.getBoolean(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_maintable")));
        reportChangeData.setAmountUnit(AmountUnit.getByNumber(row.getString(ReportChangeDataConverter.getEntryEntireFieldName("main_entryentity", "main_amountunit"))));
        reportChangeData.setRemark(row.getString(ReportChangeDataConverter.getEntryEntireFieldName("detail_entryentity", "detail_remark")));
        this.fillDetailDimensionData(reportChangeData, rowData);
        ReportTemplate reportTemplate = rowData.getReportTemplateMap().get(reportChangeData.getOriginalReportId());
        List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
        if (!reportTemplate.getTemplateType().isDetail()) {
            reportChangeData.setAuxiliaryInfo(ReportHelper.isAuxiliaryInfo(reportChangeData.getDimList(), allTemplateDim));
        }
        return reportChangeData;
    }

    private static String getEntryEntireFieldName(String entryName, String fieldName) {
        return String.join((CharSequence)".", entryName, fieldName);
    }

    private void fillDetailDimensionData(ReportChangeData reportChangeData, ReportRowData rowData) {
        ReportTemplate reportTemplate = rowData.getReportTemplateMap().get(reportChangeData.getOriginalReportId());
        Map<String, String> detailMappingMap = DimensionMappingHelper.getAdjustDetailMappingWithEntry(reportTemplate.getSystemId());
        List<TemplateDim> dimList = reportChangeData.getDimList();
        List<Object> dimValueList = reportChangeData.getDimValList();
        List detailDimList = rowData.getDetailDimMap().getOrDefault(reportChangeData.getOriginalReportId(), Collections.emptyList());
        Row row = rowData.getRow();
        for (Map.Entry<String, String> entry : detailMappingMap.entrySet()) {
            String detailNumber = entry.getKey();
            String fieldName = entry.getValue();
            Object value = row.get(fieldName);
            List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
            Optional<TemplateDim> dimOptional = allTemplateDim.stream().filter(Objects::nonNull).filter(o -> o.getDimType() == DimensionType.DETAILDIM && o.getDetailDimType().getNumber().equals(detailNumber)).findAny();
            if (!dimOptional.isPresent()) continue;
            TemplateDim templateDim = dimOptional.get();
            Dimension dimension = detailDimList.stream().filter(item -> Objects.equals(item.getId(), templateDim.getDimensionId())).findFirst().get();
            MemberType memberType = dimension.getMemberType();
            if (DetailDimType.isExtraCode(detailNumber) && value != null && !StringUtils.isEmpty((Object)value.toString())) {
                if (MemberType.DATE == memberType) {
                    value = new Date(Long.parseLong(value.toString()));
                } else if (MemberType.BASE_DATA == memberType) {
                    value = Long.valueOf(value.toString());
                }
            }
            dimList.add(templateDim);
            dimValueList.add(value);
        }
    }

    private void fillMainDimensionData(ReportChangeData reportChangeData, ReportRowData rowData) {
        if (Objects.isNull(reportChangeData.getDimList())) {
            reportChangeData.setDimList(this.getFilterNull(reportChangeData.getDimList()));
            reportChangeData.setDimValList(this.getFilterNull(reportChangeData.getDimValList()));
        }
        List<TemplateDim> dimList = reportChangeData.getDimList();
        List<Object> dimValueList = reportChangeData.getDimValList();
        Row row = rowData.getRow();
        Long originalReportId = reportChangeData.getOriginalReportId();
        ReportTemplate reportTemplate = rowData.getReportTemplateMap().get(originalReportId);
        Map<String, List<TemplateDim>> templateMainDimMap = reportTemplate.getAllTemplateDim().stream().filter(item -> item.getDimType() != DimensionType.DETAILDIM).filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getDimType().getNumber()));
        Map<String, List<Long>> dimType2DimIdMap = rowData.getDimType2DimIdMap();
        for (Map.Entry<String, String> entry : ReportConstant.MAIN_DIM_ENTRY_ENTIRE_NAME_MAPPING_MAP.entrySet()) {
            if (ReportChangeDataConverter.dealCustomMember(row, dimList, templateMainDimMap, dimValueList, reportTemplate, entry, rowData.getSeqCustomDimMap())) continue;
            String dimensionNumber = entry.getKey();
            String fieldName = entry.getValue();
            Object value = row.get(fieldName);
            if (EmptyUtil.isEmpty((Object)value)) continue;
            DimensionType dimensionType = DimensionType.getDimsionByNumber(dimensionNumber);
            boolean fullDim = reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY;
            Optional<TemplateDim> dimOptional = reportTemplate.getAllTemplateDim().stream().filter(Objects::nonNull).filter(o -> o.getDimType() == dimensionType).findAny();
            if (dimOptional.isPresent()) {
                dimList.add(dimOptional.get());
                dimValueList.add(value);
                continue;
            }
            if (!fullDim || !dimType2DimIdMap.containsKey(dimensionType.getNumber())) continue;
            TemplateDim templateDim = new TemplateDim();
            templateDim.setDimType(dimensionType);
            DimsionEnums dimensionByNumber = DimsionEnums.getDimsionByNumber((String)dimensionType.getNumber());
            templateDim.setDimensionName(dimensionByNumber == null ? "" : dimensionByNumber.getName());
            templateDim.setDimensionId(dimType2DimIdMap.get(dimensionType.getNumber()).get(0));
            dimList.add(templateDim);
            dimValueList.add(value);
        }
    }

    private static boolean dealCustomMember(Row rowData, List<TemplateDim> dimList, Map<String, List<TemplateDim>> templateDimMap, List<Object> dimValList, ReportTemplate reportTemplate, Map.Entry<String, String> mainDimEntry, Map<Integer, Long> seqCustomDimMap) {
        if (DimensionType.CUSTOM.getNumber().equals(mainDimEntry.getKey())) {
            String widgetSignStr = mainDimEntry.getValue();
            String[] widgetSigns = widgetSignStr.split(",");
            List templateDimList = templateDimMap.getOrDefault(mainDimEntry.getKey(), Collections.emptyList());
            for (String widgetSign : widgetSigns) {
                boolean fullDim;
                Object value = rowData.get(widgetSign);
                if ((value == null || value.equals(0L)) && TemplateType.FIXED == reportTemplate.getTemplateType()) continue;
                boolean bl = fullDim = reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY;
                if (Objects.isNull(value) || CollectionUtils.isEmpty(templateDimList) && !fullDim || CollectionUtils.isEmpty(templateDimList) && !fullDim) continue;
                String[] properties = widgetSign.split("\\.");
                Integer seq = CustomDimSeqServiceImpl.adjustReportCustomProperty2SeqMap.get(properties[1]);
                Long dimId = seqCustomDimMap.get(seq);
                boolean isMatch = false;
                for (TemplateDim dim : templateDimList) {
                    if (dimList.contains(dim) || !Objects.equals(dimId, dim.getDimensionId())) continue;
                    isMatch = true;
                    dimList.add(dim);
                    dimValList.add(value);
                }
                if (isMatch || !fullDim) continue;
                TemplateDim templateDim = new TemplateDim();
                templateDim.setDimType(DimensionType.CUSTOM);
                templateDim.setDimensionId(dimId);
                dimValList.add(value);
                dimList.add(templateDim);
            }
            return true;
        }
        return false;
    }

    private <T> List<T> getFilterNull(List<T> list) {
        return Objects.isNull(list) ? new ArrayList(2) : list;
    }
}

