/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.inspection;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.inspection.AmtConsistencyExecRecord;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;

public class AmtConsistencyExecRecordConverter
implements IConverter<AmtConsistencyExecRecord, Row> {
    @Override
    public AmtConsistencyExecRecord convert(Row row) {
        AmtConsistencyExecRecord amtConsistencyExecRecord = new AmtConsistencyExecRecord();
        amtConsistencyExecRecord.setId(row.getLong("id"));
        amtConsistencyExecRecord.setRecordNumber(row.getString("billno"));
        amtConsistencyExecRecord.setActAmount(row.getBigDecimal("realamt"));
        amtConsistencyExecRecord.setExecuteOpType(PlanExecuteOpType.get(row.getString("planexecuteop")));
        amtConsistencyExecRecord.setDeleteStatus(row.getBoolean("deleteflag"));
        amtConsistencyExecRecord.setSystemId(row.getLong(String.join((CharSequence)".", "bodysys", "id")));
        amtConsistencyExecRecord.setReportOrgId(row.getLong(String.join((CharSequence)".", "reportorg", "id")));
        amtConsistencyExecRecord.setSubjectMember(row.getLong(String.join((CharSequence)".", "subjectmem", "id")));
        String matchedIds = row.getString("matchedreportdataids");
        if (StringUtils.isNotEmpty((CharSequence)matchedIds)) {
            String[] split = matchedIds.split(",");
            List<Long> reportDataIdList = Arrays.stream(split).map(Long::valueOf).collect(Collectors.toList());
            amtConsistencyExecRecord.setMatchedReportDataIdList(reportDataIdList);
        }
        return amtConsistencyExecRecord;
    }
}

