/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.inspection;

import java.util.Deque;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.InspectionExecResult;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.model.inspection.log.AmtConsistencyLog;
import kd.tmc.fpm.business.domain.model.inspection.log.AmtExceptionInfo;
import kd.tmc.fpm.business.domain.model.inspection.log.BaseLog;
import kd.tmc.fpm.business.domain.model.inspection.log.BillInspectionDetail;
import kd.tmc.fpm.business.domain.model.inspection.log.BillInspectionLog;
import kd.tmc.fpm.business.domain.model.inspection.log.BillNotExistInfo;
import kd.tmc.fpm.business.domain.model.inspection.log.BillNotExistLog;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.utils.CommonUtils;
import org.apache.commons.collections.CollectionUtils;

public class InspectionLogDynamicObjectConverter
implements IConverter<DynamicObject, BaseLog> {
    @Override
    public DynamicObject convert(BaseLog log) {
        List<Long> notifyStaffIdList;
        List<Long> inspectionOrgScope;
        DynamicObject dynamicObject = TmcDataServiceHelper.newDynamicObject((String)"fpm_inspection_log");
        dynamicObject.set("id", (Object)log.getId());
        dynamicObject.set("bodysys", (Object)log.getSystemId());
        dynamicObject.set("inspectiontype", (Object)log.getInspectionType().getNumber());
        dynamicObject.set("inspectionscope", (Object)log.getInspectionScope().getNumber());
        List<Long> inspectionPeriodScope = log.getInspectionPeriodScope();
        if (CollectionUtils.isNotEmpty(inspectionPeriodScope)) {
            DynamicObject[] inspectionPeriodArray = TmcDataServiceHelper.load((Object[])inspectionPeriodScope.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_member"));
            DynamicObjectCollection periodScopeColl = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)dynamicObject, (DynamicObjectType)dynamicObject.getDynamicObjectType(), (String)"exec_period_scope", (DynamicObject[])inspectionPeriodArray);
            dynamicObject.set("exec_period_scope", (Object)periodScopeColl);
        }
        if (CollectionUtils.isNotEmpty(inspectionOrgScope = log.getInspectionOrgScope())) {
            DynamicObject[] inspectionOrgArray = TmcDataServiceHelper.load((Object[])inspectionOrgScope.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_member"));
            DynamicObjectCollection orgScopeColl = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)dynamicObject, (DynamicObjectType)dynamicObject.getDynamicObjectType(), (String)"exec_org_scope", (DynamicObject[])inspectionOrgArray);
            dynamicObject.set("exec_org_scope", (Object)orgScopeColl);
        }
        if (CollectionUtils.isNotEmpty(notifyStaffIdList = log.getNotifyStaffIdList())) {
            DynamicObject[] notifyStaffArray = TmcDataServiceHelper.load((Object[])notifyStaffIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_user"));
            DynamicObjectCollection periodScopeColl = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)dynamicObject, (DynamicObjectType)dynamicObject.getDynamicObjectType(), (String)"notifiedstaffs", (DynamicObject[])notifyStaffArray);
            dynamicObject.set("notifiedstaffs", (Object)periodScopeColl);
        }
        dynamicObject.set("startdate", (Object)log.getInspectionStartDate());
        dynamicObject.set("enddate", (Object)log.getInspectionEndDate());
        dynamicObject.set("execdate", (Object)log.getExecDate());
        dynamicObject.set("finishdate", (Object)log.getFinishDate());
        dynamicObject.set("execstatus", (Object)log.getExecStatus().getNumber());
        dynamicObject.set("execresult", (Object)log.getExecResult().getNumber());
        dynamicObject.set("inspection_config", (Object)log.getInspectionConfigId());
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        if (log.getInspectionRepairResult() != null) {
            dynamicObject.set("repairresult", (Object)log.getInspectionRepairResult().getNumber());
        }
        if (log.getExecResult() == InspectionExecResult.SUCCESS) {
            return dynamicObject;
        }
        if (log instanceof BillInspectionLog) {
            this.convertBillInspectionLog(log, dynamicObject);
        } else if (log instanceof AmtConsistencyLog) {
            this.convertAmtConsistencyLog(log, dynamicObject);
        } else if (log instanceof BillNotExistLog) {
            this.convertBillNotExistLog(log, dynamicObject);
        }
        return dynamicObject;
    }

    private void convertBillInspectionLog(BaseLog log, DynamicObject dynamicObject) {
        BillInspectionLog billInspectionLog = (BillInspectionLog)log;
        DynamicObjectCollection resultDetailColl = dynamicObject.getDynamicObjectCollection("entry_result_detail");
        DynamicObjectCollection errorBizInfoColl = dynamicObject.getDynamicObjectCollection("entry_error_bizinfo");
        DynamicObjectCollection chainErrorColl = dynamicObject.getDynamicObjectCollection("entry_exec_chainerror");
        Deque<Long> idQ = CommonUtils.batchGenerateIds(billInspectionLog.getBillInspectionDetailList().size());
        for (BillInspectionDetail detail : billInspectionLog.getBillInspectionDetailList()) {
            DynamicObject detailDO = resultDetailColl.addNew();
            detailDO.set("id", (Object)idQ.poll());
            detailDO.set("e_detail_inspecttarget", (Object)detail.getInspectTarget().getCode());
            detailDO.set("e_detail_bizobj", (Object)detail.getBizBill());
            detailDO.set("e_detail_inspectrange", (Object)detail.getInspectRange());
            detailDO.set("e_detail_inspectresult", (Object)detail.getExecResult().getNumber());
            List<BillInspectionDetail.BillObject> errorBizBillList = detail.getErrorBizBillList();
            this.convertErrorBizInfoColl(errorBizBillList, errorBizInfoColl, detailDO);
            List<BillInspectionDetail.BillObject> errorExecRecordList = detail.getErrorExecRecordList();
            this.convertChainErrorColl(errorExecRecordList, chainErrorColl, detailDO);
            detailDO.set("e_detail_repairmethod", (Object)detail.getRepairMethod());
            detailDO.set("e_detail_repairreuslt", (Object)CommonUtils.getEnumNumberOrDefault(detail.getRepairResult(), ""));
            detailDO.set("e_detail_matchrule", (Object)detail.getMatchRuleId());
        }
    }

    private void convertErrorBizInfoColl(List<BillInspectionDetail.BillObject> errorBizBillList, DynamicObjectCollection errorBizInfoColl, DynamicObject detailDO) {
        if (CollectionUtils.isNotEmpty(errorBizBillList)) {
            StringBuilder displayNumberSb = new StringBuilder();
            for (BillInspectionDetail.BillObject billObject : errorBizBillList) {
                DynamicObject errorBizInfoDO = errorBizInfoColl.addNew();
                errorBizInfoDO.set("a_resultentryid", (Object)detailDO.getLong("id"));
                errorBizInfoDO.set("a_bizbillid", (Object)billObject.getId());
                errorBizInfoDO.set("a_errorinfo", (Object)billObject.getInspectErrorType().getNumber());
                errorBizInfoDO.set("a_bizbillnumber", (Object)billObject.getNumber());
                errorBizInfoDO.set("a_repairresult", (Object)InspectionRepairResult.PENDING.getNumber());
                if (displayNumberSb.length() + billObject.getNumber().length() >= 1023) continue;
                displayNumberSb.append(billObject.getNumber());
                displayNumberSb.append(",");
            }
            if (displayNumberSb.length() > 0) {
                displayNumberSb.deleteCharAt(displayNumberSb.length() - 1);
            }
            detailDO.set("e_detail_errorbizinfo", (Object)displayNumberSb.toString());
        }
    }

    private void convertChainErrorColl(List<BillInspectionDetail.BillObject> errorExecRecordList, DynamicObjectCollection chainErrorColl, DynamicObject detailDO) {
        if (CollectionUtils.isNotEmpty(errorExecRecordList)) {
            StringBuilder displayNumberSb = new StringBuilder();
            for (BillInspectionDetail.BillObject billObject : errorExecRecordList) {
                DynamicObject errorBizInfoDO = chainErrorColl.addNew();
                errorBizInfoDO.set("b_resultentryid", (Object)detailDO.getLong("id"));
                errorBizInfoDO.set("b_execrecordid", (Object)billObject.getId());
                errorBizInfoDO.set("b_errorinfo", (Object)billObject.getInspectErrorType().getNumber());
                errorBizInfoDO.set("b_execrecordnumber", (Object)billObject.getNumber());
                errorBizInfoDO.set("b_repairresult", (Object)InspectionRepairResult.PENDING.getNumber());
                if (displayNumberSb.length() + billObject.getNumber().length() >= 1023) continue;
                displayNumberSb.append(billObject.getNumber());
                displayNumberSb.append(",");
            }
            if (displayNumberSb.length() > 0) {
                displayNumberSb.deleteCharAt(displayNumberSb.length() - 1);
            }
            detailDO.set("e_detail_errorexecrecord", (Object)displayNumberSb.toString());
        }
    }

    private void convertBillNotExistLog(BaseLog log, DynamicObject dynamicObject) {
        BillNotExistLog billNotExistLog = (BillNotExistLog)log;
        if (CollectionUtils.isEmpty(billNotExistLog.getExecRecordErrorInfoList())) {
            return;
        }
        DynamicObjectCollection execRecordColl = dynamicObject.getDynamicObjectCollection("entry_exec_record");
        for (BillNotExistInfo billNotExistInfo : billNotExistLog.getExecRecordErrorInfoList()) {
            DynamicObject execRecordDO = execRecordColl.addNew();
            execRecordDO.set("e_exec_record", (Object)billNotExistInfo.getExecRecordId());
            execRecordDO.set("e_exec_repairresult", (Object)billNotExistInfo.getRepairResult().getNumber());
        }
    }

    private void convertAmtConsistencyLog(BaseLog log, DynamicObject dynamicObject) {
        AmtConsistencyLog amtConsistencyLog = (AmtConsistencyLog)log;
        DynamicObjectCollection consistencyErrorColl = dynamicObject.getDynamicObjectCollection("entry_consistency_error");
        for (AmtExceptionInfo amtExceptionInfo : amtConsistencyLog.getAmtExceptionInfoList()) {
            DynamicObject amtExceptionDO = consistencyErrorColl.addNew();
            amtExceptionDO.set("e_cons_reportid", (Object)amtExceptionInfo.getReportId());
            amtExceptionDO.set("e_cons_org", (Object)amtExceptionInfo.getOrgId());
            amtExceptionDO.set("e_cons_period", (Object)amtExceptionInfo.getPeriodId());
            amtExceptionDO.set("e_cons_errordim", (Object)amtExceptionInfo.getDimensionCombo());
            amtExceptionDO.set("e_cons_repairresult", (Object)amtExceptionInfo.getRepairResult().getNumber());
            amtExceptionDO.set("e_cons_errorinfo", (Object)amtExceptionInfo.getErrorInfo());
            amtExceptionDO.set("e_cons_reportdataid", (Object)amtExceptionInfo.getReportDataId());
        }
    }
}

