/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.inspection;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.InspectionExecResult;
import kd.tmc.fpm.business.domain.enums.InspectionExecStatus;
import kd.tmc.fpm.business.domain.enums.InspectionScope;
import kd.tmc.fpm.business.domain.enums.InspectionType;
import kd.tmc.fpm.business.domain.model.inspection.log.BaseLog;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;

public class InspectionLogPOConverter
implements IConverter<BaseLog, DynamicObject> {
    @Override
    public BaseLog convert(DynamicObject dynamicObject) {
        DynamicObjectCollection orgScopeIds;
        BaseLog baseLog = new BaseLog();
        baseLog.setId((Long)dynamicObject.getPkValue());
        baseLog.setBillNo(dynamicObject.getString("billno"));
        DynamicObject bodySys = dynamicObject.getDynamicObject("bodysys");
        if (Objects.nonNull(bodySys)) {
            baseLog.setSystemId((Long)bodySys.getPkValue());
        }
        baseLog.setInspectionType(ITypeEnum.getByNumber(dynamicObject.getString("inspectiontype"), InspectionType.class));
        DynamicObject config = dynamicObject.getDynamicObject("inspection_config");
        if (Objects.nonNull(config)) {
            baseLog.setInspectionConfigId((Long)config.getPkValue());
        }
        baseLog.setInspectionScope(ITypeEnum.getByNumber(dynamicObject.getString("inspectionscope"), InspectionScope.class));
        baseLog.setInspectionStartDate(dynamicObject.getDate("startdate"));
        baseLog.setInspectionEndDate(dynamicObject.getDate("enddate"));
        DynamicObjectCollection periodScopeIds = dynamicObject.getDynamicObjectCollection("exec_period_scope");
        if (!CollectionUtils.isEmpty((Collection)periodScopeIds)) {
            List<Long> inspectionPeriodScope = periodScopeIds.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
            baseLog.setInspectionPeriodScope(inspectionPeriodScope);
        }
        if (!CollectionUtils.isEmpty((Collection)(orgScopeIds = dynamicObject.getDynamicObjectCollection("exec_org_scope")))) {
            List<Long> orgScopeIdList = orgScopeIds.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
            baseLog.setInspectionOrgScope(orgScopeIdList);
        }
        baseLog.setExecDate(dynamicObject.getDate("execdate"));
        baseLog.setFinishDate(dynamicObject.getDate("finishdate"));
        baseLog.setExecStatus(ITypeEnum.getByNumber(dynamicObject.getString("execstatus"), InspectionExecStatus.class));
        baseLog.setExecResult(ITypeEnum.getByNumber(dynamicObject.getString("execresult"), InspectionExecResult.class));
        return baseLog;
    }
}

