/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.converter.member;

import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.PeriodDirection;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.mvc.converter.member.AbstractMemberConverter;

public class AccountMemberConverter
extends AbstractMemberConverter {
    @Override
    public DimMember convertToMember(DynamicObject memberPO) {
        AccountMember member = (AccountMember)super.convertToMember(memberPO);
        member.setFlowType(FlowType.getByNumber(memberPO.getString("flow")));
        DynamicObject linkSubjectObj = memberPO.getDynamicObject("linksubject");
        if (EmptyUtil.isNoEmpty((DynamicObject)linkSubjectObj)) {
            AccountMember linkSubject = (AccountMember)super.convertToMember(linkSubjectObj);
            linkSubject.setPlanAmtAuto(linkSubjectObj.getBoolean("planamtauto"));
            member.setAssociateAccount(linkSubject);
        }
        member.setInputType(ReportInputType.getByNumber(memberPO.getString("ways")));
        member.setFormula(memberPO.getString("formulavalue_tag"));
        member.setPeriodDirection(ITypeEnum.getByNumber(memberPO.getString("beginorendmark"), PeriodDirection.class));
        member.setPlanAmtAuto(memberPO.getBoolean("planamtauto"));
        return member;
    }

    @Override
    protected DimMember createMember() {
        return new AccountMember();
    }
}

