/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.domain.enums.ControlRequestStatus;
import kd.tmc.fpm.business.domain.model.control.ControlRequestUpdateInfo;
import kd.tmc.fpm.business.mvc.repository.IControlRequestUpdateInfoRepository;
import kd.tmc.fpm.business.mvc.repository.impl.BaseRepository;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class ControlRequestUpdateInfoRepository
extends BaseRepository<ControlRequestUpdateInfo>
implements IControlRequestUpdateInfoRepository {
    private IDataSaveService dataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);

    @Override
    public List<ControlRequestUpdateInfo> getControlRequestUpdateInfoLessThanRequestId(Long requestId, Long concurrentMaxRequestId) {
        QFilter qFilter = Objects.equals(requestId, concurrentMaxRequestId) ? new QFilter("requestid", "=", (Object)requestId) : new QFilter("requestid", "<=", (Object)requestId).and(new QFilter("requestid", ">=", (Object)concurrentMaxRequestId));
        logger.info("getControlRequestUpdateInfoLessThanRequestId\u53c2\u6570\uff1a requestI:{},concurrentMaxRequestId:{}\uff0c\u7ec4\u88c5\u540e\u7684\u67e5\u8be2\u6761\u4ef6\uff1a{}", new Object[]{requestId, concurrentMaxRequestId, qFilter});
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_controlupdateinfo", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
        return this.load(ids.stream().map(Long.class::cast).collect(Collectors.toList()), "fpm_controlupdateinfo", ControlRequestUpdateInfo.class);
    }

    @Override
    public Long getCurrentInitMinRequestId() {
        Date currentDate = DateUtils.getCurrentDate();
        Date threeDaysAgo = DateUtils.getLastDay((Date)currentDate, (int)3);
        Long minInitRequestId = (Long)DB.query((DBRoute)DBRouteConst.TMC, (String)"select min(frequestid) from t_fpm_controlupdateinfo where fcreatetime >= ? and fcontrolstatus='A'", (Object[])new Object[]{threeDaysAgo}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getLong(1);
            }
            return 0L;
        });
        logger.info("\u67e5\u8be2\u5230\u6700\u5c0f\u521d\u59cb\u72b6\u6001requestId\uff1a{}", (Object)minInitRequestId);
        if (EmptyUtil.isNoEmpty((Long)minInitRequestId)) {
            return minInitRequestId;
        }
        Long maxRequestId = (Long)DB.query((DBRoute)DBRouteConst.TMC, (String)"select max(frequestid) from t_fpm_controlupdateinfo", resultSet -> {
            if (resultSet.next()) {
                return resultSet.getLong(1);
            }
            return 0L;
        });
        logger.info("\u67e5\u8be2\u5230\u5f53\u524d\u6700\u5927\u8bf7\u6c42id\uff1a{}", (Object)maxRequestId);
        maxRequestId = maxRequestId + 1L;
        logger.info("\u5f53\u524d\u6ca1\u6709\u521d\u59cb\u5316\u72b6\u6001\u8bb0\u5f55\uff0c\u8fd4\u56de\u6700\u5927\u8bf7\u6c42id + 1:{}", (Object)maxRequestId);
        return maxRequestId;
    }

    @Override
    public void deleteById(List<Long> ids) {
        this.checkAndProcess(ids, () -> {
            this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_controlupdateinfo set fcontrolstatus = 'D' where fid=?", ids, (k, o) -> o.add(k));
            return null;
        });
    }

    @Override
    public List<ControlRequestUpdateInfo> queryInitControlRequestUpdateInfoListBeforeThreeDays() {
        Date currentDate = DateUtils.getCurrentDate();
        Date lastDay = DateUtils.getLastDay((Date)currentDate, (int)2);
        Date tenDaysAgo = DateUtils.getLastDay((Date)currentDate, (int)10);
        QFilter qFilter = new QFilter("createtime", "<=", (Object)lastDay).and(new QFilter("createtime", ">=", (Object)tenDaysAgo)).and("controlstatus", "=", (Object)ControlRequestStatus.INIT.getNumber());
        String selectFields = String.join((CharSequence)",", "id", "requestid");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_controlupdateinfo", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return Collections.emptyList();
        }
        return dynamicObjectCollection.stream().map(dy -> {
            ControlRequestUpdateInfo controlRequestUpdateInfo = new ControlRequestUpdateInfo();
            controlRequestUpdateInfo.setId(dy.getLong("id"));
            controlRequestUpdateInfo.setRequestId(dy.getLong("requestid"));
            return controlRequestUpdateInfo;
        }).collect(Collectors.toList());
    }
}

