/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.execbiasanalys.ExecBiasAnalys;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.IExecBiasAnalysRepository;

public class ExecBiasAnalysRepository
implements IExecBiasAnalysRepository {
    private static Log logger = LogFactory.getLog(ExecBiasAnalysRepository.class);

    @Override
    public ExecBiasAnalys load(Long id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fpm_execbiasanalys");
        return ConverterUtils.convert(ExecBiasAnalys.class, dynamicObject);
    }

    @Override
    public void save(Long id, List<ReportData> referenceReportDataList) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fpm_execbiasanalys");
        DynamicObjectCollection auxentrys = dynamicObject.getDynamicObjectCollection("entryentity");
        for (ReportData reportData : referenceReportDataList) {
            DynamicObject auxentry;
            Optional<DynamicObject> auxentryOptional = auxentrys.stream().filter(c -> reportData.getId().equals(c.getLong("reportdataid")) && reportData.getReportPeriodId().equals(c.getLong("aux_bdtype"))).findFirst();
            if (auxentryOptional.isPresent()) {
                auxentry = auxentryOptional.get();
                auxentry.set("aux_content", (Object)reportData.getRemark());
                continue;
            }
            if (EmptyUtil.isEmpty((String)reportData.getRemark())) continue;
            auxentry = auxentrys.addNew();
            auxentry.set("reportdataid", (Object)reportData.getId());
            auxentry.set("aux_bdtype", (Object)reportData.getReportPeriodId());
            auxentry.set("aux_content", (Object)reportData.getRemark());
        }
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }
}

