/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.report.DynamicObjectData;
import kd.tmc.fpm.business.domain.model.report.PlanChangeRecord;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReportAuxEntry;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportChangeConvertParam;
import kd.tmc.fpm.business.domain.model.template.AuxiliaryField;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.IPlanChangeRepository;
import kd.tmc.fpm.business.mvc.repository.dto.PlanChangeReportQDTO;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.mvc.repository.impl.DetailPlanFieldsRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.utils.DataSetUtil;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;
import kd.tmc.fpm.common.property.ReportPlanAdjustProp;
import org.apache.commons.collections.CollectionUtils;

public class PlanChangeRepository
implements IPlanChangeRepository {
    private ReportRepository reportRepository = new ReportRepository();

    @Override
    public PlanChangeRecord load(Long id) {
        DynamicObject reportAdjust = QueryServiceHelper.queryOne((String)"fpm_reportplan_adjust", (String)ReportPlanAdjustProp.HEAD_SELECT_FIELDS, (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (EmptyUtil.isEmpty((DynamicObject)reportAdjust)) {
            return null;
        }
        ReportChangeConvertParam.ReportChangeQueryParamBuilder builder = ReportChangeConvertParam.builder();
        List<Long> reportIdList = Arrays.stream(reportAdjust.getString("originalreportids").split(",")).map(Long::valueOf).collect(Collectors.toList());
        List<Report> reportList = this.getReportList(reportIdList.toArray(new Long[0]));
        Map<Long, List<Dimension>> detailDimensionMap = this.getDetailDimensionMap(reportList);
        Long recordId = reportAdjust.getLong("id");
        long systemId = reportAdjust.getLong("bodysys");
        builder.adjustAmtInfoDataSet(this.getAdjustAmtInfoDataSet(recordId)).mainJsonDetailDataSet(this.getMainJsonDetailDataSet(recordId, reportIdList, systemId));
        builder.reports(reportList).detailDimensionMap(detailDimensionMap);
        DynamicObjectData dynamicObjectData = new DynamicObjectData(reportAdjust, builder.build(), true);
        this.fillAuxInfo(recordId, dynamicObjectData);
        return ConverterUtils.convert(PlanChangeRecord.class, dynamicObjectData);
    }

    @Override
    public List<PlanChangeRecord> load(Collection<Long> ids) {
        return this.load(ids, false);
    }

    @Override
    public List<PlanChangeRecord> load(Collection<Long> ids, boolean onlyQueryMain) {
        return this.load(ids, onlyQueryMain, true);
    }

    @Override
    public List<PlanChangeRecord> load(Collection<Long> ids, boolean onlyQueryMain, boolean needConvertEntry) {
        return this.load(ids, onlyQueryMain, needConvertEntry, false);
    }

    @Override
    public List<PlanChangeRecord> load(Collection<Long> ids, boolean onlyQueryMain, boolean needConvertEntry, boolean needFullDim) {
        DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((String)"fpm_reportplan_adjust", (String)ReportPlanAdjustProp.HEAD_SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        return Arrays.stream(dynamicObjects).map(dynamicObject -> this.getDynamicObjectData((DynamicObject)dynamicObject, needConvertEntry, onlyQueryMain ? Long.valueOf(dynamicObject.getLong("mainreportid")) : null)).map(dynamicObjectData -> ConverterUtils.convertWithArgs(PlanChangeRecord.class, dynamicObjectData, needFullDim)).collect(Collectors.toList());
    }

    @Override
    public List<PlanChangeRecord> load(PlanChangeReportQDTO qDto) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        if (qDto.getBodySysId() != null) {
            qFilterList.add(new QFilter("bodysys", "=", (Object)qDto.getBodySysId()));
        }
        if (qDto.getReportPeriodId() != null) {
            qFilterList.add(new QFilter("reportperiod", "=", (Object)qDto.getReportPeriodId()));
        }
        if (!CollectionUtils.isEmpty(qDto.getReportPeriodIdList())) {
            qFilterList.add(new QFilter("reportperiod", "in", qDto.getReportPeriodIdList()));
        }
        if (qDto.getReportOrgId() != null) {
            qFilterList.add(new QFilter("reportorg", "=", (Object)qDto.getReportOrgId()));
        }
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_reportplan_adjust", (QFilter[])qFilterList.toArray(new QFilter[0]), null, (int)-1);
        return this.load(ids.stream().map(item -> (Long)item).collect(Collectors.toList()));
    }

    @Override
    public PlanChangeRecord load(Long id, Long reportId) {
        DynamicObjectCollection resultCollection = QueryServiceHelper.query((String)"fpm_reportplan_adjust", (String)ReportPlanAdjustProp.HEAD_SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (CollectionUtils.isEmpty((Collection)resultCollection)) {
            return null;
        }
        DynamicObject dynamicObject = (DynamicObject)resultCollection.get(0);
        long systemId = dynamicObject.getLong("bodysys");
        ReportChangeConvertParam.ReportChangeQueryParamBuilder builder = ReportChangeConvertParam.builder();
        List<Report> reportList = this.getReportList(reportId);
        Map<Long, List<Dimension>> detailDimensionMap = this.getDetailDimensionMap(reportList);
        Long recordId = dynamicObject.getLong("id");
        builder.adjustAmtInfoDataSet(this.getAdjustAmtInfoDataSet(recordId)).mainJsonDetailDataSet(this.getMainJsonDetailDataSet(recordId, Collections.singletonList(reportId), systemId));
        builder.reports(reportList).detailDimensionMap(detailDimensionMap);
        DynamicObjectData dynamicObjectData = new DynamicObjectData(dynamicObject, builder.build(), true);
        this.fillAuxInfo(recordId, dynamicObjectData);
        return ConverterUtils.convert(PlanChangeRecord.class, dynamicObjectData);
    }

    @Override
    public Long save(PlanChangeRecord changeRecord) {
        DynamicObject dynamicObject = ConverterUtils.convert(DynamicObject.class, changeRecord);
        OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_reportplan_adjust", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
        List successPkIds = operationResult.getSuccessPkIds();
        return CollectionUtils.isEmpty((Collection)successPkIds) ? 0L : (Long)successPkIds.get(0);
    }

    private List<Report> getReportList(Long ... reportIdArr) {
        HashSet<Long> reportIds = new HashSet<Long>(Arrays.asList(reportIdArr));
        ReportNeedPropDTO reportNeedPropDTO = new ReportNeedPropDTO();
        reportNeedPropDTO.setNeedTemplate(true);
        reportNeedPropDTO.setNeedReportPeriodType(true);
        reportNeedPropDTO.setNeedPeriodMember(true);
        reportNeedPropDTO.setNeedCompanyMember(true);
        return this.reportRepository.loadSimpleReport(reportIds, reportNeedPropDTO);
    }

    private DynamicObjectData getDynamicObjectData(DynamicObject dynamicObject, boolean needConvertEntry, Long ... reportIds) {
        ReportChangeConvertParam.ReportChangeQueryParamBuilder builder = ReportChangeConvertParam.builder();
        if (EmptyUtil.isEmpty((Object[])reportIds)) {
            List<Long> reportIdList = Arrays.stream(dynamicObject.getString("originalreportids").split(",")).map(Long::valueOf).collect(Collectors.toList());
            reportIds = reportIdList.toArray(new Long[0]);
        }
        List<Report> reportList = this.getReportList(reportIds);
        Map<Long, List<Dimension>> detailDimensionMap = this.getDetailDimensionMap(reportList);
        Long recordId = (Long)dynamicObject.getPkValue();
        long systemId = dynamicObject.getLong("bodysys.id");
        if (needConvertEntry) {
            builder.adjustAmtInfoDataSet(this.getAdjustAmtInfoDataSet(recordId)).mainJsonDetailDataSet(this.getMainJsonDetailDataSet(recordId, Arrays.asList(reportIds), systemId));
        }
        builder.reports(reportList).detailDimensionMap(detailDimensionMap);
        return new DynamicObjectData(dynamicObject, builder.build(), needConvertEntry, dynamicObject.getDynamicObjectCollection("auxentry"));
    }

    private Map<Long, List<Dimension>> getDetailDimensionMap(List<Report> reports) {
        Map<Long, List<Report>> systemReportListMap = reports.stream().collect(Collectors.groupingBy(Report::getSystemId));
        Map<Long, List<Dimension>> systemDetailFieldListMap = new DetailPlanFieldsRepository().getDetailDimensionGroupBySystemId(systemReportListMap.keySet());
        HashMap<Long, List<Dimension>> map = new HashMap<Long, List<Dimension>>(reports.size());
        for (Map.Entry<Long, List<Dimension>> entry : systemDetailFieldListMap.entrySet()) {
            Long systemId = entry.getKey();
            List reportList = systemReportListMap.getOrDefault(systemId, Collections.emptyList());
            for (Report report : reportList) {
                map.computeIfAbsent(report.getId(), key -> (List)entry.getValue());
            }
        }
        return map;
    }

    private DataSet getMainJsonDetailDataSet(Long recordId, List<Long> reportIds, Long systemId) {
        QFilter qFilter = new QFilter("id", "=", (Object)recordId).and(new QFilter(String.join((CharSequence)".", "main_entryentity", "main_originalreportid"), "in", reportIds));
        HashSet<String> fieldSet = new HashSet<String>(ReportPlanAdjustProp.SELECT_MAIN_ENTRY_FIELDS);
        fieldSet.add("id");
        DataSet mainEntryDataSet = QueryServiceHelper.queryDataSet((String)"reportAdjust.queryMainData", (String)"fpm_reportplan_adjust", (String)fieldSet.stream().map(field -> String.join((CharSequence)".", "main_entryentity", field)).collect(Collectors.joining(",")), (QFilter[])new QFilter[]{qFilter}, (String)"");
        String mainIdProp = String.join((CharSequence)".", "main_entryentity", "id");
        DataSet mainEntryIdDS = mainEntryDataSet.copy().select(mainIdProp);
        HashSet<Long> mainEntryIds = new HashSet<Long>(128);
        while (mainEntryIdDS.hasNext()) {
            mainEntryIds.add(mainEntryIdDS.next().getLong(mainIdProp));
        }
        String mainDataEntryId = String.join((CharSequence)".", "detail_entryentity", "detail_maindimdataid");
        Map<String, String> adjustDetailDimensionMappingMap = DimensionMappingHelper.getAdjustDetailMappingWithEntry(systemId);
        String detailSelectedFields = String.join((CharSequence)",", adjustDetailDimensionMappingMap.values());
        String selectedFields = String.join((CharSequence)",", detailSelectedFields, String.join((CharSequence)".", "detail_entryentity", "detail_maindimdataid"), String.join((CharSequence)".", "detail_entryentity", "detail_remark"));
        DataSet detailEntryDataSet = QueryServiceHelper.queryDataSet((String)"reportAdjust.queryDetailData", (String)"fpm_reportplan_adjust", (String)selectedFields, (QFilter[])new QFilter[]{new QFilter(mainDataEntryId, "in", mainEntryIds)}, (String)"");
        DataSet dataSet = mainEntryDataSet.join(detailEntryDataSet).on(mainIdProp, mainDataEntryId).select(DataSetUtil.getSelectFields(mainEntryDataSet, new String[0]).split(","), DataSetUtil.getSelectFields(detailEntryDataSet, new String[0]).split(",")).finish();
        DataSetUtil.closeDataSet(mainEntryDataSet, detailEntryDataSet);
        return dataSet;
    }

    private DataSet getAdjustAmtInfoDataSet(Long recordId) {
        QFilter qFilter = new QFilter("id", "=", (Object)recordId);
        DataSet adjustAmtInfoDataSet = QueryServiceHelper.queryDataSet((String)"reportAdjust.queryAdjustAmtInfoData", (String)"fpm_reportplan_adjust", (String)("id," + ReportPlanAdjustProp.SELECT_ADJUST_ENTRY_FIELDS.stream().map(field -> String.join((CharSequence)".", "adjust_entryentity", field)).collect(Collectors.joining(","))), (QFilter[])new QFilter[]{qFilter}, (String)"");
        return adjustAmtInfoDataSet;
    }

    private void fillAuxInfo(Long recordId, DynamicObjectData dynamicObjectData) {
        QFilter qFilter = new QFilter("id", "=", (Object)recordId);
        try (DataSet adjustAuxDataSet = QueryServiceHelper.queryDataSet((String)"reportAdjust.queryAdjustAux", (String)"fpm_reportplan_adjust", (String)("id," + ReportPlanAdjustProp.SELECT_ADJUST_AUX_ENTRY_FIELDS.stream().map(field -> String.join((CharSequence)".", "auxentry", field)).collect(Collectors.joining(","))), (QFilter[])new QFilter[]{qFilter}, (String)"");){
            ArrayList<PlanChangeReportAuxEntry> auxEntryList = new ArrayList<PlanChangeReportAuxEntry>(10);
            while (adjustAuxDataSet.hasNext()) {
                Row next = adjustAuxDataSet.next();
                Long reportDataId = next.getLong(String.join((CharSequence)".", "auxentry", "aux_reportdataid"));
                Long auxBaseDataId = next.getLong(String.join((CharSequence)".", "auxentry", "aux_bdtype"));
                String content = next.getString(String.join((CharSequence)".", "auxentry", "aux_content"));
                PlanChangeReportAuxEntry auxEntry = new PlanChangeReportAuxEntry();
                auxEntry.setReportDataId(reportDataId);
                AuxiliaryField auxiliaryField = new AuxiliaryField();
                auxiliaryField.setId(auxBaseDataId);
                auxEntry.setAuxiliaryField(auxiliaryField);
                auxEntry.setContent(content);
                auxEntryList.add(auxEntry);
            }
            dynamicObjectData.setReportAuxEntry(auxEntryList);
        }
    }
}

