/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.helper.ReportBatchDataMapHelper;
import kd.tmc.fpm.business.mvc.converter.ReportPoNewConverter;
import kd.tmc.fpm.business.mvc.repository.dto.ReportBatchDataMapDTO;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.utils.DataSetUtil;
import kd.tmc.fpm.common.property.ReportProp;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;

public class ReportNewRepository {
    public static List<Report> loadSimpleReport(Collection<Long> reportIds, ReportNeedPropDTO needProp) {
        ArrayList<Report> result = new ArrayList<Report>(reportIds.size());
        DataSet dsReport = QueryServiceHelper.queryDataSet((String)"loadSimpleReportData", (String)"fpm_report", (String)ReportProp.getBaseReportHeadProp(), (QFilter[])new QFilter("id", "in", reportIds).toArray(), null);
        HashMap<Long, ReportTemplate> reportTemplateBakMap = new HashMap<Long, ReportTemplate>(8);
        needProp.setNeedTemplate(true);
        Map<Long, ReportTemplate> templateBakMap = ReportNewRepository.getTemplateBackMap(dsReport, needProp, reportTemplateBakMap);
        ReportBatchDataMapDTO batchDataMap = ReportBatchDataMapHelper.initReportNeedPropDTO(dsReport, needProp, reportTemplateBakMap, Boolean.TRUE);
        for (Row row : dsReport) {
            Long templateBackId = row.getLong("templatebak.id");
            ReportTemplate template = ReportNewRepository.templateCopyIfNeed(templateBakMap.get(templateBackId), reportIds.size());
            Report report = ReportPoNewConverter.convertToSimpleReport(row, template, needProp, batchDataMap);
            result.add(report);
        }
        return result;
    }

    public static List<Report> loadReport(Collection<Long> reportIds) {
        return ReportNewRepository.loadReport(reportIds, ReportNeedPropDTO.buildAll());
    }

    public static List<Report> loadReport(Collection<Long> reportIds, ReportNeedPropDTO needProp) {
        ArrayList<Report> result = new ArrayList<Report>(reportIds.size());
        DataSet dsReport = QueryServiceHelper.queryDataSet((String)"loadReportData", (String)"fpm_report", (String)ReportProp.getBaseReportHeadProp(), (QFilter[])new QFilter("id", "in", reportIds).toArray(), null);
        HashMap<Long, ReportTemplate> reportTemplateBakMap = new HashMap<Long, ReportTemplate>(8);
        Map<Long, ReportTemplate> templateBakMap = ReportNewRepository.getTemplateBackMap(dsReport, needProp, reportTemplateBakMap);
        ReportBatchDataMapDTO batchDataMap = ReportBatchDataMapHelper.initReportNeedPropDTO(dsReport, needProp, reportTemplateBakMap, Boolean.FALSE);
        for (Row row : dsReport) {
            Long templateBackId = row.getLong("templatebak.id");
            ReportTemplate template = ReportNewRepository.templateCopyIfNeed(templateBakMap.get(templateBackId), reportIds.size());
            Report report = ReportPoNewConverter.convertToReport(row, template, needProp, batchDataMap);
            result.add(report);
        }
        return result;
    }

    public static List<Report> loadReportWithAllDimension(Collection<Long> reportIds) {
        ReportNeedPropDTO needProp = ReportNeedPropDTO.buildAll();
        ArrayList<Report> result = new ArrayList<Report>(reportIds.size());
        DataSet dsReport = QueryServiceHelper.queryDataSet((String)"loadReportWithAllDimension", (String)"fpm_report", (String)ReportProp.getBaseReportHeadProp(), (QFilter[])new QFilter("id", "in", reportIds).toArray(), null);
        HashMap<Long, ReportTemplate> reportTemplateBakMap = new HashMap<Long, ReportTemplate>(8);
        Map<Long, ReportTemplate> templateBakMap = ReportNewRepository.getTemplateBackMap(dsReport, needProp, reportTemplateBakMap);
        ReportBatchDataMapDTO batchDataMap = ReportBatchDataMapHelper.initReportNeedPropDTO(dsReport, needProp, reportTemplateBakMap, Boolean.FALSE);
        for (Row row : dsReport) {
            Long templateBackId = row.getLong("templatebak.id");
            ReportTemplate template = ReportNewRepository.templateCopyIfNeed(templateBakMap.get(templateBackId), reportIds.size());
            TemplateUseType templateUse = template.getTemplateUse();
            template.setTemplateUse(TemplateUseType.SUMMARY);
            Report report = ReportPoNewConverter.convertToReport(row, template, needProp, batchDataMap);
            template.setTemplateUse(templateUse);
            result.add(report);
        }
        return result;
    }

    public static Report loadReportWithAllDimension(long reportId) {
        List<Report> reports = ReportNewRepository.loadReportWithAllDimension(Collections.singletonList(reportId));
        return EmptyUtil.isNoEmpty(reports) ? reports.get(0) : new Report();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Long, ReportTemplate> getTemplateBackMap(DataSet dsReport, ReportNeedPropDTO needProp, Map<Long, ReportTemplate> reportTemplateBakMap) {
        if (needProp.isNeedTemplate()) {
            Map<Long, ReportTemplate> map;
            DataSet dataSet = dsReport.copy();
            try {
                HashMap<Long, Set> reportTemplateIdMap = new HashMap<Long, Set>(8);
                for (Row row : dataSet) {
                    Set reportIds = reportTemplateIdMap.computeIfAbsent(row.getLong("templatebak.id"), d -> new HashSet(8));
                    reportIds.add(row.getLong("id"));
                }
                Map<Long, ReportTemplate> templateMap = new TemplateRepository().loadTemplateBakMap(reportTemplateIdMap.keySet());
                for (Map.Entry<Long, ReportTemplate> entry : templateMap.entrySet()) {
                    Set reportIds = (Set)reportTemplateIdMap.get(entry.getKey());
                    reportIds.forEach(d -> {
                        ReportTemplate cfr_ignored_0 = (ReportTemplate)reportTemplateBakMap.put((Long)d, (ReportTemplate)entry.getValue());
                    });
                }
                map = templateMap;
            }
            catch (Throwable throwable) {
                DataSetUtil.closeDataSet(dataSet);
                throw throwable;
            }
            DataSetUtil.closeDataSet(dataSet);
            return map;
        }
        return Collections.emptyMap();
    }

    private static ReportTemplate templateCopyIfNeed(ReportTemplate template, int size) {
        if (size <= 1) {
            return template;
        }
        return (ReportTemplate)FpmSerializeUtil.deserializeJson((String)FpmSerializeUtil.serializeJson((Object)template), ReportTemplate.class);
    }
}

