/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import kd.tmc.fpm.business.cache.FpmPageCacheService;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.repository.IReportPlanRepositoryV2;
import kd.tmc.fpm.business.spread.formula.FormulaManagerFactory;
import kd.tmc.fpm.business.spread.formula.IFormulaManagerV2;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;

public class ReportPlanRepositoryV2
implements IReportPlanRepositoryV2 {
    private Long reportId;
    private String pageId;
    private transient IFpmPageCacheService cacheService;

    public ReportPlanRepositoryV2() {
    }

    public ReportPlanRepositoryV2(Long reportId, IFpmPageCacheService cacheService) {
        this.reportId = reportId;
        this.cacheService = cacheService;
        this.pageId = cacheService.getPageId();
    }

    @Override
    public IFormulaManagerV2 getFormulaManager() {
        String formulaManagerRedisKey = this.getRedisKey("formula.manager");
        String formulaManagerJson = this.getCacheService().get(formulaManagerRedisKey);
        IFormulaManagerV2 iFormulaManager = FormulaManagerFactory.fromSerializeStringV2(formulaManagerJson);
        return iFormulaManager;
    }

    @Override
    public ReportTemplate getReportTemplate() {
        String reportTempRedisKey = this.getRedisKey("report.template");
        String reportTempJson = this.getCacheService().get(reportTempRedisKey);
        return (ReportTemplate)FpmSerializeUtil.deserialize((String)reportTempJson, ReportTemplate.class);
    }

    @Override
    public FundPlanSystem getSystem() {
        String systemRedisKey = this.getRedisKey("fundplansystem");
        String fundSystemJson = this.getCacheService().get(systemRedisKey);
        return (FundPlanSystem)FpmSerializeUtil.deserialize((String)fundSystemJson, FundPlanSystem.class);
    }

    @Override
    public void saveFormulaManger(IFormulaManagerV2 manager) {
        String formulaManagerRedisKey = this.getRedisKey("formula.manager");
        this.getCacheService().remove(formulaManagerRedisKey);
        this.setRedisCache(formulaManagerRedisKey, manager.serialize(), "updateFormulaManger");
    }

    @Override
    public void saveReportTemplate(ReportTemplate template) {
        String reportTempRedisKey = this.getRedisKey("report.template");
        this.getCacheService().remove(reportTempRedisKey);
        this.setRedisCache(reportTempRedisKey, FpmSerializeUtil.serialize((Object)template), "saveReportTemplate");
    }

    @Override
    public void saveSystem(FundPlanSystem system) {
        String sysRedisKey = this.getRedisKey("fundplansystem");
        this.getCacheService().remove(sysRedisKey);
        this.setRedisCache(sysRedisKey, FpmSerializeUtil.serialize((Object)system), "saveSystem");
    }

    @Override
    public IReportPlanRepositoryV2 deserialize(String jsonStr) {
        return (IReportPlanRepositoryV2)FpmSerializeUtil.deserialize((String)jsonStr, ReportPlanRepositoryV2.class);
    }

    @Override
    public void setCacheService(IFpmPageCacheService cacheService) {
        this.cacheService = cacheService;
    }

    public IFpmPageCacheService getCacheService() {
        this.cacheService = this.cacheService == null ? new FpmPageCacheService(this.pageId) : this.cacheService;
        return this.cacheService;
    }

    private String getRedisKey(String signMark) {
        String redisKey = String.format("%s.%s.cache", this.pageId, signMark);
        return redisKey;
    }

    private void setRedisCache(String redisKey, String json, String opName) {
        this.getCacheService().put(redisKey, json);
    }

    public Long getReportId() {
        return this.reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }
}

