/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.fpm.business.domain.enums.AuxiliaryFieldsUseType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportOpType;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportPrepare;
import kd.tmc.fpm.business.domain.model.report.ReportUniqueCondition;
import kd.tmc.fpm.business.domain.model.report.VerifyReport;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.converter.ReportPoConverter;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.mvc.repository.dto.ReportQDTO;
import kd.tmc.fpm.business.mvc.repository.dto.ReportUpdateDTO;
import kd.tmc.fpm.business.mvc.repository.impl.ReportNewRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.utils.DataSetUtil;
import kd.tmc.fpm.common.enums.ReportPlanChangeStatusEnum;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class ReportRepository
implements IReportRepository {
    private ITemplateRepository templateRep = new TemplateRepository();

    @Override
    public Map<ReportUniqueCondition, Boolean> loadReportGenInfo(List<ReportUniqueCondition> conditionList) {
        LinkedHashMap<ReportUniqueCondition, Boolean> result = new LinkedHashMap<ReportUniqueCondition, Boolean>();
        DynamicObjectCollection findBdDataList = new DynamicObjectCollection();
        String selectFields = String.join((CharSequence)",", "id", "reportorg.id", "template.id", "reportperiod.id", "parenttemplate.id");
        List splitList = ListUtils.splitList(conditionList, (long)1000L);
        for (List conditions : splitList) {
            HashSet orgIdList = new HashSet(16);
            HashSet tplIdList = new HashSet(16);
            HashSet periodIdList = new HashSet(16);
            conditions.forEach(item -> {
                orgIdList.add(item.getReportOrgId());
                tplIdList.add(item.getTemplateId());
                periodIdList.add(item.getReportPeriodId());
            });
            QFilter qFilter = new QFilter("reportorg.id", "in", orgIdList).and("template.id", "in", tplIdList).and("reportperiod.id", "in", periodIdList);
            DynamicObjectCollection findBdDataArr = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])qFilter.toArray());
            findBdDataList.addAll((Collection)findBdDataArr);
        }
        Map<String, List<DynamicObject>> groupDataMap = findBdDataList.stream().collect(Collectors.groupingBy(item -> {
            String key = String.join((CharSequence)"#", item.getString("reportorg.id"), item.getString("reportperiod.id"), item.getString("template.id"));
            if (item.getLong("parenttemplate.id") > 0L) {
                key = String.join((CharSequence)"#", key, item.getString("parenttemplate.id"));
            }
            return key;
        }));
        for (ReportUniqueCondition reportUniqueCondition : conditionList) {
            String key = String.join((CharSequence)"#", reportUniqueCondition.getReportOrgId().toString(), reportUniqueCondition.getReportPeriodId().toString());
            key = reportUniqueCondition.getParentTemplateId() != null ? String.join((CharSequence)"#", key, reportUniqueCondition.getParentTemplateId().toString()) : String.join((CharSequence)"#", key, reportUniqueCondition.getTemplateId().toString());
            result.put(reportUniqueCondition, groupDataMap.get(key) != null);
        }
        return result;
    }

    @Override
    public ReportPrepare loadReportPrepare(Long prepareId) {
        DynamicObject reportPrepare = TmcDataServiceHelper.loadSingle((Object)prepareId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_reportpreparation"));
        return ReportPoConverter.convertToReportPrepare(reportPrepare);
    }

    @Override
    public Report loadReport(long reportId) {
        List<Report> reports = ReportNewRepository.loadReport(Collections.singleton(reportId));
        return EmptyUtil.isNoEmpty(reports) ? reports.get(0) : new Report();
    }

    @Override
    public Report loadReportWithAllDimension(long reportId) {
        List<Report> reports = ReportNewRepository.loadReportWithAllDimension(Collections.singleton(reportId));
        return EmptyUtil.isNoEmpty(reports) ? reports.get(0) : new Report();
    }

    @Override
    public List<Report> loadReportWithAllDimension(Set<Long> reportIdS) {
        return ReportNewRepository.loadReportWithAllDimension(reportIdS);
    }

    private ReportTemplate templateCopyIfNeed(ReportTemplate template, int size) {
        if (size <= 1) {
            return template;
        }
        return (ReportTemplate)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)template), ReportTemplate.class);
    }

    @Override
    public List<Report> loadReportWithAllDimensionByParam(ReportQDTO qDto) {
        FpmAssertUtil.isNotNull((Object)qDto, (String)"param is null");
        Set<Long> idSet = this.loadReportIdsByParam(qDto);
        return this.loadReportWithAllDimension(idSet);
    }

    @Override
    public List<Report> loadReport(Set<Long> reportIdS) {
        return ReportNewRepository.loadReport(reportIdS);
    }

    @Override
    public Map<Long, String> loadReportNumber(Set<Long> reportIdS) {
        DynamicObjectCollection load = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", "id", "billno"), (QFilter[])new QFilter[]{new QFilter("id", "in", reportIdS)});
        HashMap<Long, String> result = new HashMap<Long, String>(32);
        for (DynamicObject reportDy : load) {
            result.put(reportDy.getLong("id"), reportDy.getString("billno"));
        }
        return result;
    }

    @Override
    public Map<Long, Long> loadReportSystemId(Collection<Long> reportIdS) {
        if (CollectionUtils.isEmpty(reportIdS)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        String systemIdProp = String.join((CharSequence)".", "bodysys", "id");
        DynamicObjectCollection load = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", "id", systemIdProp), (QFilter[])new QFilter[]{new QFilter("id", "in", reportIdS)});
        HashMap result = Maps.newHashMapWithExpectedSize((int)reportIdS.size());
        for (DynamicObject reportDy : load) {
            result.put(reportDy.getLong("id"), reportDy.getLong(systemIdProp));
        }
        return result;
    }

    @Override
    public List<Report> loadSimpleReport(Set<Long> reportIdS, ReportNeedPropDTO needProp) {
        return ReportNewRepository.loadSimpleReport(reportIdS, needProp);
    }

    @Override
    public List<Report> loadSimpleReport(Set<Long> reportIdS, Consumer<ReportNeedPropDTO> needProp) {
        ReportNeedPropDTO reportNeedPropDTO = new ReportNeedPropDTO();
        if (Objects.nonNull(needProp)) {
            needProp.accept(reportNeedPropDTO);
        }
        return this.loadSimpleReport(reportIdS, reportNeedPropDTO);
    }

    @Override
    public List<Report> loadSimpleReport(ReportQDTO reportQDTO, Consumer<ReportNeedPropDTO> needProp) {
        Set<Long> reportIdSet = this.queryReportIdSet(reportQDTO);
        ReportNeedPropDTO reportNeedPropDTO = new ReportNeedPropDTO();
        if (Objects.nonNull(needProp)) {
            needProp.accept(reportNeedPropDTO);
        }
        return this.loadSimpleReport(reportIdSet, reportNeedPropDTO);
    }

    @Override
    public Report saveReport(Report report, boolean isSplit) {
        return null;
    }

    @Override
    public Report saveReport(Report report) {
        long reportId = report.getId();
        DynamicObject reportPO = QueryServiceHelper.exists((String)"fpm_report", (Object)reportId) ? TmcDataServiceHelper.loadSingle((Object)reportId, (String)"fpm_report") : TmcDataServiceHelper.newDynamicObject((String)"fpm_report");
        ReportPoConverter.convertToReportPo(report, reportPO);
        TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_report", (DynamicObject[])new DynamicObject[]{reportPO}, (OperateOption)OperateOption.create());
        return report;
    }

    @Override
    public void updateReport(List<? extends Report> reportList, boolean isSplit) {
    }

    @Override
    public void save(DynamicObject report) {
        FpmAssertUtil.isNotNull((Object)report, (String)"report is null");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
    }

    @Override
    public void updateReport(List<? extends Report> reportList) {
        DynamicObject[] dbDataArr;
        List idList = reportList.stream().map(Report::getId).collect(Collectors.toList());
        for (DynamicObject dbData : dbDataArr = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_report"))) {
            Report report = reportList.stream().filter(item -> dbData.getPkValue().equals(item.getId())).findFirst().get();
            ReportPoConverter.convertToReportPo(report, dbData);
        }
        SaveServiceHelper.save((DynamicObject[])dbDataArr);
    }

    @Override
    public void submit(long reportId) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ReportOpType", ReportOpType.SERVICE.getNumber());
        TmcOperateServiceHelper.execOperate((String)"submitop", (String)"fpm_report", (Object[])new Object[]{reportId}, (OperateOption)operateOption);
    }

    @Override
    public void audit(long reportId) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ReportOpType", ReportOpType.SERVICE.getNumber());
        TmcOperateServiceHelper.execOperate((String)"audit", (String)"fpm_report", (Object[])new Object[]{reportId}, (OperateOption)operateOption);
    }

    @Override
    public void unAudit(long reportId) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ReportOpType", ReportOpType.SERVICE.getNumber());
        TmcOperateServiceHelper.execOperate((String)"unaudit", (String)"fpm_report", (Object[])new Object[]{reportId}, (OperateOption)operateOption);
    }

    @Override
    public void unSubmit(long reportId) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ReportOpType", ReportOpType.SERVICE.getNumber());
        TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"fpm_report", (Object[])new Object[]{reportId}, (OperateOption)operateOption);
    }

    @Override
    public List<Long> saveReportWithoutData(List<Report> reportList, boolean isSplit) {
        return null;
    }

    @Override
    public List<Long> saveReportWithoutData(List<Report> reportList) {
        ArrayList<DynamicObject> saveDataList = new ArrayList<DynamicObject>(reportList.size());
        HashMap<Report, DynamicObject> reportMap = new HashMap<Report, DynamicObject>(reportList.size());
        for (Report report : reportList) {
            DynamicObject reportDO = TmcDataServiceHelper.newDynamicObject((String)"fpm_report");
            saveDataList.add(reportDO);
            reportMap.put(report, reportDO);
        }
        ReportPoConverter.batchConvertToReportPo(reportMap);
        for (DynamicObject reportDO : saveDataList) {
            reportDO.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            reportDO.set("planstatus", (Object)ReportPlanStatusEnum.INEFFECTIVE.getValue());
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isGenTime", "1");
        OperationResult save = TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_report", (DynamicObject[])saveDataList.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        List successPkIds = save.getSuccessPkIds();
        return successPkIds.stream().map(item -> (Long)item).collect(Collectors.toList());
    }

    @Override
    public Report queryParentReport(Long reportOrgId, Long reportPeriodId, Long templateId) {
        Long reportId = this.queryParentReportId(reportOrgId, reportPeriodId, templateId);
        return reportId != null ? this.loadReport(reportId) : null;
    }

    @Override
    public Long queryParentReportId(Long reportId) {
        DynamicObject currReportObj = QueryServiceHelper.queryOne((String)"fpm_report", (String)"reportorg.id,parenttemplate.id,reportperiod.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
        if (currReportObj == null) {
            return null;
        }
        return this.queryParentReportId(currReportObj.getLong("reportorg.id"), currReportObj.getLong("reportperiod.id"), currReportObj.getLong("parenttemplate.id"));
    }

    private Long queryParentReportId(Long reportOrgId, Long reportPeriodId, Long templateId) {
        QFilter qFilter = new QFilter("reportorg.id", "=", (Object)reportOrgId).and("reportperiod.id", "=", (Object)reportPeriodId).and("template.id", "=", (Object)templateId);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_report", (QFilter[])qFilter.toArray(), null, (int)-1);
        return ids.size() != 1 ? null : (Long)ids.get(0);
    }

    @Override
    public List<Report> querySubReport(Long reportId) {
        Report report = this.loadReport(reportId);
        ReportTemplate template = report.getTemplate();
        long templateId = template.getCopyId();
        List<OrgMember> companyMemberList = report.getCompanyMemberList();
        List<PeriodMember> periodMemberList = report.getPeriodMemberList();
        List<Long> reportIds = this.queryReportIds(Collections.singletonList(templateId), Collections.singletonList(companyMemberList.get(0).getId()), Collections.singletonList(periodMemberList.get(0).getId()));
        return this.loadReport(new HashSet<Long>(reportIds));
    }

    private List<Long> queryReportIds(List<Long> templateIds, List<Long> reportOrgIds, List<Long> periodMemberIds) {
        QFilter qFilter = new QFilter("parenttemplate.id", "in", templateIds).and("reportperiod", "in", periodMemberIds).and("reportorg", "in", reportOrgIds);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_report", (QFilter[])qFilter.toArray(), null, (int)-1);
        return ids.stream().map(item -> (Long)item).collect(Collectors.toList());
    }

    @Override
    public List<Long> querySubReportId(Long reportId) {
        DynamicObject currReportObj = QueryServiceHelper.queryOne((String)"fpm_report", (String)"reportorg.id,templatebak.templateid,reportperiod.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
        return this.queryReportIds(Collections.singletonList(currReportObj.getLong("templatebak.templateid")), Collections.singletonList(currReportObj.getLong("reportorg.id")), Collections.singletonList(currReportObj.getLong("reportperiod.id")));
    }

    @Override
    public List<Long> querySubReportId(List<Long> reportIds) {
        if (EmptyUtil.isEmpty(reportIds)) {
            return new ArrayList<Long>(0);
        }
        DynamicObjectCollection reportDyColl = QueryServiceHelper.query((String)"fpm_report", (String)"reportorg.id,templatebak.templateid,reportperiod.id", (QFilter[])new QFilter[]{new QFilter("id", "in", reportIds)});
        ArrayList<Long> parentTemplateIds = new ArrayList<Long>(reportDyColl.size());
        ArrayList<Long> reportPeriodIds = new ArrayList<Long>(reportDyColl.size());
        ArrayList<Long> reportOrgIds = new ArrayList<Long>(reportDyColl.size());
        reportDyColl.forEach(dy -> {
            parentTemplateIds.add(dy.getLong("templatebak.templateid"));
            reportPeriodIds.add(dy.getLong(String.join((CharSequence)".", "reportperiod", "id")));
            reportOrgIds.add(dy.getLong(String.join((CharSequence)".", "reportorg", "id")));
        });
        return this.queryReportIds(parentTemplateIds, reportOrgIds, reportPeriodIds);
    }

    @Override
    public void updateBaseInfo(List<ReportUpdateDTO> updateDTOList) {
        DynamicObject[] dbDataArr;
        ArrayList<String> queryPropList = new ArrayList<String>(16);
        queryPropList.add("id");
        if (CollectionUtils.isEmpty(updateDTOList)) {
            return;
        }
        queryPropList.add("changestatus");
        Map updateDTOMap = updateDTOList.stream().collect(Collectors.toMap(ReportUpdateDTO::getId, Function.identity(), (a, b) -> a));
        for (DynamicObject dbData : dbDataArr = TmcDataServiceHelper.load((String)"fpm_report", (String)String.join((CharSequence)",", queryPropList), (QFilter[])new QFilter[]{new QFilter("id", "in", updateDTOMap.keySet())})) {
            ReportUpdateDTO updateDTO = (ReportUpdateDTO)updateDTOMap.get(dbData.getLong("id"));
            if (updateDTO.getChangeStatus() == null) continue;
            dbData.set("changestatus", (Object)ReportPlanChangeStatusEnum.valueOf((String)updateDTO.getChangeStatus().name()).getValue());
        }
        TmcDataServiceHelper.save((DynamicObject[])dbDataArr);
    }

    @Override
    public List<Report> loadReport(ReportQDTO qDto) {
        Set<Long> idSet = this.loadReportIdsByParam(qDto);
        return this.loadReport(idSet);
    }

    @Override
    public List<Report> loadReport(Long reportOrgId, Long reportPeriodId, Consumer<ReportQDTO> consumer) {
        ReportQDTO reportQDTO = new ReportQDTO();
        reportQDTO.setReportOrgId(reportOrgId);
        reportQDTO.setReportPeriodId(reportPeriodId);
        if (Objects.nonNull(consumer)) {
            consumer.accept(reportQDTO);
        }
        return this.loadReport(reportQDTO);
    }

    @Override
    public Report loadReport(Long systemId, Long templateId, Long reportPeriodId, Long reportOrgId) {
        QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId).and("templatebak", "=", (Object)templateId).and("reportperiod", "=", (Object)reportPeriodId).and("reportorg", "=", (Object)reportOrgId);
        DynamicObject report = QueryServiceHelper.queryOne((String)"fpm_report", (String)"id", (QFilter[])qFilter.toArray());
        return report != null ? this.loadReport(report.getLong("id")) : null;
    }

    @Override
    public void deleteAuxDataList(Report report) {
        DynamicObject reportDO = TmcDataServiceHelper.loadSingle((Object)report.getId(), (String)"fpm_report");
        DynamicObjectCollection auxEntrys = reportDO.getDynamicObjectCollection("auxentry");
        List execDeviationAnalysisList = auxEntrys.stream().filter(d -> d.getDynamicObject("aux_bdtype") != null && ITypeEnum.getByNumber(d.getDynamicObject("aux_bdtype").getString("usetype"), AuxiliaryFieldsUseType.class) == AuxiliaryFieldsUseType.EXEC_DEVIATION_ANALYSIS).collect(Collectors.toList());
        auxEntrys.removeAll(execDeviationAnalysisList);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportDO});
    }

    @Override
    public Map<Long, Set<Long>> getExistsReportId(Consumer<ReportQDTO> consumer) {
        if (Objects.isNull(consumer)) {
            return Collections.emptyMap();
        }
        ReportQDTO qDto = new ReportQDTO();
        consumer.accept(qDto);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        if (qDto.getBodySysId() != null) {
            qFilterList.add(new QFilter("bodysys", "=", (Object)qDto.getBodySysId()));
        }
        if (qDto.getReportPeriodId() != null) {
            qFilterList.add(new QFilter("reportperiod", "=", (Object)qDto.getReportPeriodId()));
        }
        if (!CollectionUtils.isEmpty(qDto.getReportPeriodIdList())) {
            qFilterList.add(new QFilter("reportperiod", "in", qDto.getReportPeriodIdList()));
        }
        if (qDto.getReportOrgId() != null) {
            qFilterList.add(new QFilter("reportorg", "=", (Object)qDto.getReportOrgId()));
        }
        if (EmptyUtil.isNoEmpty(qDto.getReportOrgIdList())) {
            qFilterList.add(new QFilter("reportorg", "in", qDto.getReportOrgIdList()));
        }
        if (qDto.getReportPlanType() != null) {
            qFilterList.add(new QFilter("reportplantype", "=", (Object)qDto.getReportPlanType().getNumber()));
        }
        if (qDto.getReportStatus() != null) {
            qFilterList.add(new QFilter("planstatus", "=", (Object)qDto.getReportStatus().getVal()));
        }
        if (qDto.getProcessStatus() != null) {
            qFilterList.add(new QFilter("billstatus", "=", (Object)qDto.getProcessStatus().getValue()));
        }
        if (Objects.nonNull(qDto.isMainTable())) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "template", "ismaintable"), "=", (Object)qDto.isMainTable()));
        }
        String reportOrgId = String.join((CharSequence)".", "reportorg", "id");
        String selectFields = String.join((CharSequence)",", "id", reportOrgId);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[0]));
        return dynamicObjectCollection.stream().collect(Collectors.groupingBy(dy -> dy.getLong(reportOrgId), Collectors.mapping(dy -> dy.getLong("id"), Collectors.toSet())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, List<Long>> getSourceId2ReportDataIdMap(Long reportId, Collection<Long> sourceIds) {
        HashMap<Long, List> hashMap;
        String sourceIdList = sourceIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        String sql = String.format("select fmaindimdataid,fsourcedocid from t_fpm_rowdataid_save where fid = %d and fsourcedocid in (%s)", reportId, sourceIdList);
        DataSet dataSet = DB.queryDataSet((String)"getSourceId2ReportDataIdMap", (DBRoute)DBRouteConst.TMC, (String)sql, (Object[])new Object[0]);
        try {
            HashMap<Long, List> sourceIdToDataIdMap = new HashMap<Long, List>(8);
            for (Row row : dataSet) {
                Long sourceId = row.getLong("fsourcedocid");
                List list = sourceIdToDataIdMap.computeIfAbsent(sourceId, d -> new ArrayList(8));
                list.add(row.getLong("fmaindimdataid"));
            }
            hashMap = sourceIdToDataIdMap;
        }
        catch (Throwable throwable) {
            DataSetUtil.closeDataSet(dataSet);
            throw throwable;
        }
        DataSetUtil.closeDataSet(dataSet);
        return hashMap;
    }

    @Override
    public Map<Long, List<Long>> getReportDataId2SourceIdMapByReportId(Long reportId) {
        QFilter qFilter = new QFilter("id", "=", (Object)reportId);
        DynamicObjectCollection load = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", "id", "sourceidentry.rdi_reportdataid", "sourceidentry.sourcedocid"), (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)load)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Set sourceIds = load.stream().map(dy -> dy.getLong("sourceidentry.sourcedocid")).collect(Collectors.toSet());
        QFilter mainFilter = new QFilter("maindimentry.id", "in", sourceIds);
        mainFilter.and(new QFilter("maindimentry.maintable", "=", (Object)"1"));
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_report", (String)"maindimentry.id", (QFilter[])mainFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)queryResult)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Set mainDataIdSet = queryResult.stream().map(i -> i.getLong("maindimentry.id")).collect(Collectors.toSet());
        Map allMap = load.stream().collect(Collectors.groupingBy(dy -> dy.getLong("sourceidentry.rdi_reportdataid"), Collectors.mapping(dy -> dy.getLong("sourceidentry.sourcedocid"), Collectors.toList())));
        HashMap<Long, List<Long>> resMap = new HashMap<Long, List<Long>>(allMap.size());
        allMap.forEach((k, v) -> {
            List filterIds = v.stream().filter(mainDataIdSet::contains).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(filterIds)) {
                return;
            }
            resMap.put((Long)k, filterIds);
        });
        return resMap;
    }

    private Set<Long> queryReportIdSet(ReportQDTO reportQDTO) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (reportQDTO.getBodySysId() != null) {
            qFilterList.add(new QFilter("bodysys", "=", (Object)reportQDTO.getBodySysId()));
        }
        if (reportQDTO.getReportPeriodId() != null) {
            qFilterList.add(new QFilter("reportperiod", "=", (Object)reportQDTO.getReportPeriodId()));
        }
        if (!CollectionUtils.isEmpty(reportQDTO.getReportPeriodIdList())) {
            qFilterList.add(new QFilter("reportperiod", "in", reportQDTO.getReportPeriodIdList()));
        }
        if (reportQDTO.getReportOrgId() != null) {
            qFilterList.add(new QFilter("reportorg", "=", (Object)reportQDTO.getReportOrgId()));
        }
        if (reportQDTO.getReportPlanType() != null) {
            qFilterList.add(new QFilter("reportplantype", "=", (Object)reportQDTO.getReportPlanType().getNumber()));
        }
        if (reportQDTO.getReportStatus() != null) {
            qFilterList.add(new QFilter("planstatus", "=", (Object)reportQDTO.getReportStatus().getVal()));
        }
        if (reportQDTO.getProcessStatus() != null) {
            qFilterList.add(new QFilter("billstatus", "=", (Object)reportQDTO.getProcessStatus().getValue()));
        }
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_report", (QFilter[])qFilterList.toArray(new QFilter[0]), null, (int)-1);
        return ids.stream().map(item -> (Long)item).collect(Collectors.toSet());
    }

    @Override
    public Set<Long> loadReportIdsByParam(ReportQDTO qDto) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        if (qDto.getBodySysId() != null) {
            qFilterList.add(new QFilter("bodysys", "=", (Object)qDto.getBodySysId()));
        }
        if (qDto.getReportPeriodId() != null) {
            qFilterList.add(new QFilter("reportperiod", "=", (Object)qDto.getReportPeriodId()));
        }
        if (!CollectionUtils.isEmpty(qDto.getReportPeriodIdList())) {
            qFilterList.add(new QFilter("reportperiod", "in", qDto.getReportPeriodIdList()));
        }
        if (qDto.getReportOrgId() != null) {
            qFilterList.add(new QFilter("reportorg", "=", (Object)qDto.getReportOrgId()));
        }
        if (qDto.getReportPlanType() != null) {
            qFilterList.add(new QFilter("reportplantype", "=", (Object)qDto.getReportPlanType().getNumber()));
        }
        if (qDto.getReportStatus() != null) {
            qFilterList.add(new QFilter("planstatus", "=", (Object)qDto.getReportStatus().getVal()));
        }
        if (qDto.getProcessStatus() != null) {
            qFilterList.add(new QFilter("billstatus", "=", (Object)qDto.getProcessStatus().getValue()));
        }
        if (qDto.isMainTable() != null) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "template", "ismaintable"), "=", (Object)qDto.isMainTable()));
        }
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"fpm_report", (QFilter[])qFilterList.toArray(new QFilter[0]), null, (int)-1);
        return ids.stream().map(item -> (Long)item).collect(Collectors.toSet());
    }

    @Override
    public List<VerifyReport> getReportForVerifyRule(Collection<Long> reportIds) {
        String selectFields = "id,billno,bodysys.id,template.id,reportorg.id,reportperiod.id,initflag";
        QFilter qFilter = new QFilter("id", "in", reportIds);
        DynamicObjectCollection reportObjs = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])qFilter.toArray());
        return ConverterUtils.convertList(VerifyReport.class, reportObjs);
    }

    @Override
    public Map<Long, Report> getReportForControl(Collection<Long> reportIds) {
        String selectFields = "id,billno,bodysys.id,templatebak.id,exratetable,exchangeratedate,auditor,informant.id";
        DynamicObjectCollection reportColls = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", reportIds)});
        ArrayList<Report> reports = new ArrayList<Report>(reportColls.size());
        List<Long> templateIdList = reportColls.stream().map(d -> d.getLong("templatebak.id")).collect(Collectors.toList());
        Map<Long, ReportTemplate> templateMap = this.templateRep.loadTemplateBakMap(templateIdList);
        for (DynamicObject reportColl : reportColls) {
            Report report = new Report();
            report.setId(reportColl.getLong("id"));
            report.setSystemId(reportColl.getLong("bodysys.id"));
            report.setNumber(reportColl.getString("billno"));
            report.setTemplate(templateMap.get(reportColl.getLong("templatebak.id")));
            report.setExchangeRateTableId(reportColl.getLong("exratetable"));
            report.setExchangeRateDate(reportColl.getDate("exchangeratedate"));
            report.setAuditErId(reportColl.getLong("auditor"));
            report.setInformantErId(reportColl.getLong("informant.id"));
            reports.add(report);
        }
        return reports.stream().collect(Collectors.toMap(Report::getId, d -> d));
    }

    @Override
    public Map<Long, DynamicObject> queryReportByIds(Collection<Long> reportIds, String selectProps) {
        if (Arrays.stream(selectProps.split(",")).noneMatch(s -> s.equals("id"))) {
            selectProps = "id," + selectProps;
        }
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"fpm_report", (String)selectProps, (QFilter[])new QFilter("id", "in", reportIds).toArray());
        return reports.stream().collect(Collectors.toMap(c -> c.getLong("id"), c -> c));
    }
}

