/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtDetailInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountDynamic;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRecord;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRule;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRuleParam;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecordCount;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.converter.InnerCancelRecordDynamicConverter;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import kd.tmc.fpm.common.property.SumPlanRecordProp;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class SumPlanRepository
implements ISumPlanRepository {
    private static Log logger = LogFactory.getLog(SumPlanRepository.class);

    @Override
    public SumPlanParamConfig loadSumConfigBySystem(Long systemId, Long reportTypeId) {
        List<SumPlanParamConfig> sumPlanParamConfigList = this.loadSumConfigBySystem(systemId, Collections.singleton(reportTypeId), true);
        return EmptyUtil.isEmpty(sumPlanParamConfigList) ? null : sumPlanParamConfigList.get(0);
    }

    @Override
    public List<SumPlanParamConfig> loadSumConfigBySystem(Long systemId) {
        return this.loadSumConfigBySystem(systemId, null, true);
    }

    @Override
    public List<SumPlanParamConfig> loadSumConfigBySystem(Long systemId, Collection<Long> reportTypeId, boolean filterDisabled) {
        return this.loadSumConfigBySystems(Collections.singletonList(systemId), reportTypeId, filterDisabled);
    }

    @Override
    public List<SumPlanParamConfig> loadSumConfigBySystems(Collection<Long> systemIds, Collection<Long> reportTypeId, boolean filterDisabled) {
        String reportTypeProp = String.join((CharSequence)".", "sumreporttype", "fbasedataid", "id");
        QFilter qFilter = new QFilter("bodysys", "in", systemIds);
        if (EmptyUtil.isNoEmpty(reportTypeId)) {
            qFilter = qFilter.and(reportTypeProp, "in", reportTypeId);
        }
        if (filterDisabled) {
            qFilter = qFilter.and("enable", "=", (Object)"1");
        }
        Map loads = TmcDataServiceHelper.loadFromCache((String)"fpm_summaryconfig", (QFilter[])qFilter.toArray());
        List<SumPlanParamConfig> sumPlanParamConfigs = ConverterUtils.convert(SumPlanParamConfig.class, loads.values(), false, "fpm_summaryconfig");
        return sumPlanParamConfigs.stream().sorted(Collections.reverseOrder(Comparator.comparing(SumPlanParamConfig::isEnable))).collect(Collectors.toList());
    }

    @Override
    public SumPlanParamConfig getSumPlanParamConfigBySnapshotId(Long sumParamConfigSnapshotId) {
        FpmAssertUtil.isNotNull((Object)sumParamConfigSnapshotId, (String)ResManager.loadKDString((String)"\u6c47\u603b\u53c2\u6570\u914d\u7f6e\u5feb\u7167ID\uff0c\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"SummaryConfigServiceImpl_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)sumParamConfigSnapshotId, (String)"fpm_summaryconfig_snp");
        return ConverterUtils.convert(SumPlanParamConfig.class, dynamicObject);
    }

    @Override
    public List<InnerCancelRule> loadInCancelRule(InnerCancelRuleParam innerCancelRuleParam) {
        List<Long> optionalDimMemIdList;
        List<Long> currencyIdList;
        List<Long> reportTypeIdList;
        QFilter qFilter = new QFilter("bodysys", "=", (Object)innerCancelRuleParam.getSystemId());
        List<Long> orgIdList = innerCancelRuleParam.getOrgIdList();
        if (!CollectionUtils.isEmpty(orgIdList)) {
            qFilter = qFilter.and(String.join((CharSequence)".", "apply_entryentity", "apply_reportorg"), "in", orgIdList);
        }
        if (!CollectionUtils.isEmpty(reportTypeIdList = innerCancelRuleParam.getReportTypeIdList())) {
            String reportTypeProp = String.join((CharSequence)".", "applyreporttype", "fbasedataid", "id");
            qFilter = qFilter.and(reportTypeProp, "in", reportTypeIdList);
        }
        if (!CollectionUtils.isEmpty(currencyIdList = innerCancelRuleParam.getCurrencyIdList())) {
            String currencyProp = String.join((CharSequence)".", "applycurrency", "fbasedataid", "id");
            qFilter = qFilter.and(currencyProp, "in", currencyIdList);
        }
        if (!CollectionUtils.isEmpty(optionalDimMemIdList = innerCancelRuleParam.getOptionalDimMemIdList())) {
            String optionalDimProp = String.join((CharSequence)".", "applyoptionaldim", "fbasedataid", "id");
            qFilter = qFilter.and(optionalDimProp, "in", optionalDimMemIdList);
        }
        if (innerCancelRuleParam.isFilterDisabled()) {
            qFilter = qFilter.and("enable", "=", (Object)"1");
        }
        DynamicObjectCollection load = QueryServiceHelper.query((String)"fpm_internalcancelrule", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return ConverterUtils.convert(InnerCancelRule.class, (Collection<DynamicObject>)load, true, "fpm_internalcancelrule");
    }

    @Override
    public List<InnerCancelRule> loadInCancelRuleBySystem(Long systemId) {
        QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId).and("enable", "=", (Object)"1");
        DynamicObjectCollection load = QueryServiceHelper.query((String)"fpm_internalcancelrule", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return ConverterUtils.convert(InnerCancelRule.class, (Collection<DynamicObject>)load, true, "fpm_internalcancelrule");
    }

    @Override
    public Long saveSumPlanRecord(SumPlanRecord sumPlanRecord) {
        if (sumPlanRecord == null) {
            return null;
        }
        DynamicObject convert = ConverterUtils.convert(DynamicObject.class, sumPlanRecord);
        OperationResult save = TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_reportplansum", (DynamicObject[])new DynamicObject[]{convert}, (OperateOption)OperateOption.create());
        List successPkIds = save.getSuccessPkIds();
        return (Long)successPkIds.get(0);
    }

    @Override
    public List<Long> saveSumPlanRecord(List<SumPlanRecord> sumPlanRecords) {
        if (EmptyUtil.isEmpty(sumPlanRecords)) {
            return null;
        }
        ArrayList<Long> idList = new ArrayList<Long>(sumPlanRecords.size());
        for (SumPlanRecord sumPlanRecord : sumPlanRecords) {
            idList.add(this.saveSumPlanRecord(sumPlanRecord));
        }
        return idList;
    }

    @Override
    public SumPlanRecord loadSumPlanRecord(Long id) {
        DynamicObject dy = TmcDataServiceHelper.loadSingle((Object)id, (String)"fpm_reportplansum", (String)SumPlanRecordProp.HEAD_SELECT_FIELDS);
        return ConverterUtils.convert(SumPlanRecord.class, dy);
    }

    @Override
    public List<SumPlanRecord> loadSumPlanRecord(Collection<Long> reportOrgIds, Long reportPeriodId) {
        QFilter qFilter = new QFilter("reportorg", "in", reportOrgIds).and("reportperiod", "=", (Object)reportPeriodId);
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_reportplansum", (String)SumPlanRecordProp.HEAD_SELECT_FIELDS, (QFilter[])new QFilter[]{qFilter});
        return ConverterUtils.convert(SumPlanRecord.class, Arrays.asList(load));
    }

    @Override
    public SumPlanRecord loadSumPlanRecord(Long reportOrgIds, Long reportPeriodId) {
        List<Long> ids = Collections.singletonList(reportOrgIds);
        List<SumPlanRecord> sumPlanRecords = this.loadSumPlanRecord(ids, reportPeriodId);
        if (sumPlanRecords.size() > 0) {
            return sumPlanRecords.get(0);
        }
        return null;
    }

    @Override
    public List<SumPlanRecord> loadSumPlanRecord(List<Long> ids) {
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_reportplansum", (String)SumPlanRecordProp.HEAD_SELECT_FIELDS, (QFilter[])new QFilter("id", "in", ids).toArray());
        return ConverterUtils.convert(SumPlanRecord.class, Arrays.asList(load));
    }

    @Override
    public List<InnerCancelRecord> loadInCRecordBySumId(Long sumPlanRecordId) {
        QFilter qFilter = new QFilter("sumplanrecordid", "=", (Object)sumPlanRecordId);
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"fpm_innercancelrecord", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return ConverterUtils.convert(InnerCancelRecord.class, (Collection<DynamicObject>)colls, true, "fpm_innercancelrecord");
    }

    @Override
    public boolean saveInnerCancelRecord(InnerCancelRecord record) {
        if (record == null) {
            return false;
        }
        Long recordId = record.getId();
        boolean exists = TmcDataServiceHelper.exists((String)"fpm_innercancelrecord", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)recordId)});
        DynamicObject recordPO = exists ? TmcDataServiceHelper.loadSingle((Object)recordId, (String)"fpm_innercancelrecord") : TmcDataServiceHelper.newDynamicObject((String)"fpm_innercancelrecord");
        InnerCancelRecordDynamicConverter.convert(record, recordPO);
        TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_innercancelrecord", (DynamicObject[])new DynamicObject[]{recordPO}, (OperateOption)OperateOption.create());
        return true;
    }

    @Override
    public void batchSaveInnerCancleRecord(List<InnerCancelRecord> records) {
        if (EmptyUtil.isEmpty(records)) {
            return;
        }
        ArrayList<DynamicObject> waitInnerCancleRecords = new ArrayList<DynamicObject>(records.size());
        for (InnerCancelRecord record : records) {
            DynamicObject innerCanckeRecirdDy = TmcDataServiceHelper.newDynamicObject((String)"fpm_innercancelrecord");
            InnerCancelRecordDynamicConverter.convert(record, innerCanckeRecirdDy);
            waitInnerCancleRecords.add(innerCanckeRecirdDy);
        }
        TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_innercancelrecord", (DynamicObject[])waitInnerCancleRecords.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
    }

    @Override
    public int deleteInnerCancleRecordBySumPlanId(Long sumPlanId) {
        if (EmptyUtil.isEmpty((Long)sumPlanId)) {
            return 0;
        }
        int size = DeleteServiceHelper.delete((String)"fpm_innercancelrecord", (QFilter[])new QFilter[]{new QFilter("sumplanrecordid", "=", (Object)sumPlanId)});
        return size;
    }

    @Override
    public ApprovedAmountRecord loadApprovedAmtBySumId(Long sumPlanRecordId) {
        return this.loadApprovedAmtBySumId(sumPlanRecordId, (List<Long>)null, true);
    }

    @Override
    public List<ApprovedAmountAmtDetailInfo> loadDownOrgApprovedAmt(List<Long> downSumPlanRecordIds, List<Long> downReportDataIds) {
        if (EmptyUtil.isEmpty(downSumPlanRecordIds) || EmptyUtil.isEmpty(downReportDataIds)) {
            return Collections.emptyList();
        }
        String select = "id,mentryentity.id,mentryentity.dentryentity.id,mentryentity.dentryentity.dmonetary,mentryentity.dentryentity.eval_reportid,mentryentity.dentryentity.eval_reportdataid,mentryentity.dentryentity.eval_evaladjustreason,mentryentity.dentryentity.eval_detail,mentryentity.dentryentity.eval_planreportnumber,mentryentity.dentryentity.eval_filluser,mentryentity.dentryentity.eval_originalapprovalamt,mentryentity";
        QFilter qFilter = new QFilter("reportid", "in", downSumPlanRecordIds).and("mentryentity.dentryentity.eval_reportdataid", "in", downReportDataIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_approvedplanquota", (String)select, (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
            return Collections.emptyList();
        }
        return ConverterUtils.convert(ApprovedAmountAmtDetailInfo.class, query);
    }

    @Override
    public ApprovedAmountRecord loadApprovedAmtBySumId(Long sumPlanRecordId, List<Long> reportDataIds, boolean needSubEntry) {
        DynamicObject[] dynamicObject;
        ApprovedAmountDynamic approvedAmountDynamic = new ApprovedAmountDynamic();
        String select = "number,systemid,summaryt,member,orgreporttype,orgreportperiod,exratetable,exratedate,amountunit,reportid,mentryentity,mentryentity.monetary,mentryentity.entry_reportdataid,mentryentity.entry_sumreportdataids";
        QFilter qFilter = new QFilter("reportid", "=", (Object)sumPlanRecordId);
        if (needSubEntry) {
            select = select + ",dentryentity.dmonetary,dentryentity.eval_reportdataid,dentryentity.eval_reportid,dentryentity.eval_evaladjustreason,dentryentity.eval_detail,dentryentity.eval_planreportnumber,dentryentity.eval_filluser,dentryentity.eval_originalapprovalamt,dentryentity";
        }
        if (null != reportDataIds && reportDataIds.size() > 0) {
            qFilter.and(new QFilter("mentryentity.entry_reportdataid", "in", reportDataIds));
        }
        if ((dynamicObject = TmcDataServiceHelper.load((String)"fpm_approvedplanquota", (String)select, (QFilter[])new QFilter[]{qFilter})).length == 0) {
            return null;
        }
        approvedAmountDynamic.setApprovedAmount(dynamicObject[0]);
        approvedAmountDynamic.setNeedSubEntry(needSubEntry);
        return ConverterUtils.convert(ApprovedAmountRecord.class, approvedAmountDynamic);
    }

    @Override
    public List<ApprovedAmountAmtDetailInfo> loadApprovedAmtBySumId(Long sumPlanRecordId, Long approvalReportDataId, Boolean isDetail) {
        DynamicObjectCollection query;
        String select = "id,mentryentity.id,mentryentity.dentryentity.id,mentryentity.dentryentity.dmonetary,mentryentity.dentryentity.eval_reportid,mentryentity.dentryentity.eval_reportdataid,mentryentity.dentryentity.eval_evaladjustreason,mentryentity.dentryentity.eval_detail,mentryentity.dentryentity.eval_planreportnumber,mentryentity.dentryentity.eval_filluser,mentryentity.dentryentity.eval_originalapprovalamt,mentryentity";
        QFilter qFilter = new QFilter("reportid", "=", (Object)sumPlanRecordId);
        if (EmptyUtil.isNoEmpty((Long)approvalReportDataId)) {
            qFilter.and(new QFilter("mentryentity.entry_reportdataid", "=", (Object)approvalReportDataId));
        }
        if (Objects.nonNull(isDetail)) {
            qFilter.and(new QFilter("mentryentity.dentryentity.eval_detail", "=", (Object)isDetail));
        }
        if ((query = QueryServiceHelper.query((String)"fpm_approvedplanquota", (String)select, (QFilter[])new QFilter[]{qFilter})).size() == 0) {
            return Collections.emptyList();
        }
        return ConverterUtils.convert(ApprovedAmountAmtDetailInfo.class, query);
    }

    @Override
    public List<ApprovedAmountAmtDetailInfo> loadApprovedAmtBySumIds(Collection<Long> sumPlanRecordIds, Boolean isDetail) {
        DynamicObjectCollection query;
        String select = "id,mentryentity.id,mentryentity.dentryentity.id,mentryentity.dentryentity.dmonetary,mentryentity.dentryentity.eval_reportid,mentryentity.dentryentity.eval_reportdataid,mentryentity.dentryentity.eval_evaladjustreason,mentryentity.dentryentity.eval_detail,mentryentity.dentryentity.eval_planreportnumber,mentryentity.dentryentity.eval_filluser,mentryentity.dentryentity.eval_originalapprovalamt,mentryentity";
        QFilter qFilter = new QFilter("reportid", "in", sumPlanRecordIds);
        if (Objects.nonNull(isDetail)) {
            qFilter.and(new QFilter("mentryentity.dentryentity.eval_detail", "=", (Object)isDetail));
        }
        if ((query = QueryServiceHelper.query((String)"fpm_approvedplanquota", (String)select, (QFilter[])new QFilter[]{qFilter})).size() == 0) {
            return Collections.emptyList();
        }
        return ConverterUtils.convert(ApprovedAmountAmtDetailInfo.class, query);
    }

    @Override
    public FpmOperateResult saveApprovedAmountRecord(ApprovedAmountRecord record) {
        try {
            DynamicObject convert = ConverterUtils.convert(DynamicObject.class, record);
            TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_approvedplanquota", (DynamicObject[])new DynamicObject[]{convert}, (OperateOption)OperateOption.create());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return FpmOperateResult.error(e.getMessage());
        }
        return FpmOperateResult.success();
    }

    @Override
    public Long save(SumPlanRecord sumPlanRecord) {
        DynamicObject dynamicObject = ConverterUtils.convert(DynamicObject.class, sumPlanRecord);
        OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_reportplansum", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
        List successPkIds = operationResult.getSuccessPkIds();
        return EmptyUtil.isEmpty((Collection)successPkIds) ? Long.parseLong("0") : Long.parseLong(successPkIds.get(0).toString());
    }

    @Override
    public SumPlanRecord load(Long id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fpm_reportplansum", (String)SumPlanRecordProp.HEAD_SELECT_FIELDS);
        return ConverterUtils.convert(SumPlanRecord.class, dynamicObject);
    }

    @Override
    public SumPlanRecordCount countSumPlan(Long sumRecordId) {
        Long reportTypeId;
        String sumOrgIdProp = "reportorg.id";
        String bodySysIdProp = "bodysys.id";
        String reportTypeIdProp = "reporttype.id";
        String reportPeriodIdProp = "reportperiod.id";
        String sumRecordSelectFields = String.join((CharSequence)",", reportTypeIdProp, sumOrgIdProp, bodySysIdProp, reportPeriodIdProp, "billno");
        DynamicObject sumPlanRecord = QueryServiceHelper.queryOne((String)"fpm_reportplansum", (String)sumRecordSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sumRecordId)});
        Long systemId = sumPlanRecord.getLong(bodySysIdProp);
        SumPlanParamConfig sumPlanParamConfig = this.loadSumConfigBySystem(systemId, reportTypeId = Long.valueOf(sumPlanRecord.getLong(reportTypeIdProp)));
        if (EmptyUtil.isEmpty((Object)sumPlanParamConfig)) {
            return SumPlanRecordCount.builder().build();
        }
        Long reportOrgId = sumPlanRecord.getLong(sumOrgIdProp);
        List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
        HashSet<Long> orgSubPlan = new HashSet<Long>(2);
        HashSet<Long> orgSubSumPlan = new HashSet<Long>(2);
        for (SumPlanParamConfigInfo sumPlanParamConfigInfo : configInfoList) {
            if (!reportOrgId.equals(sumPlanParamConfigInfo.getOrgMemberId())) continue;
            List<SumPlanParamConfigInfo> paramConfigInfos = sumPlanParamConfigInfo.getAllChildren();
            for (SumPlanParamConfigInfo paramConfigInfo : paramConfigInfos) {
                if (paramConfigInfo.isSumAuditNode()) {
                    orgSubSumPlan.add(paramConfigInfo.getOrgMemberId());
                    continue;
                }
                orgSubPlan.add(paramConfigInfo.getOrgMemberId());
            }
        }
        QFilter qFilter = new QFilter("reportorg", "in", orgSubSumPlan);
        Long reportPeriodId = sumPlanRecord.getLong(reportPeriodIdProp);
        qFilter.and("reportperiod", "=", (Object)reportPeriodId);
        qFilter.and("bodysys", "=", (Object)systemId);
        DynamicObjectCollection subSumPlanBills = QueryServiceHelper.query((String)"fpm_reportplansum", (String)"id,planstatus,reportperiod,reportorg,billno", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection subReports = this.querySubReports(systemId, reportPeriodId, orgSubPlan);
        List subReportBillNos = subReports.stream().map(b -> b.getString("billno")).collect(Collectors.toList());
        List subSumPlanBillNos = subSumPlanBills.stream().map(b -> b.getString("billno")).collect(Collectors.toList());
        String sumRecordNumber = sumPlanRecord.getString("billno");
        logger.info("\u6c47\u603b\u8ba1\u5212\u7f16\u5236\u5355\u636e{}\u8be6\u60c5\u4e2d\uff0c\u4e0b\u7ea7\u8ba1\u5212\u7f16\u5236\u5355\u636e\uff1a{}\uff0c\u4e0b\u7ea7\u6c47\u603b\u7f16\u5236\u5355\u636e\uff1a{}", new Object[]{sumRecordNumber, subReportBillNos, subSumPlanBillNos});
        List noReportPlanBillIds = subReports.stream().filter(c -> ReportPlanStatusEnum.isIneffective((String)c.getString("planstatus")) || ReportPlanStatusEnum.isBeback((String)c.getString("planstatus"))).map(b -> b.getString("id")).collect(Collectors.toList());
        List reportPlanBillIds = subReports.stream().filter(c -> ReportPlanStatusEnum.isReporting((String)c.getString("planstatus")) || ReportPlanStatusEnum.isEffective((String)c.getString("planstatus"))).map(b -> b.getString("id")).collect(Collectors.toList());
        List noReportLLSumBillIds = subSumPlanBills.stream().filter(c -> ReportPlanStatusEnum.isIneffective((String)c.getString("planstatus")) || ReportPlanStatusEnum.isBeback((String)c.getString("planstatus"))).map(b -> b.getString("id")).collect(Collectors.toList());
        List reportLLSumBillIds = subSumPlanBills.stream().filter(c -> ReportPlanStatusEnum.isReporting((String)c.getString("planstatus")) || ReportPlanStatusEnum.isEffective((String)c.getString("planstatus"))).map(b -> b.getString("id")).collect(Collectors.toList());
        Map<Object, List<DynamicObject>> subReportOrgMap = subReports.stream().collect(Collectors.groupingBy(c -> c.getLong("reportorg.id")));
        Map<Object, List<DynamicObject>> subSumPlanOrgMap = subSumPlanBills.stream().collect(Collectors.groupingBy(c -> c.getLong("reportorg.id")));
        int totalReport = reportPlanBillIds.size() + reportLLSumBillIds.size();
        int totalUnReport = subReports.size() + subSumPlanBills.size() - totalReport;
        return SumPlanRecordCount.builder().noSumPlanOrgCnt(subReportOrgMap.size() + subSumPlanOrgMap.size()).noReportPlanBillCnt(noReportPlanBillIds.size()).noReportPlanBillIds(String.join((CharSequence)",", noReportPlanBillIds)).reportPlanBillIds(String.join((CharSequence)",", reportPlanBillIds)).noReportLLSumBillIds(String.join((CharSequence)",", noReportLLSumBillIds)).reportLLSumBillIds(String.join((CharSequence)",", reportLLSumBillIds)).noReportLLSumBillCnt(noReportLLSumBillIds.size()).reportPlanBillCnt(reportPlanBillIds.size()).reportLLSumBillCnt(reportLLSumBillIds.size()).subPlanNum(subReports.size()).subSumPlanNum(subSumPlanBills.size()).reportedPlanNum(totalReport).unReportedPlanNum(totalUnReport).build();
    }

    private DynamicObjectCollection querySubReports(Long systemId, Long reportPeriodId, Set<Long> orgSubPlan) {
        String selectFields = String.join((CharSequence)",", "id", "billno", "planstatus", "reportorg.id");
        QFilter subReportFilter = new QFilter("bodysys", "=", (Object)systemId).and("reportperiod", "=", (Object)reportPeriodId).and("reportorg", "in", orgSubPlan).and("reportplantype", "=", (Object)ReportPlanType.REPORTPLAN.getNumber());
        return QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])subReportFilter.toArray());
    }
}

