/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.repository.inspection.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fpm.business.domain.model.inspection.log.AmtConsistencyLog;
import kd.tmc.fpm.business.domain.model.inspection.log.BaseLog;
import kd.tmc.fpm.business.mvc.converter.inspection.AmtExceptionInfoPOConverter;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.inspection.IInspectionLogRepository;
import kd.tmc.fpm.common.property.InspectionLogProp;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class InspectionLogRepository
implements IInspectionLogRepository {
    @Override
    public void insert(BaseLog log) {
        DynamicObject dynamicObject = ConverterUtils.convert(DynamicObject.class, log);
        TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_inspection_log", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
    }

    @Override
    public List<BaseLog> queryLogByConfigIds(List<Long> configIds) {
        FpmAssertUtil.isNotEmpty(configIds, (String)"configIds id is null");
        DynamicObject[] logs = BusinessDataServiceHelper.load((String)"fpm_inspection_log", (String)InspectionLogProp.LOG_HEAD_SELECT_PROPS, (QFilter[])new QFilter[]{new QFilter("inspection_config", "in", configIds)});
        if (logs == null || logs.length == 0) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return Arrays.stream(logs).map(item -> ConverterUtils.convert(BaseLog.class, item)).collect(Collectors.toList());
    }

    @Override
    public List<BaseLog> queryLogByConfig(Long configId) {
        FpmAssertUtil.isNotNull((Object)configId, (String)"config id is null");
        DynamicObject[] logs = BusinessDataServiceHelper.load((String)"fpm_inspection_log", (String)InspectionLogProp.LOG_HEAD_SELECT_PROPS, (QFilter[])new QFilter[]{new QFilter("inspection_config", "=", (Object)configId)});
        if (logs == null || logs.length == 0) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return Arrays.stream(logs).map(item -> ConverterUtils.convert(BaseLog.class, item)).collect(Collectors.toList());
    }

    @Override
    public List<AmtConsistencyLog> queryBillInspectionLogByParam(List<Long> configIds, Date executeTimeStart, Date executeTimeEnd) {
        FpmAssertUtil.isNotEmpty(configIds, (String)"configIds is null");
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"fpm_inspection_log", (String)"id", (QFilter[])new QFilter[]{new QFilter("inspection_config", "in", configIds), new QFilter("execdate", ">=", (Object)executeTimeStart), new QFilter("execdate", "<=", (Object)executeTimeEnd)});
        if (ids == null || ids.length == 0) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        Object[] idsProps = Arrays.stream(ids).map(item -> item.getLong("id")).toArray();
        DynamicObject[] configObjs = BusinessDataServiceHelper.load((Object[])idsProps, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_inspection_log"));
        if (configObjs == null || configObjs.length == 0) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        AmtExceptionInfoPOConverter converter = new AmtExceptionInfoPOConverter();
        ArrayList<AmtConsistencyLog> result = new ArrayList<AmtConsistencyLog>(configIds.size());
        for (DynamicObject configObj : configObjs) {
            AmtConsistencyLog convert = converter.convert(configObj);
            result.add(convert);
        }
        return result;
    }
}

