/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.calculate;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.calculate.ReportDataFormula;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.service.calculate.FormulaGenerateStrategy;
import kd.tmc.fpm.business.mvc.service.calculate.ReportCalculateService;
import kd.tmc.fpm.business.mvc.service.dto.ReportCalculateDTO;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.common.utils.NumberUtils;

public abstract class AbstractCalculateService
implements ReportCalculateService {
    private static final Log LOGGER = LogFactory.getLog(AbstractCalculateService.class);
    private List<FormulaGenerateStrategy> formulaGenerateStrategyList = new ArrayList<FormulaGenerateStrategy>(8);
    private Set<Long> tempIdSet;
    private Comparator<ReportDataFormula> comparator;

    public AbstractCalculateService addStrategy(FormulaGenerateStrategy strategy) {
        this.formulaGenerateStrategyList.add(strategy);
        return this;
    }

    public void sort() {
        this.sortBy(AbstractCalculateService.defaultCompare());
    }

    public void sortBy(Comparator<ReportDataFormula> comparator) {
        this.comparator = comparator;
    }

    @Override
    public <T extends ReportData> List<T> calculateReport(ReportCalculateDTO calculateDTO) {
        ReportDataSource report = calculateDTO.getReport();
        if (this.checkParam(calculateDTO)) {
            return new ArrayList(0);
        }
        this.fillDataId(report);
        ArrayList<ReportDataFormula> formulaResult = new ArrayList<ReportDataFormula>(report.getReportDataList().size());
        this.formulaGenerateStrategyList.forEach(strategy -> {
            List<ReportDataFormula> reportDataFormulas = strategy.generateFormula(calculateDTO);
            formulaResult.addAll(reportDataFormulas);
        });
        if (EmptyUtil.isEmpty(formulaResult)) {
            LOGGER.warn("AbstractCalculateService.calculateReport stop calc, init formula is empty.");
            this.rollbackDataId(report.getReportDataList());
            return new ArrayList(0);
        }
        formulaResult.sort(this.comparator);
        List<ReportData> data = this.executeCalculate(calculateDTO, formulaResult);
        this.rollbackDataId(report.getReportDataList());
        this.rollbackDataId(data);
        return data;
    }

    private void rollbackDataId(List<ReportData> reportDataList) {
        if (!EmptyUtil.isEmpty(this.tempIdSet)) {
            reportDataList.forEach(item -> {
                if (Objects.isNull(item.getId())) {
                    return;
                }
                boolean contains = this.tempIdSet.contains(item.getId());
                if (contains) {
                    item.setId(null);
                }
            });
        }
    }

    private void fillDataId(ReportDataSource report) {
        boolean hasNullIdData;
        List idIsNullReportData = report.getReportDataList().stream().filter(item -> Objects.isNull(item.getId())).collect(Collectors.toList());
        boolean bl = hasNullIdData = !EmptyUtil.isEmpty(idIsNullReportData);
        if (hasNullIdData) {
            this.tempIdSet = new HashSet<Long>(idIsNullReportData.size());
            for (long i = 1L; i <= (long)idIsNullReportData.size(); ++i) {
                this.tempIdSet.add(i);
                ((ReportData)idIsNullReportData.get(Math.toIntExact(i) - 1)).setId(i);
            }
        }
    }

    private boolean checkParam(ReportCalculateDTO calculateDTO) {
        FundPlanSystem system = calculateDTO.getSystem();
        FpmAssertUtil.isNotNull((Object)system, (String)"system is null");
        FpmAssertUtil.isNotNull((Object)calculateDTO.getReport(), (String)"report is null");
        ReportTemplate template = calculateDTO.getReport().getTemplate();
        return template.getTemplateType() == TemplateType.DETAIL;
    }

    protected static Comparator<ReportDataFormula> defaultCompare() {
        return (o1, o2) -> {
            ReportData reportData1 = o1.getReportData();
            ReportData reportData2 = o2.getReportData();
            if (NumberUtils.notEquals((Integer)reportData1.getCol(), (Integer)reportData2.getCol())) {
                return Integer.compare(reportData1.getCol(), reportData2.getCol());
            }
            return o1.getFormulaType().compareTo(o2.getFormulaType());
        };
    }

    protected abstract <T extends ReportData> List<T> executeCalculate(ReportCalculateDTO var1, List<ReportDataFormula> var2);
}

