/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.calculate.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.dataproc.save.IReportDataSaveService;
import kd.tmc.fpm.business.dataproc.save.ReportDataSaveService;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodDirection;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.calculate.ReportCalculateAsyncService;
import kd.tmc.fpm.business.mvc.service.calculate.ReportCalculateService;
import kd.tmc.fpm.business.mvc.service.calculate.ReportCalculateServiceFactory;
import kd.tmc.fpm.business.mvc.service.control.factory.RelateReportDataManagerFactory;
import kd.tmc.fpm.business.mvc.service.dto.ReportCalculateDTO;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.bean.FpmContext;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.helper.AmountCurrencyRateHelper;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class ReportCalculateAsyncServiceImpl
implements ReportCalculateAsyncService {
    private static final Log logger = LogFactory.getLog(ReportCalculateAsyncServiceImpl.class);
    private static final Integer BATCH_SIZE = 5;
    private IReportDataSaveService reportDataSaveServiceWithMDD = FpmServiceFactory.getBizService(IReportDataSaveService.class);
    private IReportDataSaveService reportDataSaveService = new ReportDataSaveService();
    private IReportDataQueryService dataQueryService = new ReportDataQueryService();
    private ReportRepository reportRepository = new ReportRepository();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBeginEndSubjectRealAmount(String lockId, Set<Long> reportIds, Long reportPeriodId, FundPlanSystem system) {
        FpmAssertUtil.isNotEmpty(reportIds, (String)"report id list is empty");
        FpmAssertUtil.isNotNull((Object)system, (String)"system is empty");
        logger.info("ReportCalculateAsyncService.updateBeginEndSubjectRealAmount start, reportId:{}", (Object)reportIds.stream().map(Object::toString).collect(Collectors.joining(",")));
        try {
            boolean updateBeginEndSubjectRealAmount = MutexServiceHelper.request((String)lockId, (String)"tmc-fpm-business", (String)"updateBeginEndSubjectRealAmount");
            if (!updateBeginEndSubjectRealAmount) {
                String errorMsg = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"ReportCalculateAsyncServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            this.doUpdate(reportIds, system);
        }
        catch (Exception e) {
            logger.error("error is:", (Throwable)e);
        }
        finally {
            MutexServiceHelper.release((String)lockId, (String)"tmc-fpm-business", (String)"updateBeginEndSubjectRealAmount");
        }
    }

    private void doUpdate(Set<Long> reportIds, FundPlanSystem system) {
        FpmContext.get().put("dimMetric", EnumSet.of(TemplateMetricType.ACTMAT));
        Dimension subject = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        Map<Long, AccountMember> subjectMap = subject.getAllDimMemberList().stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection())).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        Set<Long> subjectMemberIds = subjectMap.keySet();
        if (CollectionUtils.isEmpty(subjectMemberIds)) {
            logger.info("ReportCalculateAsyncService.updateBeginEndSubjectRealAmount start, \u6ca1\u6709\u671f\u521d\u79d1\u76ee");
            return;
        }
        ArrayList sumPlanReportIdList = new ArrayList(16);
        List allReportPartition = Lists.partition(new ArrayList<Long>(reportIds), (int)BATCH_SIZE);
        for (List reportIdPart : allReportPartition) {
            List<ReportData> reportPlanReportData;
            List<Report> relateReports;
            List<Report> reports = this.reportRepository.loadSimpleReport(new HashSet<Long>(reportIdPart), t -> t.setNeedTemplate(true));
            if (CollectionUtils.isEmpty(reports)) continue;
            ArrayList<Long> reportPlanList = new ArrayList<Long>(16);
            Set sumPlanIds = reports.stream().filter(item -> item.getTemplate().getTemplateUse() == TemplateUseType.SUMMARY).map(Report::getId).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(sumPlanIds)) {
                reportIdPart.forEach(item -> {
                    if (!sumPlanIds.contains(item)) {
                        reportPlanList.add((Long)item);
                    }
                });
                sumPlanReportIdList.addAll(sumPlanIds);
            } else {
                reportPlanList.addAll(reportIdPart);
            }
            if (CollectionUtils.isEmpty(reportPlanList) || CollectionUtils.isEmpty(relateReports = this.reportDataPrepare(subject, subjectMemberIds, reportPlanList)) || CollectionUtils.isEmpty(reportPlanReportData = this.updateReportPlan(system, subjectMap, relateReports))) continue;
            Map<Long, List<ReportData>> collect = reportPlanReportData.stream().collect(Collectors.groupingBy(ReportData::getReportId));
            collect.forEach((k, v) -> this.reportDataSaveServiceWithMDD.saveReportData((List<ReportData>)v, system.getId()));
            logger.info("ReportCalculateAsyncService.updateBeginEndSubjectRealAmount \u4fdd\u5b58\u7f16\u5236\u8868\u5355\u5143\u683c\u6570\u636e");
        }
        List sumPlanPartition = Lists.partition(sumPlanReportIdList, (int)BATCH_SIZE);
        for (List reportIdPart : sumPlanPartition) {
            List<ReportData> sumPlanReportData;
            List<Report> relateReports = this.reportDataPrepare(subject, subjectMemberIds, reportIdPart);
            if (CollectionUtils.isEmpty(relateReports) || CollectionUtils.isEmpty(sumPlanReportData = this.updateSumReportPlan(system, subjectMap, relateReports))) continue;
            Map<Long, List<ReportData>> collect = sumPlanReportData.stream().collect(Collectors.groupingBy(ReportData::getReportId));
            collect.forEach((k, v) -> this.reportDataSaveService.saveReportData((List<ReportData>)v, system.getId()));
            logger.info("ReportCalculateAsyncService.updateBeginEndSubjectRealAmount \u4fdd\u5b58\u6c47\u603b\u5355\u5355\u5143\u683c\u6570\u636e");
        }
    }

    private List<Report> reportDataPrepare(Dimension subject, Set<Long> subjectMemberIds, List<Long> reportIdPart) {
        if (CollectionUtils.isEmpty(reportIdPart)) {
            logger.info("ReportCalculateAsyncService.updateBeginEndSubjectRealAmount \u5f53\u524d\u6279\u6b21\u65e0\u62a5\u8868\u9700\u8981\u5904\u7406");
            return null;
        }
        List<ReportData> allSubjectsReportData = this.dataQueryService.queryReportData(t -> {
            t.setReportIdS(Lists.newArrayList((Iterable)reportIdPart));
            t.setDimIdList(Collections.singletonList(subject));
            t.setDimValList(Collections.singletonList(new ArrayList(subjectMemberIds)));
            t.setNeedDimIfValueIsNotEmpty(true);
        });
        if (CollectionUtils.isEmpty(allSubjectsReportData)) {
            logger.info("ReportCalculateAsyncService.updateBeginEndSubjectRealAmount \u67e5\u8be2\u62a5\u8868\u65e0\u6570\u636e");
            return null;
        }
        if (CollectionUtils.isEmpty(allSubjectsReportData = allSubjectsReportData.stream().filter(item -> !item.isAuxiliaryInfo()).collect(Collectors.toList()))) {
            logger.info("ReportCalculateAsyncService.updateBeginEndSubjectRealAmount \u67e5\u8be2\u62a5\u8868\u65e0\u6570\u636e");
            return null;
        }
        List<Report> relateReports = RelateReportDataManagerFactory.getRelateReportDataManager(allSubjectsReportData).getRelateReports(allSubjectsReportData);
        if (CollectionUtils.isEmpty(relateReports)) {
            logger.info("ReportCalculateAsyncService.updateBeginEndSubjectRealAmount \u67e5\u8be2\u62a5\u8868\u5173\u8054\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        return relateReports;
    }

    private List<ReportData> updateReportPlan(FundPlanSystem system, Map<Long, AccountMember> subjectMap, List<Report> reportList) {
        List<Report> reportPlanList = reportList.stream().filter(item -> item.getTemplate().getTemplateUse() == TemplateUseType.PLANING).collect(Collectors.toList());
        return this.updateBeginEndSubjectAmt(system, subjectMap, reportPlanList);
    }

    private List<ReportData> updateSumReportPlan(FundPlanSystem system, Map<Long, AccountMember> subjectMap, List<Report> reportList) {
        List<Report> sumPlanReportList = reportList.stream().filter(item -> item.getTemplate().getTemplateUse() == TemplateUseType.SUMMARY).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sumPlanReportList)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return this.updateBeginEndSubjectAmt(system, subjectMap, sumPlanReportList);
    }

    private List<ReportData> updateBeginEndSubjectAmt(FundPlanSystem system, Map<Long, AccountMember> subjectMap, List<Report> reportList) {
        List<Report> mainReportList = reportList.stream().filter(item -> !item.getTemplate().getTemplateType().isDetail()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(mainReportList)) {
            logger.info("\u5f53\u524d\u62a5\u8868\u975e\u56fa\u5b9a\u8868\uff0c\u8df3\u8fc7\u671f\u521d\u671f\u672b\u5b9e\u9645\u6570\u8d4b\u503c\u903b\u8f91");
            return Lists.newArrayListWithCapacity((int)0);
        }
        Report mainReport = (Report)mainReportList.get(0);
        HashSet<Long> idSet = new HashSet<Long>();
        idSet.add(mainReport.getCurrentReportPeriod().getId());
        List<PeriodMember> currentReportPeriodDetail = mainReport.getCurrentReportPeriodDetail();
        if (!EmptyUtil.isEmpty(currentReportPeriodDetail)) {
            idSet.addAll(currentReportPeriodDetail.stream().map(DimMember::getId).collect(Collectors.toSet()));
        }
        List<ReportData> allReportData = mainReportList.stream().map(Report::getReportDataList).flatMap(Collection::stream).filter(item -> {
            Object value = item.getDimValByDimType(DimensionType.PERIOD);
            if (Objects.isNull(value)) {
                return false;
            }
            return idSet.contains((Long)value);
        }).filter(item -> !item.isAuxiliaryInfo()).collect(Collectors.toList());
        for (Report report : mainReportList) {
            List<ReportData> reportDataList = report.getReportDataList();
            List<ReportData> currentData = reportDataList.stream().filter(item -> {
                Object value = item.getDimValByDimType(DimensionType.PERIOD);
                if (Objects.isNull(value)) {
                    return false;
                }
                return idSet.contains((Long)value);
            }).filter(item -> !item.isAuxiliaryInfo()).collect(Collectors.toList());
            report.setReportDataList(currentData);
        }
        PeriodMember firstPeriodMember = ReportHelper.getFirstPeriod(mainReport);
        List<ReportData> firstPeriodBeginSubjectReportData = this.updateFirstPeriodBeginSubjectReportData(subjectMap, firstPeriodMember, allReportData);
        ArrayList<ReportData> result = new ArrayList<ReportData>(allReportData.size());
        Consumer<Report> reportUpdateActConsumer = this.updateActMount(firstPeriodBeginSubjectReportData);
        Consumer<Report> reportCalculateConsumer = this.calculateReport(system);
        mainReportList.forEach(this.updateAndGetResult(system, reportUpdateActConsumer, reportCalculateConsumer, subjectMap, result));
        return result;
    }

    private Consumer<Report> updateAndGetResult(FundPlanSystem system, Consumer<Report> reportUpdateActConsumer, Consumer<Report> reportCalculateConsumer, Map<Long, AccountMember> subjectMap, List<ReportData> result) {
        return report -> {
            reportUpdateActConsumer.accept((Report)report);
            report.rebuildTree(system);
            reportCalculateConsumer.accept((Report)report);
            PeriodMember periodMember = report.getPeriodMemberList().get(0);
            report.sumToParentPeriodByScope(Lists.newArrayList((Object[])new PeriodMember[]{periodMember}), system, false);
            List otherReportDataList = report.getReportDataList().stream().filter(item -> Objects.isNull(item.getId())).collect(Collectors.toList());
            report.getReportDataList().removeAll(otherReportDataList);
            result.addAll(report.getReportDataList());
        };
    }

    private Consumer<Report> calculateReport(FundPlanSystem system) {
        ReportCalculateService calculateService = ReportCalculateServiceFactory.getService();
        return report -> {
            TemplateUseType templateUse = report.getTemplate().getTemplateUse();
            if (TemplateUseType.PLANING == templateUse) {
                ReportCalculateDTO reportCalculateDTO = new ReportCalculateDTO();
                reportCalculateDTO.setReport((ReportDataSource)report);
                reportCalculateDTO.setSystem(system);
                calculateService.calculateReport(reportCalculateDTO);
            } else {
                List remainReportDataIds = report.getReportDataList().stream().map(ReportData::getSourceIdList).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                if (EmptyUtil.isEmpty(remainReportDataIds)) {
                    logger.warn("\u6240\u6709\u5173\u8054\u6570\u636e\u90fd\u4e3a\u7a7a");
                    return;
                }
                List<ReportData> sourceReportDataList = this.dataQueryService.queryReportData(t -> t.setIdList(remainReportDataIds));
                if (EmptyUtil.isEmpty(sourceReportDataList)) {
                    logger.warn("\u6240\u6709\u5173\u8054\u6570\u636e\u90fd\u4e3a\u7a7a");
                    return;
                }
                Map sourceReportDataMap = sourceReportDataList.stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
                for (ReportData sumReportData : report.getReportDataList()) {
                    sumReportData.setActAmt(BigDecimal.ZERO);
                    List<Long> sourceIdList = sumReportData.getSourceIdList();
                    for (Long sourceId : sourceIdList) {
                        ReportData sourceReportData = (ReportData)sourceReportDataMap.get(sourceId);
                        if (Objects.isNull(sourceReportData)) {
                            logger.warn("sourceReportData is empty, source id:{}", (Object)sourceId);
                            continue;
                        }
                        BigDecimal convertActAmt = AmountCurrencyRateHelper.convertAmt((BigDecimal)sourceReportData.getActAmt(), (AmountUnitEnum)AmountUnit.convert(sourceReportData.getAmountUnit()), (AmountUnitEnum)AmountUnit.convert(sumReportData.getAmountUnit()));
                        sumReportData.addActAmt(convertActAmt);
                    }
                }
            }
        };
    }

    private Consumer<Report> updateActMount(List<ReportData> firstPeriodBeginSubjectReportData) {
        return report -> {
            Map sourceDataMap = report.getReportDataList().stream().collect(Collectors.toMap(ReportData::getId, Function.identity()));
            firstPeriodBeginSubjectReportData.forEach(rd -> {
                ReportData reportData = (ReportData)sourceDataMap.get(rd.getId());
                if (Objects.nonNull(reportData)) {
                    reportData.setActAmt(rd.getActAmt());
                }
            });
        };
    }

    private Map<Long, Map<Long, ReportData>> getCurrentPeriodAllReportData(Report mainReport, List<ReportData> allReportData) {
        List<PeriodMember> currentReportPeriodDetail = mainReport.getCurrentReportPeriodDetail();
        Set periodIds = currentReportPeriodDetail.stream().map(DimMember::getId).collect(Collectors.toSet());
        PeriodMember currentReportPeriod = mainReport.getCurrentReportPeriod();
        periodIds.add(currentReportPeriod.getId());
        List allReportDataByCurrentPeriod = allReportData.stream().filter(item -> periodIds.contains((Long)item.getDimValByDimType(DimensionType.PERIOD))).collect(Collectors.toList());
        return allReportDataByCurrentPeriod.stream().collect(Collectors.groupingBy(ReportData::getReportId, Collectors.toMap(ReportData::getId, Function.identity())));
    }

    private List<ReportData> updateFirstPeriodBeginSubjectReportData(Map<Long, AccountMember> subjectMap, PeriodMember firstPeriodMember, List<ReportData> allReportData) {
        Map<Object, List<ReportData>> reportDataMapByPeriod = allReportData.stream().collect(Collectors.groupingBy(i -> i.getDimValByDimType(DimensionType.PERIOD)));
        logger.info("ReportCalculateAsyncService.updateBeginEndSubjectRealAmount \u5f53\u524d\u7f16\u62a5\u7684\u7b2c\u4e00\u4e2a\u671f\u95f4\uff1a{}", (Object)firstPeriodMember.getId());
        List<ReportData> firstPeriodReportData = reportDataMapByPeriod.get(firstPeriodMember.getId());
        List<ReportData> firstPeriodBeginSubjectReportData = firstPeriodReportData.stream().filter(item -> {
            Object subjectId = item.getDimValByDimType(DimensionType.SUBJECTS);
            AccountMember accountMember = (AccountMember)subjectMap.get((Long)subjectId);
            if (Objects.isNull(accountMember)) {
                return false;
            }
            if (!accountMember.isPeriodAccount()) {
                return false;
            }
            return PeriodDirection.BEGINNING == accountMember.getPeriodDirection();
        }).collect(Collectors.toList());
        firstPeriodBeginSubjectReportData.forEach(item -> {
            item.setActAmt(item.getPlanAmt());
            logger.info("ReportCalculateAsyncService.updateBeginEndSubjectRealAmount \u66f4\u65b0\u5b9e\u9645\u6570, entryId:{}, actmount:{}", (Object)item.getId(), (Object)item.getActAmt());
        });
        return firstPeriodBeginSubjectReportData;
    }

    private PeriodMember getFirstPeriodMember(Report mainReport) {
        List<PeriodMember> currentReportPeriodDetail = mainReport.getCurrentReportPeriodDetail();
        boolean hasDetail = !CollectionUtils.isEmpty(currentReportPeriodDetail);
        PeriodMember currentReportPeriod = mainReport.getCurrentReportPeriod();
        currentReportPeriodDetail.add(currentReportPeriod);
        PeriodMember firstPeriodMember = currentReportPeriod;
        if (hasDetail) {
            firstPeriodMember = currentReportPeriodDetail.stream().min(Comparator.comparing(PeriodMember::getStartDate)).get();
        }
        return firstPeriodMember;
    }
}

