/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.calculate.impl;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.formula.ReportTreeNodeFormulaManager;
import kd.tmc.fpm.business.domain.model.calculate.ReportDataFormula;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.calculate.AbstractCalculateService;
import kd.tmc.fpm.business.mvc.service.dto.ReportCalculateDTO;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import org.apache.commons.collections.CollectionUtils;

public class ReportTreeNodeScopeCalculateServiceImpl
extends AbstractCalculateService {
    private static final Log LOGGER = LogFactory.getLog(ReportTreeNodeScopeCalculateServiceImpl.class);

    @Override
    protected <T extends ReportData> List<T> executeCalculate(ReportCalculateDTO calculateDTO, List<ReportDataFormula> formulaResult) {
        List<ReportData> scopeData = calculateDTO.getScopeData();
        if (CollectionUtils.isEmpty(scopeData)) {
            LOGGER.warn("scope date is empty, stop calculate");
            return Lists.newArrayListWithCapacity((int)0);
        }
        DimensionIndexTree indexTree = calculateDTO.getCustomIndexTree();
        FpmAssertUtil.isNotNull((Object)indexTree, (String)"index tree is null");
        List<TreeNode> treeNodeList = scopeData.stream().map(item -> {
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getMainDimensionInfoBean(item);
            return indexTree.find(dimensionInfoBean);
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(treeNodeList)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        List<Formula> formulaList = formulaResult.stream().map(ReportDataFormula::getFormula).collect(Collectors.toList());
        ReportTreeNodeFormulaManager formulaManager = new ReportTreeNodeFormulaManager(formulaList);
        List<TreeNode> treeNodes = formulaManager.updateData(treeNodeList);
        if (CollectionUtils.isEmpty(treeNodes)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        List updateResult = treeNodes.stream().map(TreeNode::getDataList).flatMap(Collection::stream).filter(i -> i instanceof ReportData).map(i -> (ReportData)i).collect(Collectors.toList());
        return updateResult;
    }
}

