/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.calculate.strategy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.model.calculate.ReportDataFormula;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.FormulaHelper;
import kd.tmc.fpm.business.mvc.enums.BizFormulaTypeEnum;
import kd.tmc.fpm.business.mvc.service.calculate.FormulaGenerateStrategy;
import kd.tmc.fpm.business.mvc.service.dto.ReportCalculateDTO;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class SubjectPeriodFormulaGenerateStrategy
implements FormulaGenerateStrategy {
    private static final Log LOGGER = LogFactory.getLog(SubjectPeriodFormulaGenerateStrategy.class);

    @Override
    public List<ReportDataFormula> generateFormula(ReportCalculateDTO calculateDTO) {
        ReportDataSource report = calculateDTO.getReport();
        FundPlanSystem system = calculateDTO.getSystem();
        Map<Long, Long> beginEndPeriodMap = DimensionInfoHelper.getBeginEndSubjectMap(system);
        if (MapUtils.isEmpty(beginEndPeriodMap)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        ReportTemplate template = report.getTemplate();
        Set templateFormulaSubjectIds = template.getAccountSettings().stream().filter(item -> item.getInputType() == ReportInputType.FORMULA || item.getInputType() == ReportInputType.DETAIL_INPUT).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
        Map<Long, String> accountFormulaMap = template.getAccountSettings().stream().filter(item -> item.getInputType() == ReportInputType.FORMULA).collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, TemplateAccountSetting::getFormula));
        Map<Long, List<AccountMember>> beginMultiMapEnd = subjectDim.getAllDimMemberList(AccountMember.class).stream().filter(i -> Objects.nonNull(i.getPeriodDirection()) && Objects.nonNull(i.getAssociateAccount())).filter(i -> accountFormulaMap.containsKey(i.getId())).sorted(Comparator.comparing(DimMember::getSortCode)).collect(Collectors.groupingBy(i -> i.getAssociateAccount().getId()));
        List sortedPeriodList = report.getCurrentAllPeriodMembers().stream().sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        Map<Long, Long> previousPeriodMap = IntStream.range(0, sortedPeriodList.size()).boxed().collect(Collectors.toMap(i -> ((PeriodMember)sortedPeriodList.get((int)i)).getId(), i -> i > 0 ? ((PeriodMember)sortedPeriodList.get(i - 1)).getId() : 0L));
        Map<Long, Long> multiEndFindOneFormulaMap = this.multiEndFindOneFormula(accountFormulaMap, beginMultiMapEnd);
        DimensionIndexTree indexTree = report.getIndexTree(system);
        List<ReportData> reportDataList = report.getReportDataList();
        ArrayList<ReportDataFormula> result = new ArrayList<ReportDataFormula>(reportDataList.size());
        for (ReportData reportData : reportDataList) {
            List<ReportData> lastPeriodReportData;
            AccountMember beginMember;
            Long accountId;
            Object memId;
            if (reportData.isAuxiliaryInfo() || Objects.isNull(memId = reportData.getDimValByDimType(DimensionType.SUBJECTS)) || !beginEndPeriodMap.containsKey(accountId = (Long)memId) || (beginMember = subjectDim.getDimMemberById(accountId, AccountMember.class)).getInputType() != ReportInputType.MANUAL_INPUT || templateFormulaSubjectIds.contains(accountId)) continue;
            Long endId = this.checkMultiEndSubject(multiEndFindOneFormulaMap, beginMultiMapEnd, accountId);
            if (!NumberUtils.equalsZero((Long)endId)) {
                beginEndPeriodMap.put(accountId, endId);
            }
            if (Objects.isNull(lastPeriodReportData = this.findLastPeriodReportData(indexTree, reportData, reportDataList, beginEndPeriodMap, previousPeriodMap))) continue;
            List<String> idList = lastPeriodReportData.stream().map(item -> item.getId().toString()).collect(Collectors.toList());
            Formula formula = FormulaHelper.getFormula(idList, reportData);
            ReportDataFormula reportDataFormula = new ReportDataFormula();
            reportDataFormula.setFormulaType(BizFormulaTypeEnum.SUBJECT_BEGIN_END);
            reportDataFormula.setReportData(reportData);
            reportDataFormula.setFormula(formula);
            result.add(reportDataFormula);
        }
        return result;
    }

    private Long checkMultiEndSubject(Map<Long, Long> accountFormulaMap, Map<Long, List<AccountMember>> beginMultiMapEnd, Long beginId) {
        Long endId = 0L;
        List<AccountMember> accountMembers = beginMultiMapEnd.get(beginId);
        if (CollectionUtils.isNotEmpty(accountMembers) && accountMembers.size() > 1) {
            Long onlyOneFormulaLinkBegin = accountFormulaMap.get(beginId);
            if (Objects.nonNull(onlyOneFormulaLinkBegin)) {
                endId = onlyOneFormulaLinkBegin;
            } else {
                AccountMember lastOneEndMember = accountMembers.get(accountMembers.size() - 1);
                endId = lastOneEndMember.getId();
            }
        }
        return endId;
    }

    private List<ReportData> findLastPeriodReportData(DimensionIndexTree indexTree, ReportData reportData, List<ReportData> reportDataList, Map<Long, Long> beginEndPeriodMap, Map<Long, Long> previousPeriodMap) {
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        TemplateDim subjectDim = dimList.stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst().get();
        DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
        int accountIndex = dimList.indexOf(subjectDim);
        Long subjectMemberId = (Long)dimValList.get(accountIndex);
        DimensionInfoHelper.replaceDimValue(dimensionInfoBean, subjectDim.getDimensionId(), beginEndPeriodMap.get(subjectMemberId));
        TemplateDim periodDim = dimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get();
        int periodIndex = dimList.indexOf(periodDim);
        Long periodMemberId = (Long)dimValList.get(periodIndex);
        Long previousPeriodMemberId = previousPeriodMap.get(periodMemberId);
        if (!previousPeriodMap.containsKey(periodMemberId) || !EmptyUtil.isNoEmpty((Long)previousPeriodMemberId)) {
            return null;
        }
        int dimPeriodIndex = dimensionInfoBean.getDimensionIdList().indexOf(periodDim.getDimensionId());
        dimensionInfoBean.getMemberIdList().set(dimPeriodIndex, previousPeriodMemberId);
        try {
            TreeNode treeNode = indexTree.find(dimensionInfoBean);
            if (treeNode != null) {
                List<Object> dataList = treeNode.getDataList();
                if (CollectionUtils.isNotEmpty(dataList)) {
                    return dataList.stream().map(item -> (ReportData)item).collect(Collectors.toList());
                }
            } else {
                LOGGER.warn("ReportService findLastPeriodReportData tree node is null, reportData:{},dimId:{},targetDimValList:{}", new Object[]{reportData.getId(), dimensionInfoBean.getDimensionIdList(), dimensionInfoBean.getMemberIdList()});
            }
        }
        catch (Exception e) {
            LOGGER.warn("reportData:{},dimId:{},targetDimValList:{}", new Object[]{reportData.getId(), dimensionInfoBean.getDimensionIdList(), dimensionInfoBean.getMemberIdList(), e});
        }
        return null;
    }

    private Map<Long, Long> multiEndFindOneFormula(Map<Long, String> accountFormulaMap, Map<Long, List<AccountMember>> beginMultiMapEnd) {
        HashMap<Long, Long> endFormulaLinkMap = new HashMap<Long, Long>(1);
        for (Map.Entry<Long, List<AccountMember>> entry : beginMultiMapEnd.entrySet()) {
            AccountMember accountMember;
            Long beginId = entry.getKey();
            List<AccountMember> accountMembers = entry.getValue();
            if (!CollectionUtils.isNotEmpty(accountMembers) || accountMembers.size() <= 1) continue;
            ArrayList<Integer> matchIndex = new ArrayList<Integer>(accountMembers.size());
            for (int i = 0; i < accountMembers.size(); ++i) {
                AccountMember accountMember2 = accountMembers.get(i);
                String formula = accountFormulaMap.get(accountMember2.getId());
                if (EmptyUtil.isEmpty((String)formula) || !formula.contains(beginId.toString())) continue;
                matchIndex.add(i);
            }
            if (matchIndex.size() != 1 || !Objects.nonNull(accountMember = accountMembers.get((Integer)matchIndex.get(0)))) continue;
            endFormulaLinkMap.put(beginId, accountMember.getId());
        }
        return endFormulaLinkMap;
    }
}

