/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.calculate.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.model.calculate.ReportDataFormula;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.FormulaHelper;
import kd.tmc.fpm.business.mvc.enums.BizFormulaTypeEnum;
import kd.tmc.fpm.business.mvc.service.calculate.FormulaGenerateStrategy;
import kd.tmc.fpm.business.mvc.service.dto.ReportCalculateDTO;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public class SummaryFormulaGenerateStrategy
implements FormulaGenerateStrategy {
    private static final Log LOGGER = LogFactory.getLog(SummaryFormulaGenerateStrategy.class);

    @Override
    public List<ReportDataFormula> generateFormula(ReportCalculateDTO calculateDTO) {
        ReportDataSource report = calculateDTO.getReport();
        FundPlanSystem system = calculateDTO.getSystem();
        ReportTemplate template = report.getTemplate();
        List summaryAcctSettings = template.getAccountSettings().stream().filter(Objects::nonNull).filter(item -> ReportInputType.SUMMARY == item.getInputType()).collect(Collectors.toList());
        Map accountSettingMap = summaryAcctSettings.stream().collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, Function.identity()));
        DimensionIndexTree indexTree = report.getIndexTree(system);
        List<ReportData> reportDataList = report.getReportDataList();
        ArrayList<ReportDataFormula> result = new ArrayList<ReportDataFormula>(reportDataList.size());
        for (ReportData reportData : reportDataList) {
            List<ReportData> coords;
            TemplateAccountSetting templateAccountSetting;
            Object accountId;
            if (reportData.isAuxiliaryInfo() || Objects.isNull(accountId = reportData.getDimValByDimType(DimensionType.SUBJECTS)) || Objects.isNull(templateAccountSetting = (TemplateAccountSetting)accountSettingMap.get((Long)accountId)) || EmptyUtil.isEmpty(coords = this.findChildReportData(reportData, templateAccountSetting, indexTree))) continue;
            Formula formula = FormulaHelper.getFormula(reportData, coords);
            ReportDataFormula reportDataFormula = new ReportDataFormula();
            reportDataFormula.setFormulaType(BizFormulaTypeEnum.SUBJECT_SUM);
            reportDataFormula.setReportData(reportData);
            reportDataFormula.setFormula(formula);
            result.add(reportDataFormula);
        }
        return result;
    }

    private List<ReportData> findChildReportData(ReportData reportData, TemplateAccountSetting acctSetting, DimensionIndexTree indexTree) {
        List<TemplateAccountSetting> children = acctSetting.getChildren();
        if (children == null || children.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ReportData> coords = new ArrayList<ReportData>(children.size());
        for (TemplateAccountSetting childAcctSetting : children) {
            Long childAcctMemId = childAcctSetting.getAccountMemId();
            List<Object> result = Lists.newArrayList();
            DimensionInfoBean dimensionInfoBean = this.getDimensionInfoBean(reportData, childAcctMemId);
            try {
                result = this.findAcctReportData(indexTree, reportData, dimensionInfoBean);
            }
            catch (Exception e) {
                LOGGER.warn("reportData:{}\uff0cchildSubjectId:{}", new Object[]{reportData.getId(), childAcctMemId, e});
            }
            if (CollectionUtils.isEmpty((Collection)result)) {
                LOGGER.info("\u8ba1\u5212\u7f16\u5236id\uff1a{},\u8ba1\u5212\u79d1\u76eeid\uff1a{}", (Object)reportData.getId(), (Object)childAcctMemId);
            }
            coords.addAll(result);
        }
        return coords;
    }

    private List<ReportData> findAcctReportData(DimensionIndexTree indexTree, ReportData reportData, DimensionInfoBean dimensionInfoBean) {
        List<Object> result = Lists.newArrayList();
        TreeNode treeNode = indexTree.find(dimensionInfoBean);
        if (treeNode != null) {
            List<Object> dataList = treeNode.getDataList();
            if (CollectionUtils.isNotEmpty(dataList)) {
                result = dataList.stream().map(item -> (ReportData)item).collect(Collectors.toList());
            }
        } else {
            LOGGER.warn("ReportService findAcctReportData tree node is null, reportData:{},dimId:{},targetDimValList:{}", new Object[]{reportData.getId(), dimensionInfoBean.getDimensionIdList(), dimensionInfoBean.getMemberIdList()});
        }
        return result;
    }

    private DimensionInfoBean getDimensionInfoBean(ReportData reportData, Long childAcctMemId) {
        List<TemplateDim> dimList = reportData.getDimList();
        TemplateDim templateDim = dimList.stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst().get();
        DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
        DimensionInfoHelper.replaceDimValue(dimensionInfoBean, templateDim.getDimensionId(), childAcctMemId);
        return dimensionInfoBean;
    }
}

