/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.control.factory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kd.bos.exception.KDBizException;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.mvc.service.IControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.ActualCancelControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.ActualReleaseControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.ActualUpdateControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.ActualWriteControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.ControlUpdateInfoWriteExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.DetailCurrentControlDataFillControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.FailedControlExecuteParamProcessControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.FailoverControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.FastFailControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.GenericReleaseControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.MatchInfoReportDataSelectorControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.NewMatchInfoBackFillControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.PlanExecuteRecordBackFillControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.PreOccupyCancelControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.PreOccupyControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.PreOccupyReleaseControlExecuteStrategy;

public class ControlStrategyFactory {
    private static final Map<PlanExecuteOpType, Function<ControlContext, IControlExecuteStrategy>> STRATEGY_MAP;

    public static IControlExecuteStrategy getControlStrategy(ControlContext controlContext) {
        PlanExecuteOpType planExecuteOpType = controlContext.getPlanExecuteOpType();
        if (!STRATEGY_MAP.containsKey(planExecuteOpType)) {
            throw new KDBizException("PlanExecuteOpType:" + planExecuteOpType.getValue() + " strategy not register");
        }
        return ControlStrategyFactory.wrapIfNeed(controlContext, STRATEGY_MAP.get(planExecuteOpType).apply(controlContext));
    }

    private static IControlExecuteStrategy wrapIfNeed(ControlContext controlContext, IControlExecuteStrategy controlExecuteStrategy) {
        if (!(controlExecuteStrategy instanceof AbstractControlExecuteStrategy)) {
            return controlExecuteStrategy;
        }
        AbstractControlExecuteStrategy strategy = (AbstractControlExecuteStrategy)controlExecuteStrategy;
        if (controlContext.getPlanExecuteOpType().isOccupy()) {
            return ControlStrategyFactory.wrapProcessError(controlContext, new FailedControlExecuteParamProcessControlExecuteStrategy(strategy));
        }
        return ControlStrategyFactory.wrapProcessError(controlContext, new FailedControlExecuteParamProcessControlExecuteStrategy(new ControlUpdateInfoWriteExecuteStrategy(strategy)));
    }

    private static IControlExecuteStrategy wrapProcessError(ControlContext controlContext, AbstractControlExecuteStrategy strategy) {
        if (controlContext.getPlanExecuteOpType().isOccupyOp()) {
            return new FastFailControlExecuteStrategy(strategy);
        }
        return new FailoverControlExecuteStrategy(strategy);
    }

    static {
        HashMap<PlanExecuteOpType, Function<ControlContext, IControlExecuteStrategy>> strategyMap = new HashMap<PlanExecuteOpType, Function<ControlContext, IControlExecuteStrategy>>(16);
        strategyMap.put(PlanExecuteOpType.PRE_OCCUPY_WRITE, ctx -> new NewMatchInfoBackFillControlExecuteStrategy(new MatchInfoReportDataSelectorControlExecuteStrategy(new PreOccupyControlExecuteStrategy((ControlContext)ctx))));
        strategyMap.put(PlanExecuteOpType.WRITE, ctx -> new NewMatchInfoBackFillControlExecuteStrategy(new MatchInfoReportDataSelectorControlExecuteStrategy(new ActualWriteControlExecuteStrategy((ControlContext)ctx))));
        strategyMap.put(PlanExecuteOpType.PRE_OCCUPY_DELETE, ctx -> new PlanExecuteRecordBackFillControlExecuteStrategy(new DetailCurrentControlDataFillControlExecuteStrategy(new PreOccupyCancelControlExecuteStrategy((ControlContext)ctx))));
        strategyMap.put(PlanExecuteOpType.PRE_OCCUPY_RELEASE, ctx -> new GenericReleaseControlExecuteStrategy(new PreOccupyReleaseControlExecuteStrategy((ControlContext)ctx)));
        strategyMap.put(PlanExecuteOpType.CANCEL, ctx -> new PlanExecuteRecordBackFillControlExecuteStrategy(new ActualCancelControlExecuteStrategy((ControlContext)ctx)));
        strategyMap.put(PlanExecuteOpType.RELEASE, ctx -> new GenericReleaseControlExecuteStrategy(new ActualReleaseControlExecuteStrategy((ControlContext)ctx)));
        strategyMap.put(PlanExecuteOpType.UPDATE, ActualUpdateControlExecuteStrategy::new);
        STRATEGY_MAP = Collections.unmodifiableMap(strategyMap);
    }
}

