/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.control.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.impl.RelateReportDataManager;
import kd.tmc.fpm.business.utils.CommonUtils;

public class RelateReportDataManagerFactory {
    public static IRelateReportDataManager getRelateReportDataManager(List<ReportData> sourceReportDataList) {
        return RelateReportDataManagerFactory.getRelateReportDataManager(sourceReportDataList, null);
    }

    public static IRelateReportDataManager getRelateReportDataManager(List<ReportData> sourceReportDataList, ControlContext controlContext) {
        return new RelateReportDataManager(sourceReportDataList, controlContext);
    }

    public static IRelateReportDataManager getRelateReportDataManagerInstance(List<ReportData> sourceReportDataList, FundPlanSystem system) {
        ControlContext controlContext = new ControlContext();
        controlContext.addSystem(system);
        return RelateReportDataManagerFactory.getRelateReportDataManager(sourceReportDataList, controlContext);
    }

    public static IRelateReportDataManager getUpdateRelateReportDataManager(List<ReportData> sourceReportDataList, IRelateReportDataManager relateReportDataManager) {
        if (relateReportDataManager == null) {
            return RelateReportDataManagerFactory.getRelateReportDataManager(sourceReportDataList);
        }
        Set sourceReportDataIds = sourceReportDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
        Set<Long> originalSourceReportDataIds = relateReportDataManager.getSourceReportDataIds();
        if (originalSourceReportDataIds.containsAll(sourceReportDataIds)) {
            return relateReportDataManager;
        }
        ArrayList<ReportData> newSourceReportData = new ArrayList<ReportData>(sourceReportDataList);
        newSourceReportData.addAll(relateReportDataManager.getSourceReportData());
        ControlContext controlContext = null;
        if (relateReportDataManager instanceof RelateReportDataManager) {
            controlContext = ((RelateReportDataManager)relateReportDataManager).getControlContext();
        }
        return RelateReportDataManagerFactory.getRelateReportDataManager(CommonUtils.getDistinctList(newSourceReportData, ReportData::getId), controlContext);
    }
}

