/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.control.trace.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceIdInfo;
import kd.tmc.fpm.business.mvc.service.IControlTraceService;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.control.trace.IBillTraceIdManager;
import kd.tmc.fpm.business.mvc.service.control.trace.IControlTraceStrategy;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class DefaultBillTraceIdManager
implements IBillTraceIdManager {
    protected static final Log logger = LogFactory.getLog(DefaultBillTraceIdManager.class);
    protected IControlTraceService controlTraceService = FpmServiceFactory.getBizService(IControlTraceService.class);
    protected List<IControlTraceStrategy> controlTraceStrategyList = new ArrayList<IControlTraceStrategy>(8);
    protected ControlContext controlContext;

    public DefaultBillTraceIdManager(ControlContext controlContext) {
        this.controlContext = controlContext;
    }

    public DefaultBillTraceIdManager addControlTraceStrategy(IControlTraceStrategy controlTraceStrategy) {
        if (this.controlTraceStrategyList.contains(controlTraceStrategy)) {
            return this;
        }
        this.controlTraceStrategyList.add(controlTraceStrategy);
        return this;
    }

    @Override
    public ControlTraceIdInfo getControlTraceIdInfo(List<BillBizInfo> billBizInfoList) {
        billBizInfoList = billBizInfoList.stream().distinct().collect(Collectors.toList());
        ControlTraceIdInfo controlTraceIds = this.controlTraceService.getControlTraceIds(billBizInfoList);
        if (EmptyUtil.isEmpty(this.controlTraceStrategyList)) {
            return controlTraceIds;
        }
        for (IControlTraceStrategy controlTraceStrategy : this.controlTraceStrategyList) {
            controlTraceStrategy.processControlTraceIds(billBizInfoList, controlTraceIds);
        }
        return controlTraceIds;
    }
}

