/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.dimmapping.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ControlMatchType;
import kd.tmc.fpm.business.domain.enums.MatchPropType;
import kd.tmc.fpm.business.domain.model.control.DimensionMemberMappingParam;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.dimension.DimMemberMapping;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.MappingInfo;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.match.DimMatchEvent;
import kd.tmc.fpm.business.mvc.service.dimmapping.IDimMatchFailedLister;
import kd.tmc.fpm.business.mvc.service.dimmapping.IDimMatchListener;
import kd.tmc.fpm.business.mvc.service.dimmapping.IDimMatchSuccessListener;
import kd.tmc.fpm.business.mvc.service.dimmapping.IDimensionMemberMappingManager;
import kd.tmc.fpm.business.mvc.service.dimmapping.impl.DimensionMemberMappingManager;
import kd.tmc.fpm.business.provider.DimMappingBaseDataProvider;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.helper.StringHelper;

public abstract class AbstractDimensionMemberMappingManager<T>
implements IDimensionMemberMappingManager<T> {
    protected static final Log logger = LogFactory.getLog(DimensionMemberMappingManager.class);
    protected Set<Long> dimensionIds = new HashSet<Long>(8);
    protected boolean matchAll;

    public AbstractDimensionMemberMappingManager<T> matchAll() {
        this.matchAll = true;
        return this;
    }

    @Override
    public void process(List<DimensionMemberMappingParam<T>> dimensionMemberMappingParamList) {
        if (EmptyUtil.isEmpty(dimensionMemberMappingParamList)) {
            return;
        }
        if (!this.matchAll && EmptyUtil.isEmpty(this.dimensionIds)) {
            return;
        }
        if (EmptyUtil.isEmpty(this.dimensionIds)) {
            dimensionMemberMappingParamList.stream().map(DimensionMemberMappingParam::getFundPlanSystem).map(FundPlanSystem::getMainDimList).flatMap(Collection::stream).filter(Objects::nonNull).map(Dimension::getId).forEach(this.dimensionIds::add);
        }
        logger.info("\u5339\u914d\u7ef4\u5ea6:{}", this.dimensionIds);
        Iterator<DimensionMemberMappingParam<T>> iterator = dimensionMemberMappingParamList.iterator();
        while (iterator.hasNext()) {
            DimensionMemberMappingParam<Object> next = iterator.next();
            if (Objects.isNull(next.getBillMatchRule())) {
                iterator.remove();
                continue;
            }
            if (Objects.isNull(next.getBillBizInfo())) {
                iterator.remove();
                continue;
            }
            if (Objects.isNull(next.getFundPlanSystem())) {
                iterator.remove();
                continue;
            }
            if (!Objects.isNull(next.getCallBack())) continue;
            next.setCallBack((d, t) -> {});
        }
        this.doProcess(dimensionMemberMappingParamList);
    }

    public AbstractDimensionMemberMappingManager<T> addDimensionId(Long dimensionId) {
        this.dimensionIds.add(dimensionId);
        return this;
    }

    protected abstract void doProcess(List<DimensionMemberMappingParam<T>> var1);

    protected void notifyFailed(IDimMatchListener dimMatchListener, Supplier<DimMatchEvent> dimMatchEventSupplier) {
        if (Objects.nonNull(dimMatchListener) && dimMatchListener instanceof IDimMatchFailedLister) {
            ((IDimMatchFailedLister)dimMatchListener).failed(dimMatchEventSupplier.get());
        }
    }

    protected void notifySuccess(IDimMatchListener dimMatchListener, Supplier<DimMatchEvent> dimMatchEventSupplier) {
        if (Objects.nonNull(dimMatchListener) && dimMatchListener instanceof IDimMatchSuccessListener) {
            ((IDimMatchSuccessListener)dimMatchListener).success(dimMatchEventSupplier.get());
        }
    }

    protected Predicate<DimMember> getDimensionPredicate(MatchMapping dimensionMatchMapping, Object bizPropValue) {
        ControlMatchType match = dimensionMatchMapping.getMatchType();
        MatchPropType matchPropType = dimensionMatchMapping.getMatchPropType();
        return dimMember -> {
            if (matchPropType == null) {
                return match.match(StringHelper.getStringValue((Object)bizPropValue), dimMember);
            }
            if (matchPropType == MatchPropType.NAME) {
                return match.match(StringHelper.getStringValue((Object)bizPropValue), dimMember.getName());
            }
            if (matchPropType == MatchPropType.NUMBER) {
                return match.match(StringHelper.getStringValue((Object)bizPropValue), dimMember.getNumber());
            }
            return false;
        };
    }

    protected Long getDimMappingMemberId(MatchMapping matchMapping, Map<String, Object> bizPropsMap, DimMappingBaseDataProvider dimMappingBaseDataProvider) {
        DimMemberMapping dimMapping = matchMapping.getDimMapping();
        if (Objects.isNull(dimMapping)) {
            return 0L;
        }
        ControlMatchType match = matchMapping.getMatchType();
        String bizProp = matchMapping.getBizProp();
        String assistBizProp = matchMapping.getAssistBizProp();
        Object bizPropValue = bizPropsMap.get(bizProp);
        Object assistBizValue = bizPropsMap.get(assistBizProp);
        MatchPropType matchPropType = CommonUtils.getOrDefault(matchMapping.getMatchPropType(), MatchPropType.NAME);
        List<MappingInfo> mappings = dimMapping.getMappings();
        for (MappingInfo mappingInfo : mappings) {
            DynamicObject baseData;
            Long assistId = mappingInfo.getAssistId();
            Long mainId = mappingInfo.getMainId();
            if (dimMapping.isAssistEntity()) {
                DynamicObject assistBaseData = dimMappingBaseDataProvider.getBaseData(dimMapping.getAssistEntityType(), assistId);
                if (Objects.isNull(assistBaseData)) continue;
                String assistName = assistBaseData.getString(matchPropType.getNumber().toLowerCase());
                if (!match.match(StringHelper.getStringValue((Object)assistBizValue), assistName)) continue;
            }
            if (Objects.isNull(baseData = dimMappingBaseDataProvider.getBaseData(dimMapping.getMainEntityType(), mainId))) continue;
            String mainName = baseData.getString(matchPropType.getNumber().toLowerCase());
            if (!match.match(StringHelper.getStringValue((Object)bizPropValue), mainName)) continue;
            Long memberId = mappingInfo.getMemberId();
            logger.info("\u6309\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\u5339\u914d\u5230\u7ef4\u5ea6:{}\uff0c\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5:{},\u7ef4\u5ea6\u6210\u5458\u6620\u5c04\uff1a{}\uff0c\u4e3b\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5:{}", new Object[]{memberId, bizProp, dimMapping.getName(), mainName});
            return memberId;
        }
        return 0L;
    }
}

